<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once 'config.php';

$current_page = basename($_SERVER['PHP_SELF']);

// Pages that don't need login
$public_pages = ['login.php', 'reset_password.php'];

if (!isset($_SESSION['admin_id']) && !in_array($current_page, $public_pages)) {
    header("Location: login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GS Caltex — <?= $page_title ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        /* ============================================================
           VARIABLES
        ============================================================ */
        :root {
            --sw: 264px;
            --hh: 64px;

            /* Sidebar */
            --sb-bg:        #0d1b2e;
            --sb-top:       #0a1522;
            --sb-border:    rgba(255,255,255,0.055);
            --sb-text:      #7a96b5;
            --sb-text-h:    #d0dff0;
            --sb-icon-bg:   rgba(255,255,255,0.05);
            --sb-icon-bg-h: rgba(255,255,255,0.09);
            --sb-active-bg: rgba(0,80,200,0.16);
            --sb-active-txt:#5ba3ff;
            --sb-active-bdr:#1a6fff;
            --sb-label:     #2a4060;
            --sb-hover-bdr: rgba(255,255,255,0.07);

            /* Main */
            --body-bg:  #eef1f6;
            --surface:  #ffffff;
            --surface2: #f5f7fb;
            --border:   #dde3ed;
            --txt:      #0d1b2e;
            --txt2:     #4e6780;
            --txt3:     #96adc5;
            --shadow:   0 2px 10px rgba(0,0,0,0.07);
            --ease:     0.22s cubic-bezier(.4,0,.2,1);
        }

        [data-theme="dark"] {
            --body-bg:  #07101e;
            --surface:  #0e1c2f;
            --surface2: #111f32;
            --border:   rgba(255,255,255,0.07);
            --txt:      #dce8f5;
            --txt2:     #6a8caa;
            --txt3:     #3a5570;
            --shadow:   0 2px 10px rgba(0,0,0,0.35);
        }

        /* ============================================================
           RESET
        ============================================================ */
        *, *::before, *::after { margin:0; padding:0; box-sizing:border-box; }

        body {
            font-family: 'Outfit', sans-serif;
            background: var(--body-bg);
            color: var(--txt);
            transition: background var(--ease), color var(--ease);
            min-height: 100vh;
        }

        /* ============================================================
           SIDEBAR
        ============================================================ */
        .sidebar {
            position: fixed;
            inset: 0 auto 0 0;
            width: var(--sw);
            background: var(--sb-bg);
            display: flex;
            flex-direction: column;
            z-index: 1050;
            transition: transform var(--ease);
            overflow: hidden;
        }
        .sidebar::after {
            content: '';
            position: absolute;
            right: 0; top: 0; bottom: 0;
            width: 1px;
            background: linear-gradient(to bottom, transparent 0%, rgba(26,111,255,.3) 40%, rgba(26,111,255,.3) 60%, transparent 100%);
            pointer-events: none;
        }

        /* Brand */
        .sb-brand {
            display: flex;
            align-items: center;
            justify-content: center;
            height: 72px;
            background: var(--sb-top);
            border-bottom: 1px solid var(--sb-border);
            flex-shrink: 0;
            padding: 14px 20px;
        }
        .sb-brand img { width: 150px; object-fit: contain; display: block; }

        /* Nav scroll */
        .sb-nav {
            flex: 1;
            overflow-y: auto;
            padding: 10px 0 6px;
            scrollbar-width: thin;
            scrollbar-color: rgba(255,255,255,0.06) transparent;
        }
        .sb-nav::-webkit-scrollbar { width: 3px; }
        .sb-nav::-webkit-scrollbar-thumb { background: rgba(255,255,255,0.08); border-radius: 2px; }

        .sb-group {
            padding: 16px 20px 5px;
            font-size: 10px;
            font-weight: 700;
            letter-spacing: 1.6px;
            text-transform: uppercase;
            color: var(--sb-label);
            user-select: none;
        }

        .sb-link {
            display: flex;
            align-items: center;
            gap: 11px;
            margin: 2px 10px;
            padding: 9px 12px;
            border-radius: 8px;
            text-decoration: none;
            color: var(--sb-text);
            font-size: 13.5px;
            font-weight: 500;
            position: relative;
            border: 1px solid transparent;
            transition: all var(--ease);
            white-space: nowrap;
        }
        .sb-link:hover {
            color: var(--sb-text-h);
            background: rgba(255,255,255,0.04);
            border-color: var(--sb-hover-bdr);
        }
        .sb-link.active {
            color: var(--sb-active-txt);
            background: var(--sb-active-bg);
            border-color: rgba(26,111,255,0.2);
        }
        .sb-link.active::before {
            content: '';
            position: absolute;
            left: -1px; top: 22%; bottom: 22%;
            width: 3px;
            background: var(--sb-active-bdr);
            border-radius: 0 3px 3px 0;
        }

        .sb-icon {
            width: 32px; height: 32px;
            display: flex; align-items: center; justify-content: center;
            border-radius: 7px;
            background: var(--sb-icon-bg);
            font-size: 13px;
            color: #4a6880;
            flex-shrink: 0;
            transition: all var(--ease);
        }
        .sb-link:hover .sb-icon { background: var(--sb-icon-bg-h); color: #7ab5ff; }
        .sb-link.active .sb-icon { background: rgba(26,111,255,0.18); color: var(--sb-active-txt); }

        .sb-label { flex: 1; }

        .sb-badge {
            background: #e60026;
            color: #fff;
            font-size: 10px;
            font-weight: 700;
            padding: 1px 6px;
            border-radius: 20px;
            line-height: 1.6;
        }

        .sb-divider { margin: 8px 16px; height: 1px; background: var(--sb-border); }

        .sb-footer {
            border-top: 1px solid var(--sb-border);
            padding: 10px;
            flex-shrink: 0;
            background: rgba(0,0,0,0.1);
        }
        .sb-logout {
            display: flex;
            align-items: center;
            gap: 11px;
            padding: 9px 12px;
            border-radius: 8px;
            text-decoration: none;
            color: #c05060;
            font-size: 13.5px;
            font-weight: 500;
            border: 1px solid transparent;
            transition: all var(--ease);
        }
        .sb-logout:hover { background: rgba(230,0,38,0.08); border-color: rgba(230,0,38,0.18); color: #ff6878; }
        .sb-logout .sb-icon { background: rgba(230,0,38,0.08); color: #b04050; }
        .sb-logout:hover .sb-icon { background: rgba(230,0,38,0.14); color: #ff6878; }

        /* ============================================================
           MAIN CONTENT
        ============================================================ */
        .main-content {
            margin-left: var(--sw);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            transition: margin-left var(--ease);
        }

        /* ============================================================
           TOP HEADER
        ============================================================ */
        .top-header {
            position: sticky; top: 0;
            height: var(--hh);
            background: var(--surface);
            border-bottom: 1px solid var(--border);
            display: flex; align-items: center;
            padding: 0 24px;
            gap: 14px;
            z-index: 200;
            box-shadow: var(--shadow);
            transition: background var(--ease), border-color var(--ease);
        }

        .hdr-left { display: flex; align-items: center; gap: 14px; flex: 1; min-width: 0; }

        .page-title { font-size: 17px; font-weight: 600; color: var(--txt); white-space: nowrap; }
        .page-sub   { font-size: 11px; color: var(--txt3); white-space: nowrap; }

        .hdr-right { display: flex; align-items: center; gap: 6px; flex-shrink: 0; position: relative; }

        /* Icon buttons */
        .hdr-btn {
            width: 36px; height: 36px;
            border: 1px solid var(--border);
            background: var(--surface);
            border-radius: 8px;
            display: flex; align-items: center; justify-content: center;
            cursor: pointer;
            color: var(--txt2);
            font-size: 14px;
            transition: all var(--ease);
            position: relative;
            flex-shrink: 0;
        }
        .hdr-btn:hover { background: var(--surface2); border-color: #1a6fff; color: #1a6fff; }

        /* Theme button - styled same as hdr-btn */
        .theme-btn {
            width: 36px; height: 36px;
            border: 1px solid var(--border);
            background: var(--surface);
            border-radius: 8px;
            display: flex; align-items: center; justify-content: center;
            cursor: pointer;
            color: var(--txt2);
            font-size: 15px;
            transition: all var(--ease);
            flex-shrink: 0;
        }
        .theme-btn:hover { background: var(--surface2); border-color: #1a6fff; color: #1a6fff; }

        .notif-dot {
            position: absolute; top: 7px; right: 7px;
            width: 6px; height: 6px;
            background: #e60026;
            border-radius: 50%;
            border: 1.5px solid var(--surface);
        }

        .hdr-sep { width: 1px; height: 26px; background: var(--border); margin: 0 4px; flex-shrink: 0; }

        /* ============================================================
           ADMIN DROPDOWN
        ============================================================ */
        .admin-wrap { position: relative; }

        .admin-chip {
            display: flex; align-items: center; gap: 9px;
            padding: 4px 10px 4px 5px;
            border: 1px solid var(--border);
            border-radius: 40px;
            cursor: pointer;
            transition: all var(--ease);
            background: var(--surface);
            user-select: none;
        }
        .admin-chip:hover,
        .admin-chip.open { background: var(--surface2); border-color: #1a6fff; }

        .admin-av {
            width: 30px; height: 30px;
            background: linear-gradient(135deg, #003087, #1a6fff);
            border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            font-size: 11px; font-weight: 700; color: #fff;
            flex-shrink: 0;
        }
        .admin-info { line-height: 1.2; }
        .admin-name { font-size: 13px; font-weight: 600; color: var(--txt); }
        .admin-role { font-size: 10px; color: var(--txt3); }
        .admin-caret {
            font-size: 9px; color: var(--txt3); margin-left: 2px;
            transition: transform var(--ease);
        }
        .admin-chip.open .admin-caret { transform: rotate(180deg); }

        /* Dropdown menu */
        .admin-dropdown {
            position: absolute;
            top: calc(100% + 10px);
            right: 0;
            width: 220px;
            background: var(--surface);
            border: 1px solid var(--border);
            border-radius: 12px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.14), 0 2px 8px rgba(0,0,0,0.06);
            z-index: 999;
            overflow: hidden;
            opacity: 0;
            transform: translateY(-6px) scale(0.98);
            pointer-events: none;
            transition: opacity 0.18s var(--ease), transform 0.18s var(--ease);
            transform-origin: top right;
        }
        .admin-dropdown.open {
            opacity: 1;
            transform: translateY(0) scale(1);
            pointer-events: all;
        }

        /* Dropdown header */
        .dd-head {
            padding: 14px 16px 12px;
            border-bottom: 1px solid var(--border);
            display: flex; align-items: center; gap: 10px;
        }
        .dd-av-lg {
            width: 38px; height: 38px;
            background: linear-gradient(135deg, #003087, #1a6fff);
            border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            font-size: 15px; font-weight: 700; color: #fff;
            flex-shrink: 0;
        }
        .dd-name  { font-size: 14px; font-weight: 600; color: var(--txt); line-height: 1.3; }
        .dd-email { font-size: 11px; color: var(--txt3); }

        /* Dropdown items */
        .dd-menu { padding: 6px; }

        .dd-item {
            display: flex; align-items: center; gap: 10px;
            padding: 9px 10px;
            border-radius: 8px;
            text-decoration: none;
            color: var(--txt2);
            font-size: 13px;
            font-weight: 500;
            transition: all var(--ease);
            cursor: pointer;
            border: none; background: none; width: 100%;
        }
        .dd-item:hover { background: var(--surface2); color: var(--txt); }
        .dd-item.danger { color: #d04050; }
        .dd-item.danger:hover { background: rgba(220,50,60,0.08); color: #e05060; }

        .dd-item-icon {
            width: 28px; height: 28px;
            border-radius: 6px;
            display: flex; align-items: center; justify-content: center;
            font-size: 12px;
            background: var(--surface2);
            color: var(--txt2);
            flex-shrink: 0;
            transition: all var(--ease);
        }
        .dd-item:hover .dd-item-icon { background: #e8f0ff; color: #1a6fff; }
        .dd-item.danger .dd-item-icon { background: rgba(220,50,60,0.08); color: #d04050; }
        .dd-item.danger:hover .dd-item-icon { background: rgba(220,50,60,0.14); color: #e05060; }

        .dd-divider { margin: 4px 8px; height: 1px; background: var(--border); }

        /* Notification dropdown */
        .notif-wrap { position: relative; }
        .notif-dropdown {
            position: absolute;
            top: calc(100% + 10px);
            right: 0;
            width: 300px;
            background: var(--surface);
            border: 1px solid var(--border);
            border-radius: 12px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.14);
            z-index: 999;
            overflow: hidden;
            opacity: 0;
            transform: translateY(-6px) scale(0.98);
            pointer-events: none;
            transition: opacity 0.18s var(--ease), transform 0.18s var(--ease);
            transform-origin: top right;
        }
        .notif-dropdown.open {
            opacity: 1;
            transform: translateY(0) scale(1);
            pointer-events: all;
        }
        .notif-hdr {
            padding: 14px 16px 12px;
            border-bottom: 1px solid var(--border);
            display: flex; align-items: center; justify-content: space-between;
        }
        .notif-hdr-title { font-size: 14px; font-weight: 600; color: var(--txt); }
        .notif-clear { font-size: 11px; color: #1a6fff; cursor: pointer; font-weight: 500; }
        .notif-clear:hover { text-decoration: underline; }
        .notif-list { max-height: 260px; overflow-y: auto; }
        .notif-row {
            display: flex; gap: 11px;
            padding: 12px 16px;
            border-bottom: 1px solid var(--border);
            transition: background var(--ease);
            cursor: pointer;
        }
        .notif-row:last-child { border-bottom: none; }
        .notif-row:hover { background: var(--surface2); }
        .notif-row.unread { background: rgba(26,111,255,0.04); }
        .notif-dot-row {
            width: 8px; height: 8px;
            background: #1a6fff;
            border-radius: 50%;
            margin-top: 6px;
            flex-shrink: 0;
        }
        .notif-row:not(.unread) .notif-dot-row { background: transparent; }
        .notif-msg { font-size: 12.5px; color: var(--txt); line-height: 1.4; }
        .notif-time { font-size: 10.5px; color: var(--txt3); margin-top: 2px; }
        .notif-footer {
            padding: 10px 16px;
            text-align: center;
            border-top: 1px solid var(--border);
        }
        .notif-footer a { font-size: 12px; color: #1a6fff; text-decoration: none; font-weight: 500; }
        .notif-footer a:hover { text-decoration: underline; }

        /* Mobile toggle */
        .mob-toggle {
            display: none;
            width: 36px; height: 36px;
            border: 1px solid var(--border);
            background: var(--surface2);
            border-radius: 8px;
            align-items: center; justify-content: center;
            cursor: pointer;
            color: var(--txt);
            font-size: 15px;
            flex-shrink: 0;
        }

        /* Page content */
        .page-content { padding: 26px; flex: 1; }

        /* Overlay */
        .sb-overlay {
            display: none;
            position: fixed; inset: 0;
            background: rgba(0,0,0,0.45);
            z-index: 1040;
            backdrop-filter: blur(2px);
        }

        /* ============================================================
           RESPONSIVE
        ============================================================ */
        @media (max-width: 991px) {
            .sidebar { transform: translateX(-100%); }
            .sidebar.open { transform: translateX(0); }
            .sb-overlay.open { display: block; }
            .main-content { margin-left: 0; }
            .mob-toggle { display: flex; }
        }
        @media (max-width: 480px) {
            .admin-info { display: none; }
            .admin-caret { display: none; }
            .notif-dropdown { width: 280px; right: -60px; }
        }
    </style>
</head>
<body>

<?php if(!in_array($current_page, $public_pages)): ?>

<div class="sb-overlay" id="sbOverlay" onclick="sbClose()"></div>

<!-- ========== SIDEBAR ========== -->
<aside class="sidebar" id="mySidebar">
    <div class="sb-brand">
        <img src="GS_Caltex_Logo.png" alt="GS Caltex">
    </div>

    <nav class="sb-nav">
        <div class="sb-group">Main Menu</div>

        <a href="home.php" class="sb-link <?= $current_page=='home.php' ? 'active':'' ?>">
            <span class="sb-icon"><i class="fa-solid fa-gauge-high"></i></span>
            <span class="sb-label">Dashboard</span>
        </a>
        <a href="manage_employees.php" class="sb-link <?= $current_page=='manage_employees.php' ? 'active':'' ?>">
            <span class="sb-icon"><i class="fa-solid fa-users"></i></span>
            <span class="sb-label">Employees</span>
        </a>
        <a href="usage_reports.php" class="sb-link <?= $current_page=='usage_reports.php' ? 'active':'' ?>">
            <span class="sb-icon"><i class="fa-solid fa-chart-line"></i></span>
            <span class="sb-label">Reports</span>
        </a>
        <a href="push_notifications.php" class="sb-link <?= $current_page=='push_notifications.php' ? 'active':'' ?>">
            <span class="sb-icon"><i class="fa-solid fa-bell"></i></span>
            <span class="sb-label">Push Notifications</span>
            <span class="sb-badge">3</span>
        </a>

        <div class="sb-divider"></div>
        <div class="sb-group">Settings</div>

        <a href="settings.php" class="sb-link <?= $current_page=='settings.php' ? 'active':'' ?>">
            <span class="sb-icon"><i class="fa-solid fa-key"></i></span>
            <span class="sb-label">API Keys</span>
        </a>
        <a href="email_config.php" class="sb-link <?= $current_page=='email_config.php' ? 'active':'' ?>">
            <span class="sb-icon"><i class="fa-solid fa-envelope"></i></span>
            <span class="sb-label">Email Config</span>
        </a>
    </nav>

    <div class="sb-footer">
        <a href="logout.php" class="sb-logout">
            <span class="sb-icon"><i class="fa-solid fa-arrow-right-from-bracket"></i></span>
            <span>Logout</span>
        </a>
    </div>
</aside>

<!-- ========== MAIN ========== -->
<div class="main-content" id="mainContent">

    <header class="top-header">
        <!-- Left -->
        <div class="hdr-left">
            <div class="mob-toggle" onclick="sbOpen()">
                <i class="fa-solid fa-bars"></i>
            </div>
            <div>
                <div class="page-title"><?= $page_title ?></div>
                <div class="page-sub">GS Caltex Management System</div>
            </div>
        </div>

        <!-- Right -->
        <div class="hdr-right">

            <!-- Theme Toggle — now a proper styled button -->
            <div class="theme-btn" onclick="toggleTheme()" title="Toggle Dark Mode">
                <i id="theme-icon" class="fa-solid fa-moon"></i>
            </div>

            <!-- Notifications -->
            <div class="notif-wrap">
                <div class="hdr-btn" id="notifBtn" onclick="toggleNotif(event)" title="Notifications">
                    <i class="fa-solid fa-bell"></i>
                    <span class="notif-dot" id="notifDot"></span>
                </div>

                <div class="notif-dropdown" id="notifDropdown">
                    <div class="notif-hdr">
                        <span class="notif-hdr-title">Notifications <span style="background:#e60026;color:#fff;font-size:10px;padding:1px 6px;border-radius:10px;margin-left:4px;">3</span></span>
                        <span class="notif-clear" onclick="clearNotifs()">Mark all read</span>
                    </div>
                    <div class="notif-list">
                        <div class="notif-row unread">
                            <div class="notif-dot-row"></div>
                            <div>
                                <div class="notif-msg">New employee <strong>Rahul Mehta</strong> was added</div>
                                <div class="notif-time">2 minutes ago</div>
                            </div>
                        </div>
                        <div class="notif-row unread">
                            <div class="notif-dot-row"></div>
                            <div>
                                <div class="notif-msg">Push notification sent to <strong>42 employees</strong></div>
                                <div class="notif-time">1 hour ago</div>
                            </div>
                        </div>
                        <div class="notif-row unread">
                            <div class="notif-dot-row"></div>
                            <div>
                                <div class="notif-msg">Monthly usage report is ready to view</div>
                                <div class="notif-time">3 hours ago</div>
                            </div>
                        </div>
                        <div class="notif-row">
                            <div class="notif-dot-row"></div>
                            <div>
                                <div class="notif-msg">Email config updated successfully</div>
                                <div class="notif-time">Yesterday</div>
                            </div>
                        </div>
                    </div>
                    <div class="notif-footer">
                        <a href="push_notifications.php">View all notifications →</a>
                    </div>
                </div>
            </div>

            <div class="hdr-sep"></div>

            <!-- Admin Dropdown -->
            <div class="admin-wrap">
                <div class="admin-chip" id="adminChip" onclick="toggleAdmin(event)">
                    <div class="admin-av">A</div>
                    <div class="admin-info">
                        <div class="admin-name">Admin</div>
                        <div class="admin-role">Super Admin</div>
                    </div>
                    <i class="fa-solid fa-chevron-down admin-caret"></i>
                </div>

                <div class="admin-dropdown" id="adminDropdown">
                    <!-- Header info -->
                    <div class="dd-head">
                        <div class="dd-av-lg">A</div>
                        <div>
                            <div class="dd-name">Admin User</div>
                            <div class="dd-email">admin@gscaltex.com</div>
                        </div>
                    </div>

                    <!-- Menu items -->
                    <div class="dd-menu">
                        <a href="profile.php" class="dd-item">
                            <span class="dd-item-icon"><i class="fa-solid fa-user"></i></span>
                            My Profile
                        </a>
                        <a href="settings.php" class="dd-item">
                            <span class="dd-item-icon"><i class="fa-solid fa-gear"></i></span>
                            Settings
                        </a>
                        <a href="email_config.php" class="dd-item">
                            <span class="dd-item-icon"><i class="fa-solid fa-envelope"></i></span>
                            Email Config
                        </a>
                        <div class="dd-divider"></div>
                        <div class="dd-item" onclick="toggleTheme(); closeAll();">
                            <span class="dd-item-icon"><i class="fa-solid fa-circle-half-stroke"></i></span>
                            <span id="ddThemeLabel">Toggle Dark Mode</span>
                        </div>
                        <div class="dd-divider"></div>
                        <a href="logout.php" class="dd-item danger">
                            <span class="dd-item-icon"><i class="fa-solid fa-arrow-right-from-bracket"></i></span>
                            Sign Out
                        </a>
                    </div>
                </div>
            </div>

        </div><!-- /hdr-right -->
    </header>

    <div class="page-content">

<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    const root = document.documentElement;

    /* Apply saved theme immediately on load */
    applyTheme(localStorage.getItem('gsc_theme') || 'light');

    function applyTheme(t) {
        root.setAttribute('data-theme', t);
        localStorage.setItem('gsc_theme', t);
        const ic  = document.getElementById('theme-icon');
        const lbl = document.getElementById('ddThemeLabel');
        if (ic)  ic.className  = t === 'dark' ? 'fa-solid fa-sun' : 'fa-solid fa-moon';
        if (lbl) lbl.textContent = t === 'dark' ? 'Switch to Light Mode' : 'Toggle Dark Mode';
    }

    /* FIX: toggleTheme was missing — now defined */
    function toggleTheme() {
        const current = root.getAttribute('data-theme') || 'light';
        applyTheme(current === 'dark' ? 'light' : 'dark');
    }

    /* ---- Dropdown helpers ---- */
    function closeAll() {
        document.getElementById('adminDropdown')?.classList.remove('open');
        document.getElementById('adminChip')?.classList.remove('open');
        document.getElementById('notifDropdown')?.classList.remove('open');
    }

    function toggleAdmin(e) {
        e.stopPropagation();
        const dd   = document.getElementById('adminDropdown');
        const chip = document.getElementById('adminChip');
        const isOpen = dd.classList.contains('open');
        closeAll();
        if (!isOpen) { dd.classList.add('open'); chip.classList.add('open'); }
    }

    function toggleNotif(e) {
        e.stopPropagation();
        const dd = document.getElementById('notifDropdown');
        const isOpen = dd.classList.contains('open');
        closeAll();
        if (!isOpen) dd.classList.add('open');
    }

    function clearNotifs() {
        document.querySelectorAll('.notif-row.unread').forEach(r => r.classList.remove('unread'));
        document.getElementById('notifDot')?.remove();
        document.querySelector('.notif-hdr-title span')?.remove();
    }

    /* Close on outside click */
    document.addEventListener('click', () => closeAll());

    /* Prevent closing when clicking inside dropdowns */
    document.getElementById('adminDropdown')?.addEventListener('click', e => e.stopPropagation());
    document.getElementById('notifDropdown')?.addEventListener('click', e => e.stopPropagation());

    /* ---- Mobile sidebar ---- */
    function sbOpen() {
        document.getElementById('mySidebar')?.classList.add('open');
        document.getElementById('sbOverlay')?.classList.add('open');
        document.body.style.overflow = 'hidden';
    }
    function sbClose() {
        document.getElementById('mySidebar')?.classList.remove('open');
        document.getElementById('sbOverlay')?.classList.remove('open');
        document.body.style.overflow = '';
    }
</script>