<?php include 'header.php'; ?>

<?php
// Fetch Dynamic Data
$res_total = $conn->query("SELECT COUNT(*) as total FROM users");
$total_emp = ($res_total) ? $res_total->fetch_assoc()['total'] : 0;

$res_active = $conn->query("SELECT COUNT(*) as total FROM users WHERE status='active'");
$active_emp = ($res_active) ? $res_active->fetch_assoc()['total'] : 0;

$inactive_emp = $total_emp - $active_emp;

$res_tokens = $conn->query("SELECT SUM(total_tokens) as total FROM api_usage_logs");
$row_tokens = ($res_tokens) ? $res_tokens->fetch_assoc() : [];
$total_tokens = $row_tokens['total'] ?? 0;

$today = date('Y-m-d');
$res_today = $conn->query("SELECT SUM(total_tokens) as total FROM api_usage_logs WHERE DATE(created_at) = '$today'");
$today_tokens = ($res_today) ? $res_today->fetch_assoc()['total'] ?? 0 : 0;
?>

<link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
    /* ---- Base ---- */
    body, .main-content { font-family: 'Outfit', sans-serif !important; }

    /* ============================================================
       WELCOME BANNER — GS Caltex navy-blue brand
    ============================================================ */
    .welcome-banner {
        background: linear-gradient(125deg, #003087 0%, #0057B8 55%, #1a6fff 100%);
        color: white;
        border-radius: 16px;
        padding: 32px 36px;
        margin-bottom: 28px;
        position: relative;
        overflow: hidden;
        box-shadow: 0 8px 28px rgba(0,48,135,0.30);
        animation: fadeInDown 0.5s ease-out both;
    }

    /* decorative circles */
    .welcome-banner::before {
        content: '';
        position: absolute;
        right: -60px; top: -60px;
        width: 240px; height: 240px;
        border-radius: 50%;
        background: rgba(255,255,255,0.06);
    }
    .welcome-banner::after {
        content: '';
        position: absolute;
        right: 60px; bottom: -80px;
        width: 180px; height: 180px;
        border-radius: 50%;
        background: rgba(255,255,255,0.04);
    }

    .banner-content { position: relative; z-index: 1; }

    .banner-title {
        font-size: 22px;
        font-weight: 700;
        margin-bottom: 5px;
        letter-spacing: -0.2px;
    }
    .banner-sub {
        font-size: 13.5px;
        opacity: 0.78;
        margin: 0;
    }
    .banner-sub strong { opacity: 1; }

    .banner-icon {
        position: relative; z-index: 1;
        opacity: 0.12;
        font-size: 72px;
        line-height: 1;
    }

    /* ============================================================
       STAT CARDS
    ============================================================ */
    .stat-card {
        background: var(--surface, #fff);
        border-radius: 14px;
        padding: 24px 26px;
        border: 1px solid var(--border, #e2e8f0);
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        height: 100%;
        position: relative;
        overflow: hidden;
        transition: transform 0.25s, box-shadow 0.25s;
        animation: fadeInUp 0.5s ease-out both;
    }
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 12px 28px rgba(0,0,0,0.10);
    }

    /* top accent bar */
    .stat-card::before {
        content: '';
        position: absolute;
        top: 0; left: 0; right: 0;
        height: 3px;
        border-radius: 14px 14px 0 0;
    }
    .stat-card.c-blue::before   { background: linear-gradient(90deg,#003087,#1a6fff); }
    .stat-card.c-green::before  { background: linear-gradient(90deg,#0a8f5e,#22c87b); }
    .stat-card.c-amber::before  { background: linear-gradient(90deg,#c07800,#f59e0b); }
    .stat-card.c-teal::before   { background: linear-gradient(90deg,#0070a8,#0ea5e9); }

    /* icon box */
    .stat-icon {
        width: 48px; height: 48px;
        border-radius: 11px;
        display: flex; align-items: center; justify-content: center;
        font-size: 20px;
        margin-bottom: 18px;
        flex-shrink: 0;
    }
    .ic-blue  { background: rgba(0,48,135,0.08);  color: #1a6fff; }
    .ic-green { background: rgba(10,143,94,0.09);  color: #0a8f5e; }
    .ic-amber { background: rgba(192,120,0,0.09);  color: #c07800; }
    .ic-teal  { background: rgba(0,112,168,0.09);  color: #0070a8; }

    .stat-value {
        font-size: 32px;
        font-weight: 700;
        color: var(--txt, #0d1b2e);
        margin-bottom: 3px;
        line-height: 1.1;
    }
    .stat-label {
        font-size: 11.5px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.7px;
        color: var(--txt3, #94adc5);
        margin-bottom: 16px;
    }
    .stat-footer {
        padding-top: 14px;
        border-top: 1px solid var(--border, #e8f0f8);
        font-size: 12px;
        color: var(--txt3, #94adc5);
        display: flex; align-items: center; gap: 6px;
    }
    .stat-badge {
        display: inline-flex; align-items: center; gap: 4px;
        padding: 2px 8px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 600;
    }
    .badge-red   { background: #fef2f2; color: #dc2626; }
    .badge-green { background: #f0fdf4; color: #16a34a; }
    .badge-blue  { background: #eff6ff; color: #2563eb; }
    .badge-sky   { background: #f0f9ff; color: #0284c7; }

    /* ============================================================
       SECTION HEADER
    ============================================================ */
    .section-hdr {
        display: flex; align-items: center; gap: 12px;
        margin: 32px 0 20px;
    }
    .section-hdr-icon {
        width: 32px; height: 32px;
        border-radius: 8px;
        background: rgba(0,48,135,0.09);
        color: #003087;
        display: flex; align-items: center; justify-content: center;
        font-size: 13px;
    }
    .section-hdr h5 {
        font-size: 15px; font-weight: 700;
        color: var(--txt, #0d1b2e);
        margin: 0;
    }
    .section-hdr-line {
        flex: 1; height: 1px;
        background: linear-gradient(to right, var(--border, #e2e8f0), transparent);
    }

    /* ============================================================
       QUICK ACTION CARDS
    ============================================================ */
    .action-card {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-align: center;
        text-decoration: none;
        padding: 28px 20px 24px;
        background: var(--surface, #fff);
        border: 1px solid var(--border, #e2e8f0);
        border-radius: 14px;
        color: var(--txt, #0d1b2e);
        box-shadow: 0 2px 8px rgba(0,0,0,0.04);
        transition: all 0.25s;
        height: 100%;
        animation: fadeInUp 0.6s ease-out both;
        position: relative;
        overflow: hidden;
    }
    .action-card::before {
        content: '';
        position: absolute;
        inset: 0;
        background: linear-gradient(135deg, #003087 0%, #1a6fff 100%);
        opacity: 0;
        transition: opacity 0.25s;
    }
    .action-card:hover {
        transform: translateY(-5px);
        border-color: transparent;
        box-shadow: 0 12px 28px rgba(0,48,135,0.22);
        color: #fff;
    }
    .action-card:hover::before { opacity: 1; }
    .action-card:hover .ac-icon { background: rgba(255,255,255,0.18); color: #fff; }
    .action-card:hover .ac-label { color: #fff; }

    .ac-icon {
        position: relative; z-index: 1;
        width: 52px; height: 52px;
        border-radius: 13px;
        background: rgba(0,48,135,0.08);
        color: #003087;
        display: flex; align-items: center; justify-content: center;
        font-size: 20px;
        margin-bottom: 14px;
        transition: all 0.25s;
    }
    .ac-label {
        position: relative; z-index: 1;
        font-size: 13px;
        font-weight: 600;
        color: var(--txt, #0d1b2e);
        transition: color 0.25s;
    }
    .ac-sub {
        position: relative; z-index: 1;
        font-size: 11px;
        color: var(--txt3, #94adc5);
        margin-top: 4px;
        transition: color 0.25s;
    }
    .action-card:hover .ac-sub { color: rgba(255,255,255,0.75); }

    /* ============================================================
       DARK MODE
    ============================================================ */
    [data-theme="dark"] .stat-card { background: var(--surface); border-color: var(--border); }
    [data-theme="dark"] .stat-value { color: var(--txt); }
    [data-theme="dark"] .stat-footer { border-color: var(--border); }
    [data-theme="dark"] .stat-badge.badge-red   { background: rgba(220,38,38,0.12);  color: #f87171; }
    [data-theme="dark"] .stat-badge.badge-green { background: rgba(22,163,74,0.12);  color: #4ade80; }
    [data-theme="dark"] .stat-badge.badge-blue  { background: rgba(37,99,235,0.12);  color: #60a5fa; }
    [data-theme="dark"] .stat-badge.badge-sky   { background: rgba(2,132,199,0.12);  color: #38bdf8; }
    [data-theme="dark"] .action-card { background: var(--surface); border-color: var(--border); color: var(--txt); }
    [data-theme="dark"] .ac-icon { background: rgba(26,111,255,0.14); color: #5ba3ff; }
    [data-theme="dark"] .ac-label { color: var(--txt); }
    [data-theme="dark"] .section-hdr h5 { color: var(--txt); }
    [data-theme="dark"] .section-hdr-icon { background: rgba(26,111,255,0.12); color: #5ba3ff; }
    [data-theme="dark"] .welcome-banner { box-shadow: 0 8px 28px rgba(0,0,0,0.4); }
    [data-theme="dark"] .ic-blue  { background: rgba(26,111,255,0.14); color: #5ba3ff; }
    [data-theme="dark"] .ic-green { background: rgba(10,143,94,0.14);  color: #34d399; }
    [data-theme="dark"] .ic-amber { background: rgba(245,158,11,0.12); color: #fbbf24; }
    [data-theme="dark"] .ic-teal  { background: rgba(14,165,233,0.12); color: #38bdf8; }

    /* ---- Animations ---- */
    @keyframes fadeInDown {
        from { opacity: 0; transform: translateY(-16px); }
        to   { opacity: 1; transform: translateY(0); }
    }
    @keyframes fadeInUp {
        from { opacity: 0; transform: translateY(18px); }
        to   { opacity: 1; transform: translateY(0); }
    }
    .delay-1 { animation-delay: 0.08s; }
    .delay-2 { animation-delay: 0.16s; }
    .delay-3 { animation-delay: 0.24s; }
    .delay-4 { animation-delay: 0.32s; }
</style>

<!-- ============================================================
     WELCOME BANNER
============================================================ -->
<div class="welcome-banner d-flex justify-content-between align-items-center">
    <div class="banner-content">
        <div class="banner-title">Welcome back, Administrator 👋</div>
        <p class="banner-sub">Activity summary for <strong><?= date('l, F j, Y'); ?></strong></p>
    </div>
    <div class="banner-icon d-none d-lg-block">
        <i class="fa-solid fa-gauge-high"></i>
    </div>
</div>

<!-- ============================================================
     STATS CARDS
============================================================ -->
<div class="row g-3 mb-2">

    <div class="col-xl-3 col-md-6">
        <div class="stat-card c-blue">
            <div class="stat-icon ic-blue"><i class="fa-solid fa-users"></i></div>
            <div class="stat-value"><?= $total_emp ?></div>
            <div class="stat-label">Total Employees</div>
            <div class="stat-footer">
                <span class="stat-badge badge-red">
                    <i class="fa-solid fa-user-slash"></i> <?= $inactive_emp ?> inactive
                </span>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 delay-1">
        <div class="stat-card c-green">
            <div class="stat-icon ic-green"><i class="fa-solid fa-user-check"></i></div>
            <div class="stat-value"><?= $active_emp ?></div>
            <div class="stat-label">Active Users</div>
            <div class="stat-footer">
                <span class="stat-badge badge-green">
                    <i class="fa-solid fa-circle-check"></i> System operational
                </span>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 delay-2">
        <div class="stat-card c-amber">
            <div class="stat-icon ic-amber"><i class="fa-solid fa-coins"></i></div>
            <div class="stat-value"><?= number_format($total_tokens) ?></div>
            <div class="stat-label">Total Tokens</div>
            <div class="stat-footer">
                <span class="stat-badge badge-blue">
                    <i class="fa-solid fa-infinity"></i> Lifetime usage
                </span>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 delay-3">
        <div class="stat-card c-teal">
            <div class="stat-icon ic-teal"><i class="fa-solid fa-bolt"></i></div>
            <div class="stat-value"><?= number_format($today_tokens) ?></div>
            <div class="stat-label">Today's Usage</div>
            <div class="stat-footer">
                <span class="stat-badge badge-sky">
                    <i class="fa-solid fa-clock"></i> Updated just now
                </span>
            </div>
        </div>
    </div>

</div>

<!-- ============================================================
     QUICK ACTIONS
============================================================ -->
<div class="section-hdr">
    <div class="section-hdr-icon"><i class="fa-solid fa-bolt-lightning"></i></div>
    <h5>Quick Actions</h5>
    <div class="section-hdr-line"></div>
</div>

<div class="row g-3">

    <div class="col-xl-3 col-md-6">
        <a href="manage_employees.php" class="action-card">
            <div class="ac-icon"><i class="fa-solid fa-user-plus"></i></div>
            <div class="ac-label">Add Employee</div>
            <div class="ac-sub">Manage staff records</div>
        </a>
    </div>

    <div class="col-xl-3 col-md-6 delay-1">
        <a href="usage_reports.php" class="action-card">
            <div class="ac-icon"><i class="fa-solid fa-chart-bar"></i></div>
            <div class="ac-label">View Reports</div>
            <div class="ac-sub">Usage analytics</div>
        </a>
    </div>

    <div class="col-xl-3 col-md-6 delay-2">
        <a href="settings.php" class="action-card">
            <div class="ac-icon"><i class="fa-solid fa-key"></i></div>
            <div class="ac-label">Manage API Key</div>
            <div class="ac-sub">Configure access keys</div>
        </a>
    </div>

    <div class="col-xl-3 col-md-6 delay-3">
        <a href="email_config.php" class="action-card">
            <div class="ac-icon"><i class="fa-solid fa-envelope-open-text"></i></div>
            <div class="ac-label">SMTP Settings</div>
            <div class="ac-sub">Email configuration</div>
        </a>
    </div>

</div>

<?php include 'footer.php'; ?>