<?php
session_start();
require_once 'db.php';

if (isset($_SESSION['admin_id'])) {
    header("Location: home.php");
    exit();
}

$error = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email    = $conn->real_escape_string($_POST['email']);
    $password = $conn->real_escape_string($_POST['password']);

    $sql    = "SELECT id, email FROM admins WHERE email = '$email' AND password = '$password' LIMIT 1";
    $result = $conn->query($sql);

    if ($result && $result->num_rows == 1) {
        $row = $result->fetch_assoc();
        $_SESSION['admin_id']    = $row['id'];
        $_SESSION['admin_email'] = $row['email'];
        header("Location: home.php");
        exit();
    } else {
        $error = "Invalid email or password. Please try again.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login — GS Caltex</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        *, *::before, *::after { margin: 0; padding: 0; box-sizing: border-box; }

        body {
            font-family: 'Outfit', sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #07101d;
            overflow: hidden;
            position: relative;
            padding: 24px;
        }

        body::before {
            content: '';
            position: fixed; inset: 0;
            background:
                radial-gradient(ellipse 80% 60% at 15% 10%,  rgba(0,48,135,0.48) 0%, transparent 65%),
                radial-gradient(ellipse 60% 50% at 85% 90%,  rgba(0,87,184,0.32) 0%, transparent 60%),
                radial-gradient(ellipse 40% 30% at 85% 5%,   rgba(230,0,38,0.09) 0%, transparent 55%),
                linear-gradient(155deg, #05090f 0%, #08142a 50%, #050c17 100%);
            pointer-events: none; z-index: 0;
        }
        body::after {
            content: '';
            position: fixed; inset: 0;
            background-image:
                linear-gradient(rgba(0,87,184,0.055) 1px, transparent 1px),
                linear-gradient(90deg, rgba(0,87,184,0.055) 1px, transparent 1px);
            background-size: 58px 58px;
            pointer-events: none; z-index: 0;
        }

        .orb { position: fixed; border-radius: 50%; filter: blur(88px); pointer-events: none; z-index: 0; animation: floatOrb 9s ease-in-out infinite; }
        .orb-1 { width: 480px; height: 480px; top: -130px; left: -90px;  background: radial-gradient(circle, rgba(0,87,184,0.17) 0%, transparent 70%); }
        .orb-2 { width: 320px; height: 320px; bottom: -90px; right: -70px; background: radial-gradient(circle, rgba(0,48,135,0.14) 0%, transparent 70%); animation-delay: -4s; }
        .orb-3 { width: 210px; height: 210px; top: 44%; right: 7%; background: radial-gradient(circle, rgba(230,0,38,0.07) 0%, transparent 70%); animation-delay: -7s; }
        @keyframes floatOrb {
            0%,100% { transform: translateY(0) scale(1); }
            50%      { transform: translateY(-20px) scale(1.04); }
        }

        /* ---- Card ---- */
        .login-wrap {
            position: relative; z-index: 10;
            width: 100%; max-width: 980px;
            display: flex;
            border-radius: 18px;
            overflow: hidden;
            box-shadow: 0 28px 70px rgba(0,0,0,0.55), 0 0 0 1px rgba(255,255,255,0.05);
            animation: cardIn 0.5s cubic-bezier(.4,0,.2,1) both;
        }
        @keyframes cardIn {
            from { opacity: 0; transform: translateY(22px) scale(0.97); }
            to   { opacity: 1; transform: translateY(0) scale(1); }
        }

        /* ==============================
           LEFT PANEL  — reduced padding
        ============================== */
        .login-left {
            flex: 1;
            background: linear-gradient(148deg, #0d1e3c 0%, #080f1e 100%);
            padding: 40px 44px;          /* ↓ was 56px */
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            border-right: 1px solid rgba(255,255,255,0.05);
            position: relative;
            overflow: hidden;
            min-height: 0;              /* allow shrink */
        }
        .login-left::before {
            content: '';
            position: absolute; inset: 0;
            background:
                radial-gradient(circle at 20% 75%, rgba(0,87,184,0.12) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(0,48,135,0.09) 0%, transparent 45%);
            pointer-events: none;
        }

        /* Logo */
        .left-logo-wrap { position: relative; z-index: 1; margin-bottom: 22px; } /* ↓ was 40px */

        .logo-pill {
            display: inline-flex;
            align-items: center; justify-content: center;
            background: #fff;
            border-radius: 11px;
            padding: 9px 18px;           /* ↓ was 11px 20px */
            box-shadow: 0 4px 16px rgba(0,0,0,0.22);
        }
        .logo-pill img { width: 130px; height: auto; display: block; object-fit: contain; } /* ↓ was 144px */

        .left-headline { position: relative; z-index: 1; }
        .left-headline h1 {
            font-size: 24px;             /* ↓ was 28px */
            font-weight: 700;
            color: #fff; line-height: 1.3;
            margin-bottom: 8px;          /* ↓ was 12px */
        }
        .left-headline h1 span { color: #59aaff; }
        .left-headline p {
            font-size: 13px;             /* ↓ was 14px */
            color: #4a6e92;
            line-height: 1.65; max-width: 290px;
        }

        /* Feature pills */
        .feature-list {
            position: relative; z-index: 1;
            display: flex; flex-direction: column;
            gap: 8px;                    /* ↓ was 10px */
        }
        .feature-pill {
            display: flex; align-items: center; gap: 12px;
            padding: 10px 14px;          /* ↓ was 12px 15px */
            background: rgba(255,255,255,0.032);
            border: 1px solid rgba(255,255,255,0.06);
            border-radius: 10px;
            transition: background 0.2s;
        }
        .feature-pill:hover { background: rgba(255,255,255,0.052); }
        .fp-icon {
            width: 30px; height: 30px;   /* ↓ was 34px */
            border-radius: 7px;
            background: rgba(0,87,184,0.20);
            display: flex; align-items: center; justify-content: center;
            font-size: 12px; color: #59aaff; flex-shrink: 0;
        }
        .feature-pill span { font-size: 12.5px; color: #7898bb; font-weight: 500; }

        .left-footer { position: relative; z-index: 1; font-size: 10.5px; color: #263d55; }

        /* ==============================
           RIGHT PANEL — reduced padding
        ============================== */
        .login-right {
            width: 390px;                /* ↓ was 410px */
            flex-shrink: 0;
            background: #ffffff;
            padding: 40px 44px;          /* ↓ was 56px */
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .form-head { margin-bottom: 24px; } /* ↓ was 32px */
        .form-head h2 {
            font-size: 21px;             /* ↓ was 23px */
            font-weight: 700;
            color: #0c1a2e; margin-bottom: 5px; letter-spacing: -0.3px;
        }
        .form-head p { font-size: 12.5px; color: #8ba5be; line-height: 1.5; }

        /* Error */
        .error-box {
            display: flex; align-items: flex-start; gap: 10px;
            padding: 10px 14px;
            background: #fff3f4; border: 1px solid #ffd0d4;
            border-radius: 9px; margin-bottom: 18px;
            font-size: 12.5px; color: #b82030; line-height: 1.45;
        }
        .error-box i { color: #d63040; font-size: 13px; flex-shrink: 0; margin-top: 1px; }

        /* Fields */
        .field-group { display: flex; flex-direction: column; gap: 16px; } /* ↓ was 22px */

        .field-wrap label {
            display: block; font-size: 11.5px; font-weight: 600;
            color: #4d6880; margin-bottom: 6px; letter-spacing: 0.2px;
        }
        .field-inner { position: relative; }

        .f-icon {
            position: absolute; left: 13px; top: 50%;
            transform: translateY(-50%);
            color: #b5cedf; font-size: 13px;
            pointer-events: none; transition: color 0.2s;
        }
        .field-inner:focus-within .f-icon { color: #1a6fff; }

        .field-wrap input {
            width: 100%;
            height: 44px;                /* ↓ was 48px */
            padding: 0 44px 0 40px;
            border: 1.5px solid #dde8f3;
            border-radius: 9px;
            font-family: 'Outfit', sans-serif;
            font-size: 13.5px; color: #0c1a2e;
            background: #f6fafd; outline: none;
            transition: border-color 0.2s, box-shadow 0.2s, background 0.2s;
        }
        .field-wrap input::placeholder { color: #b5cedf; }
        .field-wrap input:focus {
            border-color: #1a6fff; background: #fff;
            box-shadow: 0 0 0 3px rgba(26,111,255,0.09);
        }

        .eye-btn {
            position: absolute; right: 13px; top: 50%; transform: translateY(-50%);
            background: none; border: none; color: #b5cedf;
            cursor: pointer; font-size: 13px; padding: 0; line-height: 1;
            transition: color 0.2s;
        }
        .eye-btn:hover { color: #1a6fff; }

        /* Forgot */
        .forgot-row {
            display: flex; justify-content: flex-end;
            margin-top: 10px; margin-bottom: 20px; /* ↓ was 14/26 */
        }
        .forgot-row a {
            font-size: 11.5px; color: #1a6fff;
            text-decoration: none; font-weight: 500;
        }
        .forgot-row a:hover { text-decoration: underline; }

        /* Button */
        .btn-login {
            width: 100%;
            height: 46px;                /* ↓ was 50px */
            background: linear-gradient(135deg, #003087 0%, #1a6fff 100%);
            border: none; border-radius: 10px;
            color: #fff; font-family: 'Outfit', sans-serif;
            font-size: 14.5px; font-weight: 600; letter-spacing: 0.3px;
            cursor: pointer;
            display: flex; align-items: center; justify-content: center; gap: 8px;
            transition: transform 0.18s, box-shadow 0.18s, filter 0.18s;
        }
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 22px rgba(26,111,255,0.28);
            filter: brightness(1.06);
        }
        .btn-login:active { transform: translateY(0); box-shadow: none; }

        /* Footer */
        .form-foot {
            margin-top: 20px;            /* ↓ was 28px */
            padding-top: 16px;           /* ↓ was 20px */
            border-top: 1px solid #edf1f8;
            text-align: center;
            font-size: 11px;
            color: #b8ccd8;
        }
        .form-foot strong { color: #6d8ea8; }

        /* Responsive */
        @media (max-width: 800px) {
            .login-left  { display: none; }
            .login-right { width: 100%; padding: 40px 36px; }
            .login-wrap  { max-width: 440px; }
        }
        @media (max-width: 480px) {
            body { padding: 14px; }
            .login-right { padding: 36px 24px; }
        }
    </style>
</head>
<body>
    <div class="orb orb-1"></div>
    <div class="orb orb-2"></div>
    <div class="orb orb-3"></div>

    <div class="login-wrap">

        <!-- LEFT -->
        <div class="login-left">
            <div>
                <div class="left-logo-wrap">
                    <div class="logo-pill">
                        <img src="GS_Caltex_Logo.png" alt="GS Caltex">
                    </div>
                </div>
                <div class="left-headline">
                    <h1>Welcome to<br><span>Admin Portal</span></h1>
                    <p>Manage your GS Caltex operations securely from one centralized dashboard.</p>
                </div>
            </div>

            <div class="feature-list">
                <div class="feature-pill">
                    <div class="fp-icon"><i class="fa-solid fa-users"></i></div>
                    <span>Employee Management</span>
                </div>
                <div class="feature-pill">
                    <div class="fp-icon"><i class="fa-solid fa-chart-line"></i></div>
                    <span>Usage Reports &amp; Analytics</span>
                </div>
                <div class="feature-pill">
                    <div class="fp-icon"><i class="fa-solid fa-bell"></i></div>
                    <span>Push Notifications</span>
                </div>
                <div class="feature-pill">
                    <div class="fp-icon"><i class="fa-solid fa-shield-halved"></i></div>
                    <span>Secure Access Control</span>
                </div>
            </div>

            <div class="left-footer">
                &copy; <?= date('Y') ?> GS Caltex Corporation. All rights reserved.
            </div>
        </div>

        <!-- RIGHT -->
        <div class="login-right">
            <div class="form-head">
                <h2>Sign In</h2>
                <p>Enter your credentials to access the admin panel</p>
            </div>

            <?php if ($error): ?>
            <div class="error-box">
                <i class="fa-solid fa-circle-exclamation"></i>
                <?= htmlspecialchars($error) ?>
            </div>
            <?php endif; ?>

            <form method="POST" action="" autocomplete="off">
                <div class="field-group">
                    <div class="field-wrap">
                        <label for="emailInput">Email Address</label>
                        <div class="field-inner">
                            <i class="fa-solid fa-envelope f-icon"></i>
                            <input type="email" id="emailInput" name="email"
                                placeholder="admin@gscaltex.com"
                                value="<?= isset($_POST['email']) ? htmlspecialchars($_POST['email']) : '' ?>"
                                required autocomplete="email">
                        </div>
                    </div>

                    <div class="field-wrap">
                        <label for="passInput">Password</label>
                        <div class="field-inner">
                            <i class="fa-solid fa-lock f-icon"></i>
                            <input type="password" id="passInput" name="password"
                                placeholder="Enter your password"
                                required autocomplete="current-password">
                            <button type="button" class="eye-btn" onclick="togglePass()" tabindex="-1">
                                <i class="fa-solid fa-eye" id="eyeIcon"></i>
                            </button>
                        </div>
                    </div>
                </div>

                <div class="forgot-row">
                    <a href="reset_password.php">Forgot password?</a>
                </div>

                <button type="submit" class="btn-login">
                    Sign In <i class="fa-solid fa-arrow-right"></i>
                </button>
            </form>

            <div class="form-foot">
                &copy; <?= date('Y') ?> <strong>GS Caltex</strong>. All rights reserved.
            </div>
        </div>

    </div>

    <script>
        function togglePass() {
            const inp  = document.getElementById('passInput');
            const icon = document.getElementById('eyeIcon');
            if (inp.type === 'password') {
                inp.type = 'text';
                icon.className = 'fa-solid fa-eye-slash';
            } else {
                inp.type = 'password';
                icon.className = 'fa-solid fa-eye';
            }
        }
    </script>
</body>
</html>