<?php
session_start();
require_once 'db.php';

if (isset($_SESSION['admin_id'])) {
    header("Location: home.php");
    exit();
}

$error = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email    = $conn->real_escape_string($_POST['email']);
    $password = $conn->real_escape_string($_POST['password']);

    $sql    = "SELECT id, email FROM admins WHERE email = '$email' AND password = '$password' LIMIT 1";
    $result = $conn->query($sql);

    if ($result && $result->num_rows == 1) {
        $row = $result->fetch_assoc();
        $_SESSION['admin_id']    = $row['id'];
        $_SESSION['admin_email'] = $row['email'];
        header("Location: home.php");
        exit();
    } else {
        $error = "Invalid email or password. Please try again.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login — GS Caltex</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        *, *::before, *::after { margin: 0; padding: 0; box-sizing: border-box; }

        body {
            font-family: 'Outfit', sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #08111f;
            overflow: hidden;
            position: relative;
            padding: 24px;
        }

        /* Background */
        body::before {
            content: '';
            position: fixed; inset: 0;
            background:
                radial-gradient(ellipse 80% 60% at 15% 10%,  rgba(0,48,135,0.50) 0%, transparent 65%),
                radial-gradient(ellipse 60% 50% at 85% 90%,  rgba(0,87,184,0.35) 0%, transparent 60%),
                radial-gradient(ellipse 40% 35% at 85% 5%,   rgba(230,0,38,0.10) 0%, transparent 55%),
                linear-gradient(155deg, #060e1c 0%, #091626 50%, #060d1a 100%);
            pointer-events: none; z-index: 0;
        }
        body::after {
            content: '';
            position: fixed; inset: 0;
            background-image:
                linear-gradient(rgba(0,87,184,0.06) 1px, transparent 1px),
                linear-gradient(90deg, rgba(0,87,184,0.06) 1px, transparent 1px);
            background-size: 56px 56px;
            pointer-events: none; z-index: 0;
        }

        .orb { position: fixed; border-radius: 50%; filter: blur(90px); pointer-events: none; z-index: 0; animation: floatOrb 9s ease-in-out infinite; }
        .orb-1 { width: 500px; height: 500px; background: radial-gradient(circle, rgba(0,87,184,0.18) 0%, transparent 70%); top: -140px; left: -100px; }
        .orb-2 { width: 340px; height: 340px; background: radial-gradient(circle, rgba(0,48,135,0.15) 0%, transparent 70%); bottom: -100px; right: -80px; animation-delay: -4s; }
        .orb-3 { width: 220px; height: 220px; background: radial-gradient(circle, rgba(230,0,38,0.08) 0%, transparent 70%); top: 45%; right: 8%; animation-delay: -7s; }
        @keyframes floatOrb {
            0%, 100% { transform: translateY(0)   scale(1);    }
            50%       { transform: translateY(-22px) scale(1.05); }
        }

        /* ===== CARD ===== */
        .login-wrap {
            position: relative; z-index: 10;
            width: 100%;
            max-width: 1020px;
            display: flex;
            border-radius: 22px;
            overflow: hidden;
            box-shadow:
                0 40px 100px rgba(0,0,0,0.55),
                0  0   0 1px rgba(255,255,255,0.055);
            animation: cardIn 0.55s cubic-bezier(.4,0,.2,1) both;
        }
        @keyframes cardIn {
            from { opacity: 0; transform: translateY(28px) scale(0.97); }
            to   { opacity: 1; transform: translateY(0)    scale(1);    }
        }

        /* ===== LEFT PANEL ===== */
        .login-left {
            flex: 1;
            background: linear-gradient(148deg, #0e2040 0%, #091526 100%);
            padding: 64px 52px;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            gap: 48px;
            border-right: 1px solid rgba(255,255,255,0.055);
            position: relative;
            overflow: hidden;
        }
        .login-left::before {
            content: '';
            position: absolute; inset: 0;
            background:
                radial-gradient(circle at 25% 75%, rgba(0,87,184,0.13) 0%, transparent 50%),
                radial-gradient(circle at 80% 18%, rgba(0,48,135,0.10) 0%, transparent 45%);
            pointer-events: none;
        }

        /* Logo */
        .left-top { position: relative; z-index: 1; }

        .logo-pill {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            background: #ffffff;
            border-radius: 14px;
            padding: 12px 22px;
            box-shadow: 0 6px 24px rgba(0,0,0,0.28);
            margin-bottom: 36px;
        }
        .logo-pill img {
            width: 148px;
            height: auto;
            display: block;
            object-fit: contain;
        }

        .left-headline h1 {
            font-size: 30px;
            font-weight: 700;
            color: #fff;
            line-height: 1.3;
            margin-bottom: 14px;
        }
        .left-headline h1 span { color: #5aabff; }
        .left-headline p {
            font-size: 14.5px;
            color: #4e7099;
            line-height: 1.7;
            max-width: 310px;
        }

        /* Feature pills */
        .feature-list {
            position: relative; z-index: 1;
            display: flex;
            flex-direction: column;
            gap: 12px;
        }
        .feature-pill {
            display: flex; align-items: center; gap: 14px;
            padding: 13px 16px;
            background: rgba(255,255,255,0.035);
            border: 1px solid rgba(255,255,255,0.065);
            border-radius: 12px;
            transition: background 0.2s;
        }
        .feature-pill:hover { background: rgba(255,255,255,0.055); }
        .fp-icon {
            width: 34px; height: 34px;
            border-radius: 9px;
            background: rgba(0,87,184,0.22);
            display: flex; align-items: center; justify-content: center;
            font-size: 13px;
            color: #5aabff;
            flex-shrink: 0;
        }
        .feature-pill span {
            font-size: 13.5px;
            color: #7a9cbf;
            font-weight: 500;
        }

        /* Left footer */
        .left-footer {
            position: relative; z-index: 1;
            font-size: 11.5px;
            color: #2d4a65;
        }

        /* ===== RIGHT PANEL ===== */
        .login-right {
            width: 420px;
            flex-shrink: 0;
            background: #ffffff;
            padding: 64px 48px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            gap: 0;
        }

        /* Form header */
        .form-head {
            margin-bottom: 36px;
        }
        .form-head h2 {
            font-size: 24px;
            font-weight: 700;
            color: #0d1b2e;
            margin-bottom: 8px;
            letter-spacing: -0.3px;
        }
        .form-head p {
            font-size: 13.5px;
            color: #8fa8c0;
            line-height: 1.5;
        }

        /* Error */
        .error-box {
            display: flex; align-items: flex-start; gap: 11px;
            padding: 13px 16px;
            background: #fff3f4;
            border: 1px solid #ffd6da;
            border-radius: 11px;
            margin-bottom: 24px;
            font-size: 13px;
            color: #b82030;
            line-height: 1.45;
        }
        .error-box i { color: #d63040; font-size: 15px; flex-shrink: 0; margin-top: 1px; }

        /* Fields */
        .field-group {
            display: flex;
            flex-direction: column;
            gap: 20px;
            margin-bottom: 14px;
        }
        .field-wrap label {
            display: block;
            font-size: 12.5px;
            font-weight: 600;
            color: #4e6a85;
            margin-bottom: 8px;
            letter-spacing: 0.2px;
        }
        .field-inner { position: relative; }
        .f-icon {
            position: absolute;
            left: 15px; top: 50%;
            transform: translateY(-50%);
            color: #b8cfe0;
            font-size: 14px;
            pointer-events: none;
            transition: color 0.2s;
        }
        .field-wrap input {
            width: 100%;
            height: 50px;
            padding: 0 48px 0 44px;
            border: 1.5px solid #e0e8f2;
            border-radius: 11px;
            font-family: 'Outfit', sans-serif;
            font-size: 14.5px;
            color: #0d1b2e;
            background: #f7fafd;
            outline: none;
            transition: border-color 0.2s, box-shadow 0.2s, background 0.2s;
        }
        .field-wrap input::placeholder { color: #b8cfe0; }
        .field-wrap input:focus {
            border-color: #1a6fff;
            background: #fff;
            box-shadow: 0 0 0 3.5px rgba(26,111,255,0.10);
        }
        .field-inner:focus-within .f-icon { color: #1a6fff; }

        .eye-btn {
            position: absolute;
            right: 15px; top: 50%;
            transform: translateY(-50%);
            background: none; border: none;
            color: #b8cfe0; cursor: pointer;
            font-size: 14px; padding: 0; line-height: 1;
            transition: color 0.2s;
        }
        .eye-btn:hover { color: #1a6fff; }

        /* Forgot */
        .forgot-row {
            display: flex;
            justify-content: flex-end;
            margin-top: 10px;
            margin-bottom: 28px;
        }
        .forgot-row a {
            font-size: 12.5px;
            color: #1a6fff;
            text-decoration: none;
            font-weight: 500;
        }
        .forgot-row a:hover { text-decoration: underline; }

        /* Submit */
        .btn-login {
            width: 100%;
            height: 52px;
            background: linear-gradient(135deg, #003087 0%, #1a6fff 100%);
            border: none;
            border-radius: 12px;
            color: #fff;
            font-family: 'Outfit', sans-serif;
            font-size: 15.5px;
            font-weight: 600;
            cursor: pointer;
            letter-spacing: 0.3px;
            display: flex; align-items: center; justify-content: center; gap: 10px;
            transition: transform 0.18s, box-shadow 0.18s, filter 0.18s;
        }
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 28px rgba(26,111,255,0.32);
            filter: brightness(1.06);
        }
        .btn-login:active { transform: translateY(0); box-shadow: none; }

        /* Form footer */
        .form-foot {
            margin-top: 32px;
            text-align: center;
            font-size: 12px;
            color: #c0d0e0;
            border-top: 1px solid #eef2f8;
            padding-top: 20px;
        }
        .form-foot strong { color: #7090aa; }

        /* ===== RESPONSIVE ===== */
        @media (max-width: 820px) {
            .login-left  { display: none; }
            .login-right { width: 100%; padding: 52px 40px; }
            .login-wrap  { max-width: 480px; }
        }
        @media (max-width: 480px) {
            body { padding: 16px; }
            .login-right { padding: 44px 28px; }
        }
    </style>
</head>
<body>
    <div class="orb orb-1"></div>
    <div class="orb orb-2"></div>
    <div class="orb orb-3"></div>

    <div class="login-wrap">

        <!-- LEFT -->
        <div class="login-left">
            <div class="left-top">
                <div class="logo-pill">
                    <img src="GS_Caltex_Logo.png" alt="GS Caltex">
                </div>
                <div class="left-headline">
                    <h1>Welcome to<br><span>Admin Portal</span></h1>
                    <p>Manage your GS Caltex operations securely from one centralized dashboard.</p>
                </div>
            </div>

            <div class="feature-list">
                <div class="feature-pill">
                    <div class="fp-icon"><i class="fa-solid fa-users"></i></div>
                    <span>Employee Management</span>
                </div>
                <div class="feature-pill">
                    <div class="fp-icon"><i class="fa-solid fa-chart-line"></i></div>
                    <span>Usage Reports & Analytics</span>
                </div>
                <div class="feature-pill">
                    <div class="fp-icon"><i class="fa-solid fa-bell"></i></div>
                    <span>Push Notifications</span>
                </div>
                <div class="feature-pill">
                    <div class="fp-icon"><i class="fa-solid fa-shield-halved"></i></div>
                    <span>Secure Access Control</span>
                </div>
            </div>

            <div class="left-footer">
                &copy; <?= date('Y') ?> GS Caltex Corporation. All rights reserved.
            </div>
        </div>

        <!-- RIGHT -->
        <div class="login-right">

            <div class="form-head">
                <h2>Sign In</h2>
                <p>Enter your credentials to access<br>the admin panel</p>
            </div>

            <?php if($error): ?>
            <div class="error-box">
                <i class="fa-solid fa-circle-exclamation"></i>
                <?= htmlspecialchars($error) ?>
            </div>
            <?php endif; ?>

            <form method="POST" action="" autocomplete="off">
                <div class="field-group">
                    <!-- Email -->
                    <div class="field-wrap">
                        <label for="emailInput">Email Address</label>
                        <div class="field-inner">
                            <i class="fa-solid fa-envelope f-icon"></i>
                            <input
                                type="email"
                                id="emailInput"
                                name="email"
                                placeholder="admin@gscaltex.com"
                                value="<?= isset($_POST['email']) ? htmlspecialchars($_POST['email']) : '' ?>"
                                required
                                autocomplete="email"
                            >
                        </div>
                    </div>

                    <!-- Password -->
                    <div class="field-wrap">
                        <label for="passInput">Password</label>
                        <div class="field-inner">
                            <i class="fa-solid fa-lock f-icon"></i>
                            <input
                                type="password"
                                id="passInput"
                                name="password"
                                placeholder="Enter your password"
                                required
                                autocomplete="current-password"
                            >
                            <button type="button" class="eye-btn" onclick="togglePass()" tabindex="-1">
                                <i class="fa-solid fa-eye" id="eyeIcon"></i>
                            </button>
                        </div>
                    </div>
                </div>

                <div class="forgot-row">
                    <a href="reset_password.php">Forgot password?</a>
                </div>

                <button type="submit" class="btn-login">
                    Sign In &nbsp;<i class="fa-solid fa-arrow-right"></i>
                </button>
            </form>

            <div class="form-foot">
                &copy; <?= date('Y') ?> <strong>GS Caltex</strong>. All rights reserved.
            </div>
        </div>

    </div>

    <script>
        function togglePass() {
            const inp  = document.getElementById('passInput');
            const icon = document.getElementById('eyeIcon');
            if (inp.type === 'password') {
                inp.type = 'text';
                icon.className = 'fa-solid fa-eye-slash';
            } else {
                inp.type = 'password';
                icon.className = 'fa-solid fa-eye';
            }
        }
    </script>
</body>
</html>