<?php include 'header.php'; ?>

<?php
// ==========================================
// SEARCH FILTER
// ==========================================
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$search_condition = '';
if($search != '') {
    $search_safe = $conn->real_escape_string($search);
    $search_condition = " WHERE name LIKE '%$search_safe%' OR email LIKE '%$search_safe%'";
}

// ==========================================
// ACTION 1: ADD NEW EMPLOYEE
// ==========================================
$success_msg = "";
$error_msg = "";

if (isset($_POST['add_employee'])) {
    $name = $conn->real_escape_string(trim($_POST['name']));
    $email = $conn->real_escape_string(trim($_POST['email']));
    $password = substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 8);
    $check = $conn->query("SELECT id FROM users WHERE email = '$email'");
    if ($check->num_rows > 0) {
        $error_msg = "This email is already registered!";
    } else {
        $sql = "INSERT INTO users (name, email, password, status) VALUES ('$name', '$email', '$password', 'active')";
        if ($conn->query($sql) === TRUE) {
            $success_msg = "Employee created successfully! Password: <strong>$password</strong>";
        } else {
            $error_msg = "Error: " . $conn->error;
        }
    }
}

// ACTION 2: UPDATE EMPLOYEE
if (isset($_POST['update_employee'])) {
    $id = intval($_POST['emp_id']);
    $name = $conn->real_escape_string(trim($_POST['edit_name']));
    $email = $conn->real_escape_string(trim($_POST['edit_email']));
    $sql = "UPDATE users SET name = '$name', email = '$email' WHERE id = $id";
    if ($conn->query($sql) === TRUE) {
        $success_msg = "Employee updated successfully!";
    } else {
        $error_msg = "Error: " . $conn->error;
    }
}

// ACTION 3: RESET PASSWORD
if (isset($_POST['reset_password'])) {
    $id = intval($_POST['emp_id']);
    $new_password = substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 8);
    $sql = "UPDATE users SET password = '$new_password' WHERE id = $id";
    if ($conn->query($sql) === TRUE) {
        $success_msg = "Password reset! New Password: <strong>$new_password</strong>";
    } else {
        $error_msg = "Error: " . $conn->error;
    }
}

// ACTION 4: SEND EMAIL
if (isset($_POST['send_email'])) {
    $id = intval($_POST['emp_id']);
    $emp = $conn->query("SELECT * FROM users WHERE id = $id")->fetch_assoc();
    $to = $emp['email'];
    $subject = "Your Login Credentials";
    $message = "Hello " . $emp['name'] . ",\n\nYour login credentials:\nEmail: " . $emp['email'] . "\nPassword: " . $emp['password'] . "\n\nPlease login and change your password.\nThank you!";
    $headers = "From: noreply@yourdomain.com";
    if(mail($to, $subject, $message, $headers)) {
        $success_msg = "Email sent successfully to " . $emp['email'];
    } else {
        $error_msg = "Failed to send email. Please check your mail configuration.";
    }
}

// ACTION 5: DELETE EMPLOYEE
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $conn->query("DELETE FROM users WHERE id = $id");
    echo "<script>window.location.href='manage_employees.php';</script>";
    exit();
}

// ACTION 6: TOGGLE STATUS
if (isset($_GET['action']) && $_GET['action'] == 'toggle' && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $conn->query("UPDATE users SET status = IF(status='active', 'inactive', 'active') WHERE id = $id");
    echo "<script>window.location.href='manage_employees.php';</script>";
    exit();
}

// FETCH EMPLOYEES
$employees = $conn->query("SELECT * FROM users $search_condition ORDER BY id DESC");
$all_employees = $conn->query("SELECT name, email FROM users ORDER BY name ASC");
?>

<link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
    body, .main-content { font-family: 'Outfit', sans-serif !important; }

    /* ============================================================
       ALERTS
    ============================================================ */
    .alert {
        border-radius: 11px;
        border: none;
        font-size: 13.5px;
        font-weight: 500;
        padding: 13px 18px;
        margin-bottom: 22px;
    }
    .alert-success {
        background: #f0fdf8;
        border-left: 4px solid #10b981;
        color: #0a7a55;
    }
    .alert-danger {
        background: #fff3f4;
        border-left: 4px solid #e60026;
        color: #b82030;
    }

    /* ============================================================
       CARDS
    ============================================================ */
    .panel-card {
        background: var(--surface, #fff);
        border-radius: 16px;
        border: 1px solid var(--border, #dde8f3);
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        overflow: hidden;
    }
    .panel-head {
        padding: 20px 24px 0;
        display: flex;
        align-items: center;
        gap: 10px;
        margin-bottom: 22px;
    }
    .panel-head-icon {
        width: 34px; height: 34px;
        border-radius: 8px;
        display: flex; align-items: center; justify-content: center;
        font-size: 14px;
        flex-shrink: 0;
    }
    .pi-blue  { background: rgba(0,48,135,0.09);  color: #003087; }
    .pi-green { background: rgba(0,100,80,0.09);   color: #006450; }
    .panel-head h5 {
        font-size: 15px; font-weight: 700;
        color: var(--txt, #0d1b2e);
        margin: 0;
    }
    .panel-body { padding: 0 24px 24px; }

    /* ============================================================
       FORM
    ============================================================ */
    .field-lbl {
        display: block;
        font-size: 11.5px; font-weight: 600;
        color: var(--txt2, #4e6780);
        margin-bottom: 6px;
        letter-spacing: 0.3px;
        text-transform: uppercase;
    }
    .field-inp {
        width: 100%; height: 44px;
        padding: 0 14px;
        border: 1.5px solid var(--border, #dde8f3);
        border-radius: 10px;
        font-family: 'Outfit', sans-serif;
        font-size: 13.5px;
        color: var(--txt, #0d1b2e);
        background: var(--surface2, #f6fafd);
        outline: none;
        transition: border-color 0.2s, box-shadow 0.2s, background 0.2s;
    }
    .field-inp::placeholder { color: var(--txt3, #b5cedf); }
    .field-inp:focus {
        border-color: #1a6fff;
        background: var(--surface, #fff);
        box-shadow: 0 0 0 3px rgba(26,111,255,0.09);
    }

    .btn-add-emp {
        width: 100%; height: 46px;
        background: linear-gradient(135deg, #003087 0%, #1a6fff 100%);
        border: none; border-radius: 10px;
        color: #fff; font-family: 'Outfit', sans-serif;
        font-size: 14px; font-weight: 600;
        cursor: pointer; letter-spacing: 0.3px;
        display: flex; align-items: center; justify-content: center; gap: 8px;
        transition: transform 0.18s, box-shadow 0.18s, filter 0.18s;
        margin-top: 22px;
    }
    .btn-add-emp:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 22px rgba(26,111,255,0.28);
        filter: brightness(1.06);
    }

    .form-hint {
        font-size: 11.5px; color: var(--txt3, #94adc5);
        margin-top: 10px;
        display: flex; align-items: center; gap: 5px;
    }

    /* ============================================================
       TABLE HEADER (search row)
    ============================================================ */
    .tbl-header {
        display: flex; align-items: center;
        justify-content: space-between;
        flex-wrap: wrap; gap: 12px;
        padding: 20px 24px 16px;
        border-bottom: 1px solid var(--border, #dde8f3);
    }
    .tbl-title {
        display: flex; align-items: center; gap: 10px;
    }
    .tbl-title h5 {
        font-size: 15px; font-weight: 700;
        color: var(--txt, #0d1b2e); margin: 0;
    }
    .emp-count {
        background: rgba(0,48,135,0.1);
        color: #003087;
        font-size: 11px; font-weight: 700;
        padding: 3px 9px; border-radius: 20px;
    }
    .search-form {
        display: flex; align-items: center; gap: 7px;
    }
    .search-inp {
        height: 38px;
        width: 240px;
        padding: 0 14px;
        border: 1.5px solid var(--border, #dde8f3);
        border-radius: 9px;
        font-family: 'Outfit', sans-serif;
        font-size: 13px;
        color: var(--txt, #0d1b2e);
        background: var(--surface2, #f6fafd);
        outline: none;
        transition: border-color 0.2s, box-shadow 0.2s;
    }
    .search-inp:focus {
        border-color: #1a6fff;
        box-shadow: 0 0 0 3px rgba(26,111,255,0.08);
    }
    .btn-search {
        height: 38px; padding: 0 14px;
        background: #003087; color: #fff;
        border: none; border-radius: 9px;
        font-size: 13px; font-weight: 600;
        cursor: pointer; transition: filter 0.18s;
        display: flex; align-items: center; gap: 6px;
    }
    .btn-search:hover { filter: brightness(1.15); }
    .btn-clear {
        height: 38px; padding: 0 13px;
        background: var(--surface2, #f0f3f8);
        border: 1.5px solid var(--border, #dde8f3);
        border-radius: 9px;
        font-size: 13px; color: var(--txt2, #4e6780);
        cursor: pointer; transition: all 0.18s;
        text-decoration: none;
        display: flex; align-items: center;
    }
    .btn-clear:hover { border-color: #e60026; color: #e60026; }

    /* ============================================================
       TABLE
    ============================================================ */
    .emp-table { width: 100%; border-collapse: collapse; }

    .emp-table thead th {
        background: #f4f7fc;
        padding: 12px 16px;
        font-size: 10.5px; font-weight: 700;
        text-transform: uppercase; letter-spacing: 1px;
        color: var(--txt2, #4e6780);
        border-bottom: 1px solid var(--border, #dde8f3);
        white-space: nowrap;
    }
    [data-theme="dark"] .emp-table thead th {
        background: rgba(255,255,255,0.04);
    }

    .emp-table tbody tr {
        border-bottom: 1px solid var(--border, #dde8f3);
        transition: background 0.18s;
    }
    .emp-table tbody tr:last-child { border-bottom: none; }
    .emp-table tbody tr:hover { background: rgba(0,48,135,0.03); }
    [data-theme="dark"] .emp-table tbody tr:hover { background: rgba(26,111,255,0.06); }

    .emp-table tbody td {
        padding: 13px 16px;
        vertical-align: middle;
        font-size: 13.5px;
        color: var(--txt, #0d1b2e);
    }

    /* ID badge */
    .id-badge {
        display: inline-flex; align-items: center;
        background: rgba(0,48,135,0.09);
        color: #003087;
        font-size: 11px; font-weight: 700;
        padding: 3px 9px; border-radius: 6px;
        letter-spacing: 0.3px;
    }
    [data-theme="dark"] .id-badge { background: rgba(26,111,255,0.15); color: #5ba3ff; }

    /* Name */
    .emp-name {
        font-weight: 600;
        color: var(--txt, #0d1b2e);
        font-size: 13.5px;
    }
    .emp-email {
        font-size: 12px;
        color: var(--txt3, #94adc5);
        margin-top: 2px;
    }

    /* Password */
    .pass-code {
        font-family: 'Courier New', monospace;
        font-size: 12px; font-weight: 700;
        background: #fff5f5;
        color: #c0303a;
        border: 1px solid #fecdd3;
        padding: 3px 9px; border-radius: 6px;
        letter-spacing: 0.5px;
    }
    [data-theme="dark"] .pass-code {
        background: rgba(220,38,38,0.1);
        border-color: rgba(220,38,38,0.2);
        color: #f87171;
    }

    /* Status */
    .status-badge {
        display: inline-flex; align-items: center; gap: 5px;
        font-size: 11px; font-weight: 600;
        padding: 4px 10px; border-radius: 20px;
        text-transform: uppercase; letter-spacing: 0.4px;
    }
    .s-active   { background: #f0fdf4; color: #16a34a; }
    .s-inactive { background: #f8fafc; color: #94a3b8; }
    [data-theme="dark"] .s-active   { background: rgba(22,163,74,0.12);  color: #4ade80; }
    [data-theme="dark"] .s-inactive { background: rgba(148,163,184,0.1); color: #94a3b8; }

    /* Action buttons */
    .act-btn {
        width: 32px; height: 32px;
        border-radius: 8px; border: none;
        display: inline-flex; align-items: center; justify-content: center;
        font-size: 13px; cursor: pointer;
        text-decoration: none;
        transition: all 0.18s;
        flex-shrink: 0;
    }
    .act-edit   { background: rgba(26,111,255,0.10); color: #1a6fff; }
    .act-key    { background: rgba(14,165,233,0.10);  color: #0284c7; }
    .act-mail   { background: rgba(16,185,129,0.10);  color: #059669; }
    .act-toggle { background: rgba(245,158,11,0.10);  color: #d97706; }
    .act-del    { background: rgba(239,68,68,0.10);   color: #dc2626; }

    .act-btn:hover { transform: translateY(-2px); filter: brightness(1.12); }
    .act-edit:hover   { background: rgba(26,111,255,0.18); }
    .act-key:hover    { background: rgba(14,165,233,0.18); }
    .act-mail:hover   { background: rgba(16,185,129,0.18); }
    .act-toggle:hover { background: rgba(245,158,11,0.18); }
    .act-del:hover    { background: rgba(239,68,68,0.18); }

    .actions-wrap { display: flex; gap: 5px; flex-wrap: nowrap; }

    /* Empty state */
    .empty-state {
        padding: 60px 20px;
        text-align: center;
        color: var(--txt3, #94adc5);
    }
    .empty-state i { font-size: 40px; opacity: 0.25; margin-bottom: 14px; display: block; }
    .empty-state h6 { font-size: 15px; font-weight: 600; color: var(--txt2, #4e6780); margin-bottom: 6px; }
    .empty-state p  { font-size: 13px; margin: 0; }

    /* ============================================================
       MODALS
    ============================================================ */
    .modal-content {
        border-radius: 16px !important;
        border: 1px solid var(--border, #dde8f3) !important;
        background: var(--surface, #fff) !important;
        box-shadow: 0 20px 60px rgba(0,0,0,0.18) !important;
        overflow: hidden;
    }
    .modal-top {
        padding: 20px 22px 18px;
        display: flex; align-items: center; justify-content: space-between;
        border-bottom: 1px solid var(--border, #dde8f3);
    }
    .modal-top-title {
        display: flex; align-items: center; gap: 10px;
        font-size: 15px; font-weight: 700;
        color: var(--txt, #0d1b2e);
    }
    .modal-top-icon {
        width: 32px; height: 32px; border-radius: 8px;
        display: flex; align-items: center; justify-content: center;
        font-size: 13px;
    }
    .mti-blue  { background: rgba(26,111,255,0.1);  color: #1a6fff; }
    .mti-cyan  { background: rgba(6,182,212,0.10);   color: #0891b2; }
    .mti-green { background: rgba(16,185,129,0.10);  color: #059669; }

    .modal-btn-close {
        width: 28px; height: 28px;
        background: var(--surface2, #f0f3f8);
        border: none; border-radius: 6px;
        display: flex; align-items: center; justify-content: center;
        font-size: 12px; color: var(--txt2, #4e6780);
        cursor: pointer; transition: all 0.18s;
    }
    .modal-btn-close:hover { background: #fef2f2; color: #dc2626; }

    .modal-bod { padding: 22px; }
    .modal-ft {
        padding: 16px 22px;
        border-top: 1px solid var(--border, #dde8f3);
        display: flex; justify-content: flex-end; gap: 8px;
    }

    .btn-cancel {
        height: 38px; padding: 0 16px;
        background: var(--surface2, #f0f3f8);
        border: 1.5px solid var(--border, #dde8f3);
        border-radius: 9px;
        font-size: 13px; font-weight: 600;
        color: var(--txt2, #4e6780); cursor: pointer;
        transition: all 0.18s;
    }
    .btn-cancel:hover { border-color: #94a3b8; }

    .btn-confirm {
        height: 38px; padding: 0 18px;
        border: none; border-radius: 9px;
        font-size: 13px; font-weight: 600;
        color: #fff; cursor: pointer;
        transition: filter 0.18s, transform 0.18s;
    }
    .btn-confirm:hover { filter: brightness(1.1); transform: translateY(-1px); }
    .bc-blue  { background: linear-gradient(135deg, #003087, #1a6fff); }
    .bc-cyan  { background: linear-gradient(135deg, #0284c7, #06b6d4); }
    .bc-green { background: linear-gradient(135deg, #059669, #10b981); }

    .info-row {
        display: flex; gap: 8px; align-items: flex-start;
        padding: 12px 14px;
        background: rgba(26,111,255,0.06);
        border: 1px solid rgba(26,111,255,0.12);
        border-radius: 10px;
        font-size: 13px; color: var(--txt, #0d1b2e);
        margin-bottom: 16px;
    }
    .info-row i { color: #1a6fff; flex-shrink: 0; margin-top: 2px; }

    .cred-list { list-style: none; padding: 0; margin: 0; }
    .cred-list li {
        display: flex; align-items: center; gap: 8px;
        padding: 9px 0;
        border-bottom: 1px solid var(--border, #dde8f3);
        font-size: 13px; color: var(--txt, #0d1b2e);
    }
    .cred-list li:last-child { border-bottom: none; }

    /* dark mode modals */
    [data-theme="dark"] .modal-content { background: var(--surface) !important; border-color: var(--border) !important; }
    [data-theme="dark"] .modal-top      { border-color: var(--border); }
    [data-theme="dark"] .modal-ft       { border-color: var(--border); }
    [data-theme="dark"] .btn-cancel     { background: var(--surface2); border-color: var(--border); color: var(--txt2); }
    [data-theme="dark"] .info-row       { background: rgba(26,111,255,0.08); border-color: rgba(26,111,255,0.15); }
    [data-theme="dark"] .field-inp      { background: var(--surface2); border-color: var(--border); color: var(--txt); }
    [data-theme="dark"] .search-inp     { background: var(--surface2); border-color: var(--border); color: var(--txt); }
    [data-theme="dark"] .emp-table thead th { color: var(--txt2); }
    [data-theme="dark"] .emp-count { background: rgba(26,111,255,0.15); color: #5ba3ff; }
    [data-theme="dark"] .modal-btn-close { background: var(--surface2); }
</style>

<?php if($success_msg): ?>
<div class="alert alert-success alert-dismissible fade show">
    <i class="fa-solid fa-circle-check me-2"></i><?= $success_msg ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>
<?php if($error_msg): ?>
<div class="alert alert-danger alert-dismissible fade show">
    <i class="fa-solid fa-circle-exclamation me-2"></i><?= $error_msg ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="row g-3">

    <!-- ========== LEFT: ADD FORM ========== -->
    <div class="col-lg-4">
        <div class="panel-card">
            <div class="panel-head">
                <div class="panel-head-icon pi-blue"><i class="fa-solid fa-user-plus"></i></div>
                <h5>Add New Employee</h5>
            </div>
            <div class="panel-body">
                <form method="POST">
                    <div class="mb-3">
                        <label class="field-lbl">Full Name</label>
                        <input type="text" name="name" class="field-inp" placeholder="Enter full name" required>
                    </div>
                    <div class="mb-2">
                        <label class="field-lbl">Email Address</label>
                        <input type="email" name="email" class="field-inp" placeholder="Enter email address" required>
                    </div>
                    <button type="submit" name="add_employee" class="btn-add-emp">
                        <i class="fa-solid fa-plus"></i> Create Employee
                    </button>
                    <div class="form-hint">
                        <i class="fa-solid fa-info-circle"></i>
                        Password auto-generated (8 characters)
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- ========== RIGHT: TABLE ========== -->
    <div class="col-lg-8">
        <div class="panel-card">

            <!-- Table header -->
            <div class="tbl-header">
                <div class="tbl-title">
                    <div class="panel-head-icon pi-green" style="width:30px;height:30px;font-size:13px;">
                        <i class="fa-solid fa-users"></i>
                    </div>
                    <h5>All Employees</h5>
                    <span class="emp-count"><?= $employees->num_rows ?></span>
                </div>

                <form method="GET" class="search-form">
                    <input type="text" name="search" list="employeeList" class="search-inp"
                        placeholder="Search name or email…"
                        value="<?= htmlspecialchars($search) ?>">
                    <datalist id="employeeList">
                        <?php while($emp = $all_employees->fetch_assoc()): ?>
                            <option value="<?= htmlspecialchars($emp['name']) ?>">
                        <?php endwhile; ?>
                    </datalist>
                    <button type="submit" class="btn-search">
                        <i class="fa-solid fa-search"></i>
                    </button>
                    <?php if($search != ''): ?>
                    <a href="manage_employees.php" class="btn-clear">
                        <i class="fa-solid fa-xmark"></i>
                    </a>
                    <?php endif; ?>
                </form>
            </div>

            <!-- Table -->
            <div class="table-responsive">
                <table class="emp-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Employee</th>
                            <th>Password</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($employees->num_rows > 0): ?>
                            <?php while($row = $employees->fetch_assoc()): ?>
                            <tr>
                                <td><span class="id-badge">#<?= $row['id'] ?></span></td>
                                <td>
                                    <div class="emp-name"><?= htmlspecialchars($row['name']) ?></div>
                                    <div class="emp-email"><?= htmlspecialchars($row['email']) ?></div>
                                </td>
                                <td><span class="pass-code"><?= $row['password'] ?></span></td>
                                <td>
                                    <?php if($row['status'] == 'active'): ?>
                                        <span class="status-badge s-active"><i class="fa-solid fa-circle" style="font-size:7px;"></i> Active</span>
                                    <?php else: ?>
                                        <span class="status-badge s-inactive"><i class="fa-solid fa-circle" style="font-size:7px;"></i> Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="actions-wrap">
                                        <a href="#" class="act-btn act-edit" title="Edit"
                                           data-bs-toggle="modal" data-bs-target="#editModal<?= $row['id'] ?>">
                                            <i class="fa-solid fa-pen"></i>
                                        </a>
                                        <a href="#" class="act-btn act-key" title="Reset Password"
                                           data-bs-toggle="modal" data-bs-target="#resetModal<?= $row['id'] ?>">
                                            <i class="fa-solid fa-key"></i>
                                        </a>
                                        <a href="#" class="act-btn act-mail" title="Send Email"
                                           data-bs-toggle="modal" data-bs-target="#emailModal<?= $row['id'] ?>">
                                            <i class="fa-solid fa-envelope"></i>
                                        </a>
                                        <a href="?action=toggle&id=<?= $row['id'] ?>" class="act-btn act-toggle" title="Toggle Status">
                                            <i class="fa-solid fa-toggle-on"></i>
                                        </a>
                                        <a href="?action=delete&id=<?= $row['id'] ?>" class="act-btn act-del" title="Delete"
                                           onclick="return confirm('Delete this employee?')">
                                            <i class="fa-solid fa-trash"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>

                            <!-- EDIT MODAL -->
                            <div class="modal fade" id="editModal<?= $row['id'] ?>" tabindex="-1">
                                <div class="modal-dialog modal-dialog-centered">
                                    <div class="modal-content">
                                        <div class="modal-top">
                                            <div class="modal-top-title">
                                                <span class="modal-top-icon mti-blue"><i class="fa-solid fa-pen"></i></span>
                                                Edit Employee
                                            </div>
                                            <button class="modal-btn-close" data-bs-dismiss="modal"><i class="fa-solid fa-xmark"></i></button>
                                        </div>
                                        <form method="POST">
                                            <div class="modal-bod">
                                                <input type="hidden" name="emp_id" value="<?= $row['id'] ?>">
                                                <div class="mb-3">
                                                    <label class="field-lbl">Full Name</label>
                                                    <input type="text" name="edit_name" class="field-inp" value="<?= htmlspecialchars($row['name']) ?>" required>
                                                </div>
                                                <div>
                                                    <label class="field-lbl">Email Address</label>
                                                    <input type="email" name="edit_email" class="field-inp" value="<?= htmlspecialchars($row['email']) ?>" required>
                                                </div>
                                            </div>
                                            <div class="modal-ft">
                                                <button type="button" class="btn-cancel" data-bs-dismiss="modal">Cancel</button>
                                                <button type="submit" name="update_employee" class="btn-confirm bc-blue">
                                                    <i class="fa-solid fa-save me-2"></i>Save Changes
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <!-- RESET PASSWORD MODAL -->
                            <div class="modal fade" id="resetModal<?= $row['id'] ?>" tabindex="-1">
                                <div class="modal-dialog modal-dialog-centered">
                                    <div class="modal-content">
                                        <div class="modal-top">
                                            <div class="modal-top-title">
                                                <span class="modal-top-icon mti-cyan"><i class="fa-solid fa-key"></i></span>
                                                Reset Password
                                            </div>
                                            <button class="modal-btn-close" data-bs-dismiss="modal"><i class="fa-solid fa-xmark"></i></button>
                                        </div>
                                        <form method="POST">
                                            <div class="modal-bod">
                                                <input type="hidden" name="emp_id" value="<?= $row['id'] ?>">
                                                <div class="info-row">
                                                    <i class="fa-solid fa-triangle-exclamation"></i>
                                                    <div>Reset password for <strong><?= htmlspecialchars($row['name']) ?></strong>? A new random 8-character password will be generated.</div>
                                                </div>
                                            </div>
                                            <div class="modal-ft">
                                                <button type="button" class="btn-cancel" data-bs-dismiss="modal">Cancel</button>
                                                <button type="submit" name="reset_password" class="btn-confirm bc-cyan">
                                                    <i class="fa-solid fa-rotate me-2"></i>Reset Password
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <!-- SEND EMAIL MODAL -->
                            <div class="modal fade" id="emailModal<?= $row['id'] ?>" tabindex="-1">
                                <div class="modal-dialog modal-dialog-centered">
                                    <div class="modal-content">
                                        <div class="modal-top">
                                            <div class="modal-top-title">
                                                <span class="modal-top-icon mti-green"><i class="fa-solid fa-envelope"></i></span>
                                                Send Credentials
                                            </div>
                                            <button class="modal-btn-close" data-bs-dismiss="modal"><i class="fa-solid fa-xmark"></i></button>
                                        </div>
                                        <form method="POST">
                                            <div class="modal-bod">
                                                <input type="hidden" name="emp_id" value="<?= $row['id'] ?>">
                                                <div class="info-row">
                                                    <i class="fa-solid fa-paper-plane"></i>
                                                    <div>Sending credentials to <strong><?= htmlspecialchars($row['email']) ?></strong></div>
                                                </div>
                                                <ul class="cred-list">
                                                    <li><i class="fa-solid fa-user" style="color:#1a6fff;width:16px;"></i> <strong>Name:</strong> &nbsp;<?= htmlspecialchars($row['name']) ?></li>
                                                    <li><i class="fa-solid fa-envelope" style="color:#1a6fff;width:16px;"></i> <strong>Email:</strong> &nbsp;<?= htmlspecialchars($row['email']) ?></li>
                                                    <li><i class="fa-solid fa-lock" style="color:#1a6fff;width:16px;"></i> <strong>Password:</strong> &nbsp;<span class="pass-code"><?= $row['password'] ?></span></li>
                                                </ul>
                                            </div>
                                            <div class="modal-ft">
                                                <button type="button" class="btn-cancel" data-bs-dismiss="modal">Cancel</button>
                                                <button type="submit" name="send_email" class="btn-confirm bc-green">
                                                    <i class="fa-solid fa-paper-plane me-2"></i>Send Email
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5">
                                    <div class="empty-state">
                                        <i class="fa-solid fa-users-slash"></i>
                                        <h6><?= $search != '' ? 'No employees found' : 'No employees yet' ?></h6>
                                        <p><?= $search != '' ? 'Try a different search term.' : 'Create your first employee using the form on the left.' ?></p>
                                        <?php if($search != ''): ?>
                                        <a href="manage_employees.php" class="btn-search mt-3" style="text-decoration:none;display:inline-flex;">
                                            <i class="fa-solid fa-xmark"></i> Clear Search
                                        </a>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<?php include 'footer.php'; ?>