<?php include 'header.php'; ?>

<link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
    body, .main-content { font-family: 'Outfit', sans-serif !important; }

    /* ============================================================
       BANNER
    ============================================================ */
    .notif-banner {
        background: linear-gradient(125deg, #003087 0%, #0057B8 55%, #1a6fff 100%);
        border-radius: 16px;
        padding: 28px 32px;
        margin-bottom: 26px;
        display: flex;
        align-items: center;
        justify-content: space-between;
        position: relative;
        overflow: hidden;
        box-shadow: 0 8px 28px rgba(0,48,135,0.28);
    }
    .notif-banner::before {
        content: '';
        position: absolute; right: -50px; top: -50px;
        width: 200px; height: 200px; border-radius: 50%;
        background: rgba(255,255,255,0.06);
    }
    .notif-banner::after {
        content: '';
        position: absolute; right: 60px; bottom: -70px;
        width: 150px; height: 150px; border-radius: 50%;
        background: rgba(255,255,255,0.04);
    }
    .banner-text { position: relative; z-index: 1; }
    .banner-text h4 {
        font-size: 20px; font-weight: 700;
        color: #fff; margin: 0 0 5px;
    }
    .banner-text p {
        font-size: 13px; color: rgba(255,255,255,0.72); margin: 0;
    }
    .banner-icon {
        position: relative; z-index: 1;
        font-size: 56px; color: rgba(255,255,255,0.10);
    }

    /* ============================================================
       PANEL CARDS
    ============================================================ */
    .notif-card {
        background: var(--surface, #fff);
        border: 1px solid var(--border, #dde8f3);
        border-radius: 16px;
        overflow: hidden;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        height: 100%;
    }

    .card-head {
        padding: 18px 24px;
        border-bottom: 1px solid var(--border, #dde8f3);
        display: flex; align-items: center; gap: 10px;
        background: var(--surface2, #f6f9fd);
    }
    .ch-icon {
        width: 34px; height: 34px; border-radius: 9px;
        display: flex; align-items: center; justify-content: center;
        font-size: 14px; flex-shrink: 0;
    }
    .chi-blue  { background: rgba(0,48,135,0.09);  color: #003087; }
    .chi-green { background: rgba(5,150,105,0.10);  color: #059669; }

    .card-head h5 {
        font-size: 14.5px; font-weight: 700;
        color: var(--txt, #0d1b2e); margin: 0;
    }

    .card-body-inner { padding: 24px; }

    /* ============================================================
       FORM ELEMENTS
    ============================================================ */
    .f-label {
        display: block;
        font-size: 11.5px; font-weight: 600;
        color: var(--txt2, #4e6780);
        margin-bottom: 6px;
        text-transform: uppercase; letter-spacing: 0.3px;
    }

    .f-control {
        width: 100%;
        padding: 11px 14px;
        border: 1.5px solid var(--border, #dde8f3);
        border-radius: 10px;
        font-family: 'Outfit', sans-serif;
        font-size: 13.5px;
        color: var(--txt, #0d1b2e);
        background: var(--surface2, #f6fafd);
        outline: none;
        transition: border-color 0.2s, box-shadow 0.2s, background 0.2s;
        appearance: none;
    }
    .f-control::placeholder { color: var(--txt3, #b5cedf); }
    .f-control:focus {
        border-color: #1a6fff;
        background: var(--surface, #fff);
        box-shadow: 0 0 0 3px rgba(26,111,255,0.09);
    }

    textarea.f-control {
        min-height: 110px;
        resize: vertical;
        padding: 12px 14px;
        line-height: 1.6;
    }

    /* Select arrow */
    .select-wrap { position: relative; }
    .select-wrap::after {
        content: '\f078';
        font-family: 'Font Awesome 6 Free';
        font-weight: 900;
        position: absolute; right: 14px; top: 50%;
        transform: translateY(-50%);
        color: var(--txt3, #94adc5);
        font-size: 11px;
        pointer-events: none;
    }
    select.f-control { padding-right: 36px; cursor: pointer; }

    .char-hint {
        font-size: 11px; color: var(--txt3, #94adc5);
        margin-top: 5px; display: block;
    }

    /* Info box */
    .info-box {
        display: flex; align-items: flex-start; gap: 10px;
        padding: 12px 14px;
        background: rgba(26,111,255,0.06);
        border: 1px solid rgba(26,111,255,0.12);
        border-radius: 10px;
        margin-bottom: 20px;
        font-size: 13px;
        color: var(--txt, #0d1b2e);
        line-height: 1.5;
    }
    .info-box i { color: #1a6fff; flex-shrink: 0; margin-top: 2px; }

    /* Buttons */
    .btn-send-notif {
        display: inline-flex; align-items: center; gap: 8px;
        height: 44px; padding: 0 22px;
        border: none; border-radius: 10px;
        font-family: 'Outfit', sans-serif;
        font-size: 14px; font-weight: 600;
        cursor: pointer;
        transition: transform 0.18s, box-shadow 0.18s, filter 0.18s;
    }
    .btn-send-notif:hover {
        transform: translateY(-2px);
        filter: brightness(1.08);
    }
    .btn-send-notif:active { transform: translateY(0); }

    .b-blue  {
        background: linear-gradient(135deg, #003087 0%, #1a6fff 100%);
        color: #fff;
        box-shadow: 0 4px 14px rgba(26,111,255,0.28);
    }
    .b-blue:hover  { box-shadow: 0 8px 22px rgba(26,111,255,0.34); }

    .b-green {
        background: linear-gradient(135deg, #047857 0%, #10b981 100%);
        color: #fff;
        box-shadow: 0 4px 14px rgba(16,185,129,0.25);
    }
    .b-green:hover { box-shadow: 0 8px 22px rgba(16,185,129,0.32); }

    .btn-row {
        display: flex; justify-content: flex-end;
        margin-top: 22px;
    }

    /* Divider between fields */
    .f-gap { margin-bottom: 18px; }

    /* ============================================================
       DARK MODE
    ============================================================ */
    [data-theme="dark"] .notif-card    { background: var(--surface); border-color: var(--border); }
    [data-theme="dark"] .card-head     { background: var(--surface2); border-color: var(--border); }
    [data-theme="dark"] .card-head h5  { color: var(--txt); }
    [data-theme="dark"] .chi-blue      { background: rgba(26,111,255,0.14); color: #5ba3ff; }
    [data-theme="dark"] .chi-green     { background: rgba(16,185,129,0.12); color: #34d399; }
    [data-theme="dark"] .f-control     { background: var(--surface2); border-color: var(--border); color: var(--txt); }
    [data-theme="dark"] .f-control:focus { background: var(--surface); }
    [data-theme="dark"] .info-box      { background: rgba(26,111,255,0.08); border-color: rgba(26,111,255,0.18); }
    [data-theme="dark"] .f-label       { color: var(--txt2); }
</style>

<!-- Banner -->
<div class="notif-banner">
    <div class="banner-text">
        <h4><i class="fa-solid fa-bell me-2"></i>Push Notifications</h4>
        <p>Send instant notifications to employees</p>
    </div>
    <div class="banner-icon d-none d-md-block">
        <i class="fa-solid fa-bullhorn"></i>
    </div>
</div>

<div class="row g-3">

    <!-- ===== LEFT: Individual ===== -->
    <div class="col-lg-6">
        <form method="POST" action="">
            <div class="notif-card">
                <div class="card-head">
                    <div class="ch-icon chi-blue"><i class="fa-solid fa-user"></i></div>
                    <h5>Send to Employee</h5>
                </div>
                <div class="card-body-inner">

                    <div class="f-gap">
                        <label class="f-label">Select Employee</label>
                        <div class="select-wrap">
                            <select name="user_id" class="f-control" required>
                                <option value="">— Choose Employee —</option>
                                <?php
                                $employees = $conn->query("SELECT id, name, email, status FROM users ORDER BY name ASC");
                                while($emp = $employees->fetch_assoc()):
                                ?>
                                <option value="<?= $emp['id'] ?>">
                                    <?= htmlspecialchars($emp['name']) ?> (<?= htmlspecialchars($emp['email']) ?>) — <?= ucfirst($emp['status']) ?>
                                </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>

                    <div class="f-gap">
                        <label class="f-label">Notification Title</label>
                        <input type="text" name="title" class="f-control"
                            placeholder="e.g. Welcome Message" required maxlength="100">
                    </div>

                    <div class="f-gap">
                        <label class="f-label">Message</label>
                        <textarea name="message" class="f-control"
                            placeholder="Type your message here…" required maxlength="500"></textarea>
                        <span class="char-hint"><i class="fa-solid fa-info-circle me-1"></i>Max 500 characters</span>
                    </div>

                    <div class="btn-row">
                        <button type="submit" name="send_notification" class="btn-send-notif b-blue">
                            <i class="fa-solid fa-paper-plane"></i> Send Notification
                        </button>
                    </div>

                </div>
            </div>
        </form>
    </div>

    <!-- ===== RIGHT: Broadcast ===== -->
    <div class="col-lg-6">
        <form method="POST" action="">
            <div class="notif-card">
                <div class="card-head">
                    <div class="ch-icon chi-green"><i class="fa-solid fa-users"></i></div>
                    <h5>Broadcast to All</h5>
                </div>
                <div class="card-body-inner">

                    <div class="info-box">
                        <i class="fa-solid fa-circle-info"></i>
                        <div>This will send a notification to all <strong>active</strong> employees at once.</div>
                    </div>

                    <div class="f-gap">
                        <label class="f-label">Notification Title</label>
                        <input type="text" name="broadcast_title" class="f-control"
                            placeholder="e.g. System Update" required maxlength="100">
                    </div>

                    <div class="f-gap">
                        <label class="f-label">Message</label>
                        <textarea name="broadcast_message" class="f-control"
                            placeholder="Type your message here…" required maxlength="500"></textarea>
                        <span class="char-hint"><i class="fa-solid fa-info-circle me-1"></i>Max 500 characters</span>
                    </div>

                    <div class="btn-row">
                        <button type="submit" name="send_to_all" class="btn-send-notif b-green">
                            <i class="fa-solid fa-bullhorn"></i> Broadcast to All
                        </button>
                    </div>

                </div>
            </div>
        </form>
    </div>

</div>

<?php include 'footer.php'; ?>