<?php
session_start();
include 'db.php';

$step = 1; // Step 1: Email, Step 2: OTP, Step 3: New Password
$error_msg = "";
$success_msg = "";

// ==========================================
// STEP 1: SEND OTP
// ==========================================
if(isset($_POST['send_otp'])) {
    $email = trim($_POST['email']);
    
    // Check if admin exists
    $check = $conn->query("SELECT id FROM admins WHERE email = '$email'");
    
    if($check->num_rows == 0) {
        $error_msg = "Email not found!";
    } else {
        // Generate 6-digit OTP
        $otp = rand(100000, 999999);
        
        // Delete old OTPs for this email
        $conn->query("DELETE FROM password_resets WHERE email = '$email'");
        
        // Store OTP (valid for 10 minutes)
        $expires_at = date('Y-m-d H:i:s', strtotime('+10 minutes'));
        $conn->query("INSERT INTO password_resets (email, otp, expires_at) VALUES ('$email', '$otp', '$expires_at')");
        
        // Send Email
        $subject = "Password Reset OTP";
        $message = "Your OTP for password reset is: $otp\n\nValid for 10 minutes.";
        $headers = "From: noreply@yourdomain.com";
        
        if(mail($email, $subject, $message, $headers)) {
            $_SESSION['reset_email'] = $email;
            $success_msg = "OTP sent to your email!";
            $step = 2;
        } else {
            $error_msg = "Failed to send email. Check SMTP settings.";
        }
    }
}

// ==========================================
// STEP 2: VERIFY OTP
// ==========================================
if(isset($_POST['verify_otp'])) {
    $email = $_SESSION['reset_email'] ?? '';
    $otp = trim($_POST['otp']);
    
    $result = $conn->query("SELECT * FROM password_resets WHERE email = '$email' AND otp = '$otp' AND expires_at > NOW()");
    
    if($result->num_rows > 0) {
        $_SESSION['otp_verified'] = true;
        $success_msg = "OTP verified! Set your new password.";
        $step = 3;
    } else {
        $error_msg = "Invalid or expired OTP!";
        $step = 2;
    }
}

// ==========================================
// STEP 3: RESET PASSWORD
// ==========================================
if(isset($_POST['reset_password'])) {
    $email = $_SESSION['reset_email'] ?? '';
    $new_password = trim($_POST['new_password']);
    $confirm_password = trim($_POST['confirm_password']);
    
    if($new_password !== $confirm_password) {
        $error_msg = "Passwords do not match!";
        $step = 3;
    } else {
        // Update password
        $conn->query("UPDATE admins SET password = '$new_password' WHERE email = '$email'");
        
        // Delete used OTP
        $conn->query("DELETE FROM password_resets WHERE email = '$email'");
        
        // Clear session
        unset($_SESSION['reset_email']);
        unset($_SESSION['otp_verified']);
        
        $success_msg = "Password reset successful! You can now login.";
        header("refresh:2;url=login.php");
    }
}

// Determine current step from session
if(isset($_SESSION['reset_email']) && !isset($_SESSION['otp_verified'])) {
    $step = 2;
} elseif(isset($_SESSION['otp_verified'])) {
    $step = 3;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password - Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .reset-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 450px;
            width: 100%;
            padding: 40px;
        }
        
        .reset-header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .reset-header .icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            font-size: 2rem;
            color: white;
        }
        
        .reset-header h2 {
            font-weight: 700;
            font-size: 1.8rem;
            color: #1e293b;
            margin-bottom: 10px;
        }
        
        .reset-header p {
            color: #64748b;
            font-size: 0.9rem;
        }
        
        .form-label {
            font-weight: 600;
            color: #334155;
            margin-bottom: 8px;
        }
        
        .form-control {
            border-radius: 12px;
            border: 2px solid #e2e8f0;
            padding: 14px 16px;
            font-size: 0.95rem;
            transition: 0.3s;
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 14px 28px;
            border-radius: 12px;
            font-weight: 600;
            width: 100%;
            transition: 0.3s;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(102, 126, 234, 0.4);
        }
        
        .step-indicator {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
            position: relative;
        }
        
        .step-indicator::before {
            content: '';
            position: absolute;
            top: 20px;
            left: 25%;
            right: 25%;
            height: 2px;
            background: #e2e8f0;
            z-index: 0;
        }
        
        .step {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #e2e8f0;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            color: #94a3b8;
            position: relative;
            z-index: 1;
        }
        
        .step.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .step.completed {
            background: #10b981;
            color: white;
        }
        
        .back-link {
            text-align: center;
            margin-top: 20px;
        }
        
        .back-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
        }
        
        .back-link a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>

<div class="reset-card">
    
    <!-- HEADER -->
    <div class="reset-header">
        <div class="icon">
            <i class="fa-solid fa-lock"></i>
        </div>
        <h2>Reset Password</h2>
        <p>
            <?php if($step == 1): ?>
                Enter your email to receive OTP
            <?php elseif($step == 2): ?>
                Enter the OTP sent to your email
            <?php else: ?>
                Create your new password
            <?php endif; ?>
        </p>
    </div>
    
    <!-- STEP INDICATOR -->
    <div class="step-indicator">
        <div class="step <?= $step >= 1 ? 'active' : ''; ?> <?= $step > 1 ? 'completed' : ''; ?>">1</div>
        <div class="step <?= $step >= 2 ? 'active' : ''; ?> <?= $step > 2 ? 'completed' : ''; ?>">2</div>
        <div class="step <?= $step >= 3 ? 'active' : ''; ?>">3</div>
    </div>
    
    <!-- ALERTS -->
    <?php if($success_msg): ?>
        <div class="alert alert-success" style="border-radius: 12px;">
            <i class="fa-solid fa-check-circle me-2"></i> <?= $success_msg; ?>
        </div>
    <?php endif; ?>
    
    <?php if($error_msg): ?>
        <div class="alert alert-danger" style="border-radius: 12px;">
            <i class="fa-solid fa-exclamation-circle me-2"></i> <?= $error_msg; ?>
        </div>
    <?php endif; ?>
    
    <!-- STEP 1: EMAIL INPUT -->
    <?php if($step == 1): ?>
        <form method="POST">
            <div class="mb-3">
                <label class="form-label">Admin Email</label>
                <input type="email" name="email" class="form-control" placeholder="admin@vantagegrow.com" required>
            </div>
            <button type="submit" name="send_otp" class="btn btn-primary">
                <i class="fa-solid fa-paper-plane me-2"></i> Send OTP
            </button>
        </form>
    <?php endif; ?>
    
    <!-- STEP 2: OTP VERIFICATION -->
    <?php if($step == 2): ?>
        <form method="POST">
            <div class="mb-3">
                <label class="form-label">Enter OTP</label>
                <input type="text" name="otp" class="form-control" placeholder="123456" maxlength="6" required 
                       style="text-align: center; font-size: 1.5rem; letter-spacing: 10px;">
            </div>
            <button type="submit" name="verify_otp" class="btn btn-primary">
                <i class="fa-solid fa-check me-2"></i> Verify OTP
            </button>
        </form>
    <?php endif; ?>
    
    <!-- STEP 3: NEW PASSWORD -->
    <?php if($step == 3): ?>
        <form method="POST">
            <div class="mb-3">
                <label class="form-label">New Password</label>
                <input type="password" name="new_password" class="form-control" placeholder="Enter new password" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Confirm Password</label>
                <input type="password" name="confirm_password" class="form-control" placeholder="Confirm password" required>
            </div>
            <button type="submit" name="reset_password" class="btn btn-primary">
                <i class="fa-solid fa-key me-2"></i> Reset Password
            </button>
        </form>
    <?php endif; ?>
    
    <!-- BACK TO LOGIN -->
    <div class="back-link">
        <a href="login.php"><i class="fa-solid fa-arrow-left me-2"></i> Back to Login</a>
    </div>
    
</div>

</body>
</html>
