<?php 
include 'header.php'; 

// ==========================================
// HANDLE OPENAI API KEY SUBMISSION
// ==========================================
if(isset($_POST['save_openai'])) {
    $openai_key = $_POST['openai_key'] ?? '';
    
    $stmt = $conn->prepare("INSERT INTO settings (setting_name, setting_value) VALUES ('openai_key', ?) ON DUPLICATE KEY UPDATE setting_value = ?");
    $stmt->bind_param("ss", $openai_key, $openai_key);
    $stmt->execute();
    
    echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fa-solid fa-check-circle me-2"></i> OpenAI API Key saved successfully!
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>';
}

// ==========================================
// HANDLE SMTP SETTINGS SUBMISSION
// ==========================================
if(isset($_POST['save_smtp'])) {
    $smtp_host = $_POST['smtp_host'] ?? '';
    $smtp_user = $_POST['smtp_user'] ?? '';
    $smtp_pass = $_POST['smtp_pass'] ?? '';
    $smtp_port = $_POST['smtp_port'] ?? '';
    $smtp_from_name = $_POST['smtp_from_name'] ?? '';
    
    $settings = [
        'smtp_host' => $smtp_host,
        'smtp_user' => $smtp_user,
        'smtp_pass' => $smtp_pass,
        'smtp_port' => $smtp_port,
        'smtp_from_name' => $smtp_from_name
    ];
    
    foreach($settings as $key => $value) {
        $stmt = $conn->prepare("INSERT INTO settings (setting_name, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
        $stmt->bind_param("sss", $key, $value, $value);
        $stmt->execute();
    }
    
    echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fa-solid fa-check-circle me-2"></i> SMTP settings saved successfully!
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>';
}

// ==========================================
// HANDLE ADMIN PASSWORD RESET
// ==========================================
if(isset($_POST['reset_admin_password'])) {
    $current_password = $_POST['current_password'] ?? '';
    $new_password = $_POST['new_password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';
    
    $admin_id = $_SESSION['admin_id'];
    
    // Verify current password
    $check = $conn->query("SELECT password FROM admins WHERE id = $admin_id");
    $admin = $check->fetch_assoc();
    
    if($admin['password'] !== $current_password) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fa-solid fa-exclamation-circle me-2"></i> Current password is incorrect!
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
              </div>';
    } elseif($new_password !== $confirm_password) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fa-solid fa-exclamation-circle me-2"></i> New passwords do not match!
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
              </div>';
    } elseif(strlen($new_password) < 6) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fa-solid fa-exclamation-circle me-2"></i> Password must be at least 6 characters!
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
              </div>';
    } else {
        $conn->query("UPDATE admins SET password = '$new_password' WHERE id = $admin_id");
        echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fa-solid fa-check-circle me-2"></i> Password changed successfully!
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
              </div>';
    }
}

// ==========================================
// FETCH CURRENT SETTINGS
// ==========================================
$settings_data = [];
$result = $conn->query("SELECT setting_name, setting_value FROM settings");
while($row = $result->fetch_assoc()) {
    $settings_data[$row['setting_name']] = $row['setting_value'];
}

$openai_key = $settings_data['openai_key'] ?? '';
$smtp_host = $settings_data['smtp_host'] ?? 'smtp.hostinger.com';
$smtp_user = $settings_data['smtp_user'] ?? '';
$smtp_pass = $settings_data['smtp_pass'] ?? '';
$smtp_port = $settings_data['smtp_port'] ?? '465';
$smtp_from_name = $settings_data['smtp_from_name'] ?? 'Admin';
?>

<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
    body, .main-content { font-family: 'Poppins', sans-serif !important; }
    
    .page-header {
        background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
        color: white;
        border-radius: 16px;
        padding: 30px 35px;
        margin-bottom: 30px;
        box-shadow: 0 8px 20px rgba(99, 102, 241, 0.25);
    }
    
    .page-header h2 {
        font-size: 1.8rem;
        font-weight: 600;
        margin: 0;
    }
    
    .page-header .subtitle {
        font-size: 0.9rem;
        opacity: 0.9;
        margin-top: 5px;
    }
    
    .settings-card {
        background: white;
        border-radius: 16px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        overflow: hidden;
        border: 1px solid rgba(0,0,0,0.05);
        margin-bottom: 25px;
    }
    
    .settings-header {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        padding: 20px 30px;
        border-bottom: 2px solid #e2e8f0;
    }
    
    .settings-header h5 {
        margin: 0;
        font-weight: 600;
        font-size: 1.1rem;
        color: #000000;
    }
    
    .settings-body {
        padding: 30px;
    }
    
    .form-label {
        font-weight: 600;
        color: #000000;
        margin-bottom: 8px;
        font-size: 0.9rem;
    }
    
    .form-control {
        border: 2px solid #e2e8f0;
        border-radius: 10px;
        padding: 12px 16px;
        font-size: 0.9rem;
        transition: 0.3s;
        color: #000000;
        font-weight: 500;
    }
    
    .form-control:focus {
        border-color: #6366f1;
        box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
    }
    
    .btn-save {
        background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
        color: white;
        border: none;
        padding: 12px 35px;
        border-radius: 10px;
        font-weight: 600;
        font-size: 0.95rem;
        transition: 0.3s;
        box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
    }
    
    .btn-save:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(99, 102, 241, 0.4);
    }
    
    .btn-save-success {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);
    }
    
    .btn-save-success:hover {
        box-shadow: 0 6px 20px rgba(16, 185, 129, 0.4);
    }
    
    .btn-save-danger {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        box-shadow: 0 4px 12px rgba(239, 68, 68, 0.3);
    }
    
    .btn-save-danger:hover {
        box-shadow: 0 6px 20px rgba(239, 68, 68, 0.4);
    }
    
    .help-text {
        font-size: 0.8rem;
        color: #64748b;
        margin-top: 5px;
    }
    
    /* DARK MODE */
    body.dark-mode .page-header { background: linear-gradient(135deg, #4338ca 0%, #3730a3 100%); }
    body.dark-mode .settings-card { background-color: #1e293b; border-color: #334155; }
    body.dark-mode .settings-header { background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%); border-bottom-color: #334155; }
    body.dark-mode .settings-header h5 { color: #e2e8f0; }
    body.dark-mode .form-label { color: #e2e8f0; }
    body.dark-mode .form-control { 
        background-color: #0f172a; 
        border-color: #334155; 
        color: #e2e8f0; 
    }
    body.dark-mode .form-control:focus { 
        background-color: #0f172a; 
        border-color: #6366f1; 
    }
    body.dark-mode .help-text { color: #94a3b8; }
</style>

<!-- Page Header -->
<div class="page-header">
    <div>
        <h2><i class="fa-solid fa-gear me-2"></i> System Settings</h2>
        <div class="subtitle">Configure OpenAI API keys, email settings, and security options</div>
    </div>
</div>

<!-- FORM 1: OpenAI API Settings -->
<form method="POST">
    <div class="settings-card">
        <div class="settings-header">
            <h5><i class="fa-solid fa-brain me-2 text-primary"></i> OpenAI API Configuration</h5>
        </div>
        <div class="settings-body">
            <div class="mb-3">
                <label class="form-label">OpenAI API Key</label>
                <input type="text" name="openai_key" class="form-control" 
                       value="<?= htmlspecialchars($openai_key); ?>" 
                       placeholder="sk-proj-xxxxxxxxxxxxxxxxxxxxxxxx" required>
                <div class="help-text">
                    <i class="fa-solid fa-info-circle me-1"></i> 
                    Get your API key from <a href="https://platform.openai.com/api-keys" target="_blank">OpenAI Platform</a>
                    - Just Copy And Paste API Key
                </div>
            </div>
            
            <!-- Save Button for OpenAI -->
            <div class="text-end">
                <button type="submit" name="save_openai" class="btn-save">
                    <i class="fa-solid fa-save me-2"></i> Save OpenAI Key
                </button>
            </div>
        </div>
    </div>
</form>

<!-- FORM 2: SMTP Email Settings -->
<form method="POST">
    <div class="settings-card">
        <div class="settings-header">
            <h5><i class="fa-solid fa-envelope me-2 text-success"></i> SMTP Email Configuration</h5>
        </div>
        <div class="settings-body">
            
            <div class="row g-3">
                
                <div class="col-md-6">
                    <label class="form-label">SMTP Host</label>
                    <input type="text" name="smtp_host" class="form-control" 
                           value="<?= htmlspecialchars($smtp_host); ?>" 
                           placeholder="smtp.hostinger.com" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label">SMTP Port</label>
                    <input type="number" name="smtp_port" class="form-control" 
                           value="<?= htmlspecialchars($smtp_port); ?>" 
                           placeholder="465" required>
                    <div class="help-text">Use 465 for SSL or 587 for TLS</div>
                </div>

                <div class="col-md-6">
                    <label class="form-label">SMTP Username (Email)</label>
                    <input type="email" name="smtp_user" class="form-control" 
                           value="<?= htmlspecialchars($smtp_user); ?>" 
                           placeholder="noreply@yourdomain.com" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label">SMTP Password</label>
                    <input type="text" name="smtp_pass" class="form-control" 
                           value="<?= htmlspecialchars($smtp_pass); ?>" 
                           placeholder="Your SMTP Password" required>
                </div>

                <div class="col-md-12">
                    <label class="form-label">From Name</label>
                    <input type="text" name="smtp_from_name" class="form-control" 
                           value="<?= htmlspecialchars($smtp_from_name); ?>" 
                           placeholder="Company Admin" required>
                    <div class="help-text">This name will appear in the "From" field of emails</div>
                </div>

            </div>

            <!-- Save Button for SMTP -->
            <div class="text-end mt-4">
                <button type="submit" name="save_smtp" class="btn-save btn-save-success">
                    <i class="fa-solid fa-save me-2"></i> Save SMTP Settings
                </button>
            </div>

        </div>
    </div>
</form>

<!-- FORM 3: Admin Password Reset (LAST) -->
<form method="POST">
    <div class="settings-card">
        <div class="settings-header">
            <h5><i class="fa-solid fa-shield-halved me-2 text-danger"></i> Change Admin Password</h5>
        </div>
        <div class="settings-body">
            
            <div class="row g-3">
                
                <div class="col-md-12">
                    <label class="form-label">Current Password</label>
                    <input type="password" name="current_password" class="form-control" 
                           placeholder="Enter current password" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label">New Password</label>
                    <input type="password" name="new_password" class="form-control" 
                           placeholder="Enter new password" required minlength="6">
                    <div class="help-text">Minimum 6 characters</div>
                </div>

                <div class="col-md-6">
                    <label class="form-label">Confirm New Password</label>
                    <input type="password" name="confirm_password" class="form-control" 
                           placeholder="Confirm new password" required minlength="6">
                </div>

            </div>

            <!-- Save Button for Password -->
            <div class="text-end mt-4">
                <button type="submit" name="reset_admin_password" class="btn-save btn-save-danger">
                    <i class="fa-solid fa-key me-2"></i> Change Password
                </button>
            </div>

        </div>
    </div>
</form>

<?php include 'footer.php'; ?>
