<?php include 'header.php'; ?>

<?php
// ==========================================
// SEARCH FILTER
// ==========================================
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$search_condition = '';
if($search != '') {
    $search_safe = $conn->real_escape_string($search);
    $search_condition = " WHERE users.name LIKE '%$search_safe%' OR users.email LIKE '%$search_safe%' ";
}

// ==========================================
// FETCH USAGE STATISTICS
// ==========================================

// Total Usage (All Time)
$res_total = $conn->query("SELECT SUM(total_tokens) as total FROM api_usage_logs");
$total_usage = ($res_total) ? $res_total->fetch_assoc()['total'] ?? 0 : 0;

// Today's Usage
$today = date('Y-m-d');
$res_today = $conn->query("SELECT SUM(total_tokens) as total FROM api_usage_logs WHERE DATE(created_at) = '$today'");
$today_usage = ($res_today) ? $res_today->fetch_assoc()['total'] ?? 0 : 0;

// This Month's Usage
$current_month = date('Y-m');
$res_month = $conn->query("SELECT SUM(total_tokens) as total FROM api_usage_logs WHERE DATE_FORMAT(created_at, '%Y-%m') = '$current_month'");
$month_usage = ($res_month) ? $res_month->fetch_assoc()['total'] ?? 0 : 0;

// Employee-wise Total Usage (WITH SEARCH)
$employee_summary = $conn->query("
    SELECT 
        users.id,
        users.name,
        users.email,
        COUNT(api_usage_logs.id) as request_count,
        SUM(api_usage_logs.total_tokens) as total_tokens
    FROM users
    LEFT JOIN api_usage_logs ON users.id = api_usage_logs.user_id
    $search_condition
    GROUP BY users.id
    ORDER BY total_tokens DESC
");

// Detailed Logs (Latest 50)
$logs = $conn->query("
    SELECT 
        api_usage_logs.id,
        users.name,
        users.email,
        api_usage_logs.prompt_tokens,
        api_usage_logs.completion_tokens,
        api_usage_logs.total_tokens,
        api_usage_logs.created_at
    FROM api_usage_logs
    JOIN users ON api_usage_logs.user_id = users.id
    ORDER BY api_usage_logs.id DESC
    LIMIT 50
");
?>

<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
    body, .main-content { font-family: 'Poppins', sans-serif !important; }
    
    .page-header {
        background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
        color: white;
        border-radius: 16px;
        padding: 30px 35px;
        margin-bottom: 30px;
        box-shadow: 0 8px 20px rgba(99, 102, 241, 0.25);
    }
    
    .page-header h2 {
        font-size: 1.8rem;
        font-weight: 600;
        margin: 0;
    }
    
    .page-header .subtitle {
        font-size: 0.9rem;
        opacity: 0.9;
        margin-top: 5px;
    }
    
    .stat-card-mini {
        background: white;
        border-radius: 14px;
        padding: 25px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.06);
        transition: 0.3s;
        border-left: 4px solid #6366f1;
    }
    
    .stat-card-mini:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 20px rgba(0,0,0,0.1);
    }
    
    .stat-card-mini .icon {
        width: 50px;
        height: 50px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
        margin-bottom: 15px;
    }
    
    .stat-card-mini h3 {
        font-size: 2rem;
        font-weight: 700;
        margin: 10px 0 5px 0;
        color: #1e293b;
    }
    
    .stat-card-mini p {
        font-size: 0.85rem;
        color: #64748b;
        margin: 0;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        font-weight: 500;
    }
    
    .report-card {
        background: white;
        border-radius: 16px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        overflow: hidden;
        border: 1px solid rgba(0,0,0,0.05);
    }
    
    .report-header {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        padding: 20px 30px;
        border-bottom: 2px solid #e2e8f0;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .report-header h5 {
        margin: 0;
        font-weight: 600;
        font-size: 1.1rem;
        color: #334155;
    }
    
    .search-box {
        position: relative;
        width: 300px;
    }
    
    .search-box input {
        width: 100%;
        padding: 10px 40px 10px 15px;
        border: 2px solid #e2e8f0;
        border-radius: 10px;
        font-size: 0.9rem;
        transition: 0.3s;
        color: #000000;
        font-weight: 500;
    }
    
    .search-box input:focus {
        border-color: #6366f1;
        outline: none;
        box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
    }
    
    .search-box button {
        position: absolute;
        right: 5px;
        top: 50%;
        transform: translateY(-50%);
        background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
        color: white;
        border: none;
        padding: 8px 15px;
        border-radius: 8px;
        cursor: pointer;
        transition: 0.3s;
    }
    
    .search-box button:hover {
        transform: translateY(-50%) scale(1.05);
    }
    
    .table {
        margin: 0;
        font-size: 0.88rem;
    }
    
    .table thead {
        background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
        color: white;
    }
    
    .table thead th {
        padding: 16px 20px;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.72rem;
        letter-spacing: 1px;
        border: none;
        color: white !important;
    }
    
    .table tbody tr {
        transition: 0.2s;
        border-bottom: 1px solid #f1f5f9;
    }
    
    .table tbody tr:hover {
        background-color: #f8fafc;
    }
    
    .table tbody td {
        padding: 16px 20px;
        vertical-align: middle;
        color: #000000 !important;
        font-weight: 500;
    }
    
    .table tbody td strong {
        color: #000000 !important;
    }
    
    .badge-token {
        background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
        color: white;
        padding: 6px 12px;
        border-radius: 6px;
        font-weight: 600;
        font-size: 0.8rem;
    }
    
    .badge-success {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white;
        padding: 6px 12px;
        border-radius: 6px;
        font-weight: 600;
        font-size: 0.8rem;
    }
    
    .empty-state {
        padding: 60px 20px;
        text-align: center;
        color: #94a3b8;
    }
    
    .empty-state i {
        font-size: 4rem;
        margin-bottom: 20px;
        opacity: 0.3;
    }
    
    /* DARK MODE */
    body.dark-mode .page-header { background: linear-gradient(135deg, #4338ca 0%, #3730a3 100%); }
    body.dark-mode .stat-card-mini { background-color: #1e293b; border-left-color: #6366f1; }
    body.dark-mode .stat-card-mini h3 { color: #e2e8f0; }
    body.dark-mode .stat-card-mini p { color: #94a3b8; }
    body.dark-mode .report-card { background-color: #1e293b; border-color: #334155; }
    body.dark-mode .report-header { background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%); border-bottom-color: #334155; }
    body.dark-mode .report-header h5 { color: #e2e8f0; }
    body.dark-mode .table tbody tr:hover { background-color: #0f172a; }
    body.dark-mode .table tbody td { color: #cbd5e1 !important; border-bottom-color: #334155; }
    body.dark-mode .search-box input { background-color: #0f172a; border-color: #334155; color: #e2e8f0; }
    body.dark-mode .search-box input:focus { border-color: #6366f1; background-color: #0f172a; }
</style>

<!-- Page Header -->
<div class="page-header">
    <div>
        <h2><i class="fa-solid fa-chart-line me-2"></i> API Usage Reports</h2>
        <div class="subtitle">Detailed token consumption analytics and billing overview</div>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row g-4 mb-4">
    <div class="col-lg-4">
        <div class="stat-card-mini">
            <div class="icon bg-primary bg-opacity-10 text-primary">
                <i class="fa-solid fa-infinity"></i>
            </div>
            <h3><?= number_format($total_usage); ?></h3>
            <p>Total Tokens (All Time)</p>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="stat-card-mini" style="border-left-color: #10b981;">
            <div class="icon bg-success bg-opacity-10 text-success">
                <i class="fa-solid fa-calendar-day"></i>
            </div>
            <h3><?= number_format($today_usage); ?></h3>
            <p>Today's Usage</p>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="stat-card-mini" style="border-left-color: #f59e0b;">
            <div class="icon bg-warning bg-opacity-10 text-warning">
                <i class="fa-solid fa-calendar-month"></i>
            </div>
            <h3><?= number_format($month_usage); ?></h3>
            <p>This Month (<?= date('M Y'); ?>)</p>
        </div>
    </div>
</div>

<!-- Employee-wise Summary -->
<?php /* 
<div class="row g-4 mb-4">
    <div class="col-12">
        <div class="report-card">
            <div class="report-header">
                <h5><i class="fa-solid fa-users me-2 text-primary"></i> Employee-wise Token Usage Summary</h5>
                
                <!-- SEARCH BOX -->
                <form method="GET" class="search-box">
                    <input type="text" name="search" placeholder="Search by name or email..." value="<?= htmlspecialchars($search); ?>">
                    <button type="submit"><i class="fa-solid fa-search"></i></button>
                </form>
            </div>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Employee Name</th>
                            <th>Email</th>
                            <th>Total Requests</th>
                            <th>Total Tokens Used</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($employee_summary && $employee_summary->num_rows > 0): ?>
                            <?php $rank = 1; while($emp = $employee_summary->fetch_assoc()): ?>
                                <tr>
                                    <td><strong><?= $rank; ?></strong></td>
                                    <td><strong><?= htmlspecialchars($emp['name']); ?></strong></td>
                                    <td style="color: #000000 !important; font-weight: 500;">
                                        <?= htmlspecialchars($emp['email']); ?>
                                    </td>
                                    <td><span class="badge-success"><?= number_format($emp['request_count'] ?? 0); ?> Requests</span></td>
                                    <td><span class="badge-token"><?= number_format($emp['total_tokens'] ?? 0); ?> Tokens</span></td>
                                </tr>
                            <?php $rank++; endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5">
                                    <div class="empty-state">
                                        <i class="fa-solid fa-users-slash"></i>
                                        <h5 class="fw-bold">No Results Found</h5>
                                        <p><?= $search != '' ? 'No employees match your search.' : 'Add employees to see their usage summary.'; ?></p>
                                        <?php if($search != ''): ?>
                                            <a href="usage_reports.php" class="btn btn-primary btn-sm mt-3">Clear Search</a>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
*/ ?>

<!-- Detailed Logs (Recent Activity) -->
<div class="row g-4">
    <div class="col-12">
        <div class="report-card">
            <div class="report-header">
                <h5><i class="fa-solid fa-list-ul me-2 text-success"></i> Recent Activity (Last 50 API Calls)</h5>
            </div>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Log ID</th>
                            <th>Employee</th>
                            <th>Email</th>
                            <th>Input Tokens</th>
                            <th>Output Tokens</th>
                            <th>Total</th>
                            <th>Date & Time</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($logs && $logs->num_rows > 0): ?>
                            <?php while($log = $logs->fetch_assoc()): ?>
                                <tr>
                                    <td><strong>#<?= $log['id']; ?></strong></td>
                                    <td><strong><?= htmlspecialchars($log['name']); ?></strong></td>
                                    <td style="color: #000000 !important; font-weight: 500;">
                                        <?= htmlspecialchars($log['email']); ?>
                                    </td>
                                    <td><?= number_format($log['prompt_tokens']); ?></td>
                                    <td><?= number_format($log['completion_tokens']); ?></td>
                                    <td><span class="badge-token"><?= number_format($log['total_tokens']); ?></span></td>
                                    <td style="color: #000000 !important;"><?= date('d M Y, h:i A', strtotime($log['created_at'])); ?></td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7">
                                    <div class="empty-state">
                                        <i class="fa-solid fa-chart-line"></i>
                                        <h5 class="fw-bold">No API Usage Yet</h5>
                                        <p>Usage logs will appear here once employees start using ChatGPT.</p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
