<?php 
$page_title = "About Us | OLV Academy";
include __DIR__ . '/header1.php';
?>

<script src="https://cdn.tailwindcss.com"></script>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;800&display=swap" rel="stylesheet">
<script src="https://unpkg.com/lucide@latest"></script>

<style>
    body { font-family: 'Inter', sans-serif; }
    .text-gold { color: #B38B3F; }
    .bg-gold { background-color: #B38B3F; }
    .border-gold { border-color: #B38B3F; }
    .gradient-text {
        background: linear-gradient(to right, #B38B3F, #FF0000);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }
</style>

<body class="bg-white text-gray-900 overflow-x-hidden">

    <!-- HERO SECTION - SCHOOL ABOUT -->
    <section class="relative h-[70vh] flex items-center justify-center text-center px-6 bg-slate-50">
        <div class="absolute inset-0 z-0 opacity-15">
            <img src="https://images.unsplash.com/photo-1523050853063-913894d92f5f?auto=format&fit=crop&q=80" class="w-full h-full object-cover" alt="School Campus">
        </div>
        <div class="relative z-10 max-w-4xl">
            <span class="tracking-widest uppercase text-sm font-bold text-gold mb-4 block">About</span>
            <h1 class="text-4xl md:text-6xl font-extrabold uppercase tracking-tighter mb-6">
                OLV <span class="gradient-text">ACADEMY</span>
            </h1>
            <p class="text-lg md:text-xl text-gray-700 font-light mb-6 max-w-2xl mx-auto">
                A future-ready learning ecosystem nurturing academic excellence, character, and creativity for every child.
            </p>
            <p class="text-gray-600 max-w-2xl mx-auto">
                From foundational schooling to advanced experiential learning, OLV Academy is designed as a 360° growth platform for students.
            </p>
        </div>
    </section>

    <!-- SCHOOL STORY / PURPOSE -->
    <section class="py-20 px-6 max-w-7xl mx-auto">
        <div class="grid md:grid-cols-2 gap-16 items-center">
            <div>
                <h2 class="text-3xl md:text-4xl font-extrabold uppercase mb-6 border-b-4 border-gold inline-block">Our Story</h2>
                <p class="text-lg text-gray-600 mb-4 leading-relaxed">
                    OLV Academy was founded with a simple belief – every child deserves access to world-class education, values, and opportunities, irrespective of background.
                </p>
                <p class="text-lg text-gray-600 mb-4 leading-relaxed">
                    Built on a 50-acre integrated campus, we bring together academics, co-curricular, sports, technology, and life skills under one unified ecosystem.
                </p>
                <p class="text-lg text-gray-600 leading-relaxed italic border-l-4 border-gold pl-5">
                    "We don’t just prepare students for exams, we prepare them for life."
                </p>
            </div>
            <div class="bg-orange-50 p-10 rounded-2xl shadow-sm border border-orange-100">
                <h3 class="text-2xl font-bold uppercase mb-6 tracking-wide">At OLV, students experience</h3>
                <ul class="space-y-4 text-gray-700">
                    <li class="flex items-start gap-3 font-medium">
                        <i data-lucide="star" class="mt-1 text-gold"></i> Concept-based learning with strong foundations in core subjects.
                    </li>
                    <li class="flex items-start gap-3 font-medium">
                        <i data-lucide="activity" class="mt-1 text-gold"></i> Sports, arts, clubs, and leadership programs for holistic growth.
                    </li>
                    <li class="flex items-start gap-3 font-medium">
                        <i data-lucide="cpu" class="mt-1 text-gold"></i> Technology-enabled classrooms and digital learning platforms.
                    </li>
                    <li class="flex items-start gap-3 font-medium">
                        <i data-lucide="users" class="mt-1 text-gold"></i> A safe, inclusive, and value-driven campus culture.
                    </li>
                </ul>
            </div>
        </div>
    </section>

    <!-- PRINCIPAL'S MESSAGE (IMPROVED SECTION) -->
    <section class="py-20 bg-gray-50 px-6">
        <div class="max-w-6xl mx-auto mb-10 text-center">
            <span class="text-xs font-semibold tracking-[0.3em] uppercase text-gold">School Leadership</span>
            <h2 class="text-3xl md:text-4xl font-extrabold mt-3 mb-3 uppercase">Message from the <span class="text-gold">Principal</span></h2>
            <p class="text-gray-500 max-w-3xl mx-auto text-sm md:text-base">
                The Principal’s Office at OLV Academy ensures that learning is balanced with discipline, values and a caring environment for every child.
            </p>
        </div>

        <div class="max-w-6xl mx-auto grid md:grid-cols-3 gap-12 items-center">
            <div class="md:col-span-1 flex justify-center">
                <div class="relative">
                    <img src="https://images.unsplash.com/photo-1544723795-3fb6469f5b39?auto=format&fit=crop&w=600&q=80" 
                         alt="Principal" 
                         class="w-64 h-64 object-cover rounded-3xl shadow-xl border-[6px] border-white">
                    <div class="absolute -bottom-4 -right-4 bg-gold text-white text-[10px] font-bold px-4 py-2 rounded-full uppercase tracking-[0.2em] shadow-lg">
                        Principal
                    </div>
                </div>
            </div>
            <div class="md:col-span-2">
                <div class="bg-white shadow-sm border border-gray-100 rounded-2xl p-6 md:p-8 relative">
                    <div class="absolute -top-4 left-6 text-4xl text-gold opacity-30 select-none">“</div>
                    <p class="text-gray-700 mb-4 leading-relaxed text-sm md:text-base">
                        At OLV Academy, we believe that every child carries limitless potential. 
                        Our goal is to create a school where students feel safe to ask questions, try new things and learn from mistakes.
                    </p>
                    <p class="text-gray-700 mb-4 leading-relaxed text-sm md:text-base">
                        Along with strong academics, we emphasize discipline, values, communication, and life skills so that our students grow 
                        into responsible and confident individuals ready to face the real world.
                    </p>
                    <p class="text-gray-700 mb-2 leading-relaxed text-sm md:text-base">
                        We work closely with parents as partners in this journey, because we truly believe that 
                        school and home together can create the best environment for a child’s growth.
                    </p>
                    <div class="mt-4">
                        <div class="font-semibold text-sm md:text-base text-gray-900">Dr. A. Sharma</div>
                        <div class="text-[12px] text-gray-500 uppercase tracking-[0.2em]">Principal, OLV Academy</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- MEET OUR TEACHERS -->
    <section class="py-20 px-6">
        <div class="max-w-7xl mx-auto">
            <div class="text-center mb-12">
                <h2 class="text-3xl md:text-4xl font-extrabold uppercase mb-3">Meet Our <span class="text-gold">Teachers</span></h2>
                <p class="text-gray-500 max-w-2xl mx-auto">
                    A passionate team of qualified educators, committed to guiding every learner with patience, expertise, and care.
                </p>
            </div>

            <div class="grid sm:grid-cols-2 lg:grid-cols-4 gap-8">
                <?php
                $teachers = [
                    [
                        'name' => 'Mrs. Neha Verma',
                        'role' => 'Senior Math Teacher',
                        'img'  => 'https://images.unsplash.com/photo-1544723795-3fb0b90cff2f?auto=format&fit=crop&w=600&q=80'
                    ],
                    [
                        'name' => 'Mr. Rahul Iyer',
                        'role' => 'Science & Robotics',
                        'img'  => 'https://images.unsplash.com/photo-1544723795-3fb0b90c07f1?auto=format&fit=crop&w=600&q=80'
                    ],
                    [
                        'name' => 'Ms. Aarti Kulkarni',
                        'role' => 'English & Communication',
                        'img'  => 'https://images.unsplash.com/photo-1544005313-94ddf0286df2?auto=format&fit=crop&w=600&q=80'
                    ],
                    [
                        'name' => 'Mr. Sandeep Rao',
                        'role' => 'Sports & Fitness',
                        'img'  => 'https://images.unsplash.com/photo-1524504388940-b1c1722653e1?auto=format&fit=crop&w=600&q=80'
                    ],
                ];
                foreach ($teachers as $t): ?>
                    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden group hover:-translate-y-2 hover:shadow-lg transition-all">
                        <div class="h-52 overflow-hidden">
                            <img src="<?= $t['img'] ?>" alt="<?= $t['name'] ?>" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                        </div>
                        <div class="p-5 text-center">
                            <h4 class="font-bold text-lg mb-1"><?= $t['name'] ?></h4>
                            <p class="text-gold text-sm font-semibold mb-2 uppercase tracking-wide"><?= $t['role'] ?></p>
                            <p class="text-xs text-gray-500">
                                Building confidence in students through engaging lessons, personal attention, and real-world learning.
                            </p>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- CAMPUS HIGHLIGHTS (EXTRA SECTION) -->
    <section class="py-20 bg-gray-50 px-6">
        <div class="max-w-7xl mx-auto">
            <div class="text-center mb-12">
                <h2 class="text-3xl md:text-4xl font-extrabold uppercase mb-3">Campus <span class="text-gold">Highlights</span></h2>
            <p class="text-gray-500 max-w-2xl mx-auto">
                A safe, vibrant, and well-equipped campus designed to support every dimension of student growth.
            </p>
            </div>
            <div class="grid md:grid-cols-3 gap-8">
                <div class="bg-white p-7 rounded-2xl shadow-sm border border-gray-100">
                    <h4 class="font-bold mb-2 flex items-center gap-2">
                        <i data-lucide="library" class="text-gold"></i> Digital Library
                    </h4>
                    <p class="text-sm text-gray-600">
                        Thousands of books, e-resources, and reference materials to nurture a strong reading culture.
                    </p>
                </div>
                <div class="bg-white p-7 rounded-2xl shadow-sm border border-gray-100">
                    <h4 class="font-bold mb-2 flex items-center gap-2">
                        <i data-lucide="microscope" class="text-gold"></i> Science & Innovation Labs
                    </h4>
                    <p class="text-sm text-gray-600">
                        Fully equipped labs for Physics, Chemistry, Biology, and Robotics to encourage experimentation.
                    </p>
                </div>
                <div class="bg-white p-7 rounded-2xl shadow-sm border border-gray-100">
                    <h4 class="font-bold mb-2 flex items-center gap-2">
                        <i data-lucide="dribbble" class="text-gold"></i> Sports & Activity Arena
                    </h4>
                    <p class="text-sm text-gray-600">
                        Grounds and courts for multiple sports, along with structured fitness and wellness programs.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- CONTACT & LOCATION (AS PER SCHOOL) -->
    <section class="py-20 px-6 bg-gray-900 text-white">
        <div class="max-w-7xl mx-auto grid md:grid-cols-2 gap-16 items-start">
            <div>
                <h2 class="text-3xl md:text-4xl font-extrabold uppercase mb-4">Contact & Location</h2>
                <p class="text-gray-300 mb-6">
                    For admissions, school visits, or any queries, we welcome parents and guardians to connect with us.
                </p>
                <div class="space-y-4 text-gray-200 text-sm">
                    <p class="flex gap-3">
                        <span class="mt-1 text-gold"><i data-lucide="map-pin"></i></span>
                        <span>OLV Academy, 50-Acre Campus, Survey No. 123,<br>Hyderabad, Telangana - 500XXX</span>
                    </p>
                    <p class="flex gap-3">
                        <span class="mt-1 text-gold"><i data-lucide="phone"></i></span>
                        <span>School Office: +91 40 1234 5678<br>Admissions: +91 98480 12345</span>
                    </p>
                    <p class="flex gap-3">
                        <span class="mt-1 text-gold"><i data-lucide="mail"></i></span>
                        <span>info@olvacademy.edu.in<br>admissions@olvacademy.edu.in</span>
                    </p>
                    <p class="flex gap-3">
                        <span class="mt-1 text-gold"><i data-lucide="clock"></i></span>
                        <span>School Hours: Mon – Sat, 8:00 AM to 3:30 PM</span>
                    </p>
                </div>
            </div>
            <div class="bg-white/5 rounded-2xl border border-white/10 p-6 backdrop-blur">
                <h3 class="text-xl font-bold mb-4">Quick Contact Form</h3>
                <form action="#" method="post" class="space-y-4">
                    <div>
                        <label class="text-sm text-gray-300 block mb-1">Parent / Guardian Name</label>
                        <input type="text" class="w-full px-3 py-2 rounded-md bg-black/40 border border-white/10 text-sm focus:outline-none focus:border-gold">
                    </div>
                    <div class="grid sm:grid-cols-2 gap-4">
                        <div>
                            <label class="text-sm text-gray-300 block mb-1">Email</label>
                            <input type="email" class="w-full px-3 py-2 rounded-md bg-black/40 border border-white/10 text-sm focus:outline-none focus:border-gold">
                        </div>
                        <div>
                            <label class="text-sm text-gray-300 block mb-1">Phone</label>
                            <input type="tel" class="w-full px-3 py-2 rounded-md bg-black/40 border border-white/10 text-sm focus:outline-none focus:border-gold">
                        </div>
                    </div>
                    <div>
                        <label class="text-sm text-gray-300 block mb-1">Child's Class / Grade</label>
                        <input type="text" class="w-full px-3 py-2 rounded-md bg-black/40 border border-white/10 text-sm focus:outline-none focus:border-gold">
                    </div>
                    <div>
                        <label class="text-sm text-gray-300 block mb-1">Message</label>
                        <textarea rows="3" class="w-full px-3 py-2 rounded-md bg-black/40 border border-white/10 text-sm focus:outline-none focus:border-gold"></textarea>
                    </div>
                    <button type="submit" class="mt-2 inline-flex items-center justify-center px-6 py-3 rounded-lg bg-gold text-black font-semibold text-sm uppercase tracking-wide hover:opacity-90 transition">
                        Submit Enquiry
                    </button>
                </form>
            </div>
        </div>
    </section>

    <script>
        lucide.createIcons();
    </script>

<?php include __DIR__ . '/footer1.php'; ?>
</body>
</html>
 