<?php
$page_title = "Gallery - OLV Academy";
if(file_exists(__DIR__ . '/header.php')) include(__DIR__ . '/header.php');

$host     = 'localhost';
$username = 'sai7755_college';
$password = 'Admin_66666';
$database = 'sai7755_college';

$conn = mysqli_connect($host, $username, $password, $database);
if (!$conn) die('DB Connection Failed');
mysqli_set_charset($conn, 'utf8mb4');

$school_id   = (int)($_GET['school_id'] ?? 1);
$active_tab  = in_array($_GET['tab'] ?? '', ['image','video']) ? $_GET['tab'] : 'all';

// Build query
$where_type = '';
if ($active_tab === 'image') $where_type = "AND media_type='image'";
if ($active_tab === 'video') $where_type = "AND media_type='video'";

$gallery_sql = "SELECT * FROM mum_gallery 
                WHERE (school_id=? OR school_id IS NULL) 
                AND status='active' 
                AND (file_path!='' OR thumbnail!='' OR video_url!='')
                $where_type
                ORDER BY featured DESC, created_at DESC 
                LIMIT 48";

$stmt = $conn->prepare($gallery_sql);
$stmt->bind_param("i", $school_id);
$stmt->execute();
$gallery_result = $stmt->get_result();

// Count for each tab
$count_all   = mysqli_fetch_assoc($conn->query("SELECT COUNT(*) c FROM mum_gallery WHERE school_id=$school_id AND status='active'"))['c'];
$count_image = mysqli_fetch_assoc($conn->query("SELECT COUNT(*) c FROM mum_gallery WHERE school_id=$school_id AND status='active' AND media_type='image'"))['c'];
$count_video = mysqli_fetch_assoc($conn->query("SELECT COUNT(*) c FROM mum_gallery WHERE school_id=$school_id AND status='active' AND media_type='video'"))['c'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= $page_title ?></title>
<link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700;900&family=Outfit:wght@300;400;500;600&display=swap" rel="stylesheet">

<style>
:root {
    --ink:    #0d0d0d;
    --cream:  #faf8f3;
    --gold:   #c9922a;
    --gold2:  #e8b84b;
    --slate:  #3d4a5c;
    --muted:  #8a8f99;
    --white:  #ffffff;
    --radius: 20px;
}

*, *::before, *::after { margin:0; padding:0; box-sizing:border-box; }

html { scroll-behavior:smooth; }

body { font-family:'Outfit',sans-serif; background:var(--cream); color:var(--ink); overflow-x:hidden; }

/* ─── HERO ─── */
.gallery-hero {
    position:relative; height:92vh; min-height:620px;
    display:flex; align-items:center; justify-content:center; text-align:center; overflow:hidden;
}
.hero-bg {
    position:absolute; inset:0; z-index:0;
    background: linear-gradient(160deg, #0d0d0d 0%, #1a1a2e 50%, #2c1654 100%);
}
.hero-bg::after {
    content:'';
    position:absolute; inset:0;
    background: radial-gradient(ellipse 80% 60% at 50% 0%, rgba(201,146,42,0.18) 0%, transparent 70%);
}

/* Animated dots */
.dots-bg {
    position:absolute; inset:0; overflow:hidden; z-index:1;
}
.dots-bg::before {
    content:'';
    position:absolute; width:600px; height:600px; border-radius:50%;
    background: radial-gradient(circle, rgba(201,146,42,0.06) 0%, transparent 70%);
    top:-150px; right:-100px; animation:pulse 6s ease-in-out infinite;
}
.dots-bg::after {
    content:'';
    position:absolute; width:400px; height:400px; border-radius:50%;
    background: radial-gradient(circle, rgba(100,80,200,0.08) 0%, transparent 70%);
    bottom:-100px; left:-80px; animation:pulse 8s ease-in-out infinite 3s;
}
@keyframes pulse {
    0%,100%{transform:scale(1); opacity:1;}
    50%{transform:scale(1.15); opacity:0.7;}
}

.hero-content {
    position:relative; z-index:2; max-width:900px; padding:0 24px;
    animation:heroReveal 1.2s cubic-bezier(0.22,1,0.36,1) both;
}
@keyframes heroReveal {
    from{opacity:0; transform:translateY(48px);}
    to{opacity:1; transform:translateY(0);}
}

.hero-eyebrow {
    display:inline-flex; align-items:center; gap:10px;
    color:var(--gold2); font-size:0.78rem; font-weight:600;
    letter-spacing:4px; text-transform:uppercase; margin-bottom:28px;
}
.hero-eyebrow::before, .hero-eyebrow::after { content:''; width:30px; height:1px; background:var(--gold2); opacity:0.6; }

.hero-title {
    font-family:'Playfair Display',serif;
    font-size:clamp(3.2rem, 9vw, 7rem); font-weight:900; line-height:1;
    color:var(--white); letter-spacing:-2px; margin-bottom:24px;
}
.hero-title em { font-style:normal; color:var(--gold); }

.hero-sub {
    font-size:clamp(1rem, 2.2vw, 1.3rem); color:rgba(255,255,255,0.65); font-weight:300;
    max-width:680px; margin:0 auto 44px; line-height:1.7;
}

.hero-stat-row {
    display:flex; justify-content:center; gap:40px; flex-wrap:wrap;
}
.hero-stat { text-align:center; }
.hero-stat-num { font-family:'Playfair Display',serif; font-size:2.2rem; font-weight:700; color:var(--gold); display:block; }
.hero-stat-lbl { font-size:0.78rem; color:rgba(255,255,255,0.5); letter-spacing:2px; text-transform:uppercase; }

.hero-scroll {
    position:absolute; bottom:36px; left:50%; transform:translateX(-50%);
    z-index:2; display:flex; flex-direction:column; align-items:center; gap:8px;
    color:rgba(255,255,255,0.4); font-size:0.75rem; letter-spacing:2px; text-transform:uppercase;
}
.scroll-line { width:1px; height:40px; background:linear-gradient(to bottom, rgba(255,255,255,0.3), transparent); animation:scrollDrop 2s ease-in-out infinite; }
@keyframes scrollDrop { 0%{opacity:0; transform:scaleY(0); transform-origin:top;} 50%{opacity:1; transform:scaleY(1);} 100%{opacity:0; transform:scaleY(0); transform-origin:bottom;} }

/* ─── MAIN SECTION ─── */
.gallery-section { padding:100px 0 140px; }
.container { max-width:1360px; margin:0 auto; padding:0 24px; }

/* ─── TABS ─── */
.tabs-header {
    display:flex; justify-content:space-between; align-items:center;
    margin-bottom:56px; flex-wrap:wrap; gap:24px;
}
.tabs-title h2 {
    font-family:'Playfair Display',serif;
    font-size:clamp(2rem, 5vw, 3rem); font-weight:900; color:var(--ink);
    line-height:1.1;
}
.tabs-title h2 em { font-style:normal; color:var(--gold); }
.tabs-title p { color:var(--muted); font-size:0.95rem; margin-top:8px; }

.tabs-nav {
    display:flex; background:var(--white); border-radius:14px;
    padding:5px; gap:4px; box-shadow:0 2px 12px rgba(0,0,0,0.06);
}
.tab-link {
    display:inline-flex; align-items:center; gap:7px;
    padding:10px 24px; border-radius:10px; font-weight:600; font-size:0.88rem;
    color:var(--muted); text-decoration:none; transition:all 0.25s; white-space:nowrap;
}
.tab-link .tab-count {
    background:#f1f5f9; color:var(--muted); padding:2px 8px;
    border-radius:20px; font-size:0.75rem; font-weight:700;
}
.tab-link.active {
    background:linear-gradient(135deg, var(--ink), var(--slate));
    color:var(--white);
}
.tab-link.active .tab-count { background:rgba(255,255,255,0.2); color:var(--white); }
.tab-link:hover:not(.active) { color:var(--ink); background:#f8fafc; }

/* ─── GRID ─── */
.gallery-grid {
    display:grid;
    grid-template-columns:repeat(3, 1fr);
    gap:28px;
}

.g-card {
    border-radius:var(--radius); overflow:hidden; background:var(--white);
    box-shadow:0 4px 24px rgba(0,0,0,0.06); cursor:pointer;
    transition:transform 0.4s cubic-bezier(0.22,1,0.36,1), box-shadow 0.4s;
    position:relative;
    animation:cardIn 0.6s cubic-bezier(0.22,1,0.36,1) both;
}
@keyframes cardIn {
    from{opacity:0; transform:translateY(30px);}
    to{opacity:1; transform:translateY(0);}
}
.g-card:nth-child(1){animation-delay:0.05s;}
.g-card:nth-child(2){animation-delay:0.10s;}
.g-card:nth-child(3){animation-delay:0.15s;}
.g-card:nth-child(4){animation-delay:0.20s;}
.g-card:nth-child(5){animation-delay:0.25s;}
.g-card:nth-child(6){animation-delay:0.30s;}

.g-card:hover { transform:translateY(-10px); box-shadow:0 24px 60px rgba(0,0,0,0.12); }

/* Large card spans 2 columns */
.g-card.large { grid-column:span 2; }

.g-thumb {
    position:relative; overflow:hidden;
    background:linear-gradient(135deg, #1a1a2e, #2d2d4a);
}
.g-card:not(.large) .g-thumb { height:240px; }
.g-card.large .g-thumb { height:360px; }

.g-thumb img {
    width:100%; height:100%; object-fit:cover;
    transition:transform 0.7s cubic-bezier(0.22,1,0.36,1);
    display:block;
}
.g-card:hover .g-thumb img { transform:scale(1.08); }

.g-overlay {
    position:absolute; inset:0;
    background:linear-gradient(to top, rgba(13,13,13,0.65) 0%, rgba(0,0,0,0) 55%);
    opacity:0; transition:opacity 0.4s;
}
.g-card:hover .g-overlay { opacity:1; }

.g-play {
    position:absolute; inset:0; display:flex; align-items:center; justify-content:center;
}
.play-ring {
    width:64px; height:64px; border-radius:50%;
    background:rgba(255,255,255,0.92); backdrop-filter:blur(10px);
    display:flex; align-items:center; justify-content:center;
    font-size:1.5rem; box-shadow:0 12px 36px rgba(0,0,0,0.25);
    transform:scale(0.9); transition:transform 0.3s;
}
.g-card:hover .play-ring { transform:scale(1); }

.g-badge {
    position:absolute; top:16px; left:16px;
    padding:5px 14px; border-radius:30px; font-size:0.72rem; font-weight:700;
    text-transform:uppercase; letter-spacing:1px;
}
.g-badge.image { background:rgba(59,130,246,0.9); color:#fff; }
.g-badge.video { background:rgba(233,69,96,0.9);  color:#fff; }

.g-feat {
    position:absolute; top:16px; right:16px;
    width:34px; height:34px; border-radius:50%;
    background:rgba(201,146,42,0.9); backdrop-filter:blur(8px);
    display:flex; align-items:center; justify-content:center; font-size:0.9rem;
}

.g-body { padding:22px 24px 24px; }
.g-cat {
    display:inline-block; font-size:0.72rem; font-weight:700;
    letter-spacing:1.5px; text-transform:uppercase; color:var(--gold);
    margin-bottom:10px;
}
.g-title {
    font-family:'Playfair Display',serif; font-size:1.2rem; font-weight:700;
    color:var(--ink); line-height:1.3; margin-bottom:10px;
}
.g-card.large .g-title { font-size:1.5rem; }

.g-desc { font-size:0.88rem; color:var(--muted); line-height:1.6; margin-bottom:14px; display:-webkit-box; -webkit-line-clamp:2; -webkit-box-orient:vertical; overflow:hidden; }

.g-footer {
    display:flex; justify-content:space-between; align-items:center;
    padding-top:14px; border-top:1px solid #f1f5f9;
}
.g-date { font-size:0.78rem; color:var(--muted); }
.g-tags { display:flex; gap:6px; flex-wrap:wrap; }
.g-tag { background:#f1f5f9; color:var(--slate); padding:3px 9px; border-radius:10px; font-size:0.7rem; font-weight:600; }

/* ─── EMPTY ─── */
.empty-gallery { text-align:center; padding:120px 40px; }
.empty-icon { font-size:5rem; margin-bottom:20px; opacity:0.3; }
.empty-gallery h3 { font-family:'Playfair Display',serif; font-size:1.8rem; color:var(--ink); margin-bottom:10px; }
.empty-gallery p  { color:var(--muted); font-size:1rem; }

/* ─── LIGHTBOX ─── */
.lb-overlay {
    position:fixed; inset:0; z-index:99999;
    background:rgba(0,0,0,0.96); backdrop-filter:blur(20px);
    display:none; align-items:center; justify-content:center;
}
.lb-overlay.open { display:flex; }
.lb-box { position:relative; max-width:92vw; max-height:92vh; }
.lb-box img { max-width:88vw; max-height:88vh; border-radius:14px; display:block; }
.lb-box iframe, .lb-box video { border-radius:14px; display:block; }
.lb-close {
    position:absolute; top:-48px; right:0;
    width:40px; height:40px; border-radius:50%; border:none;
    background:rgba(255,255,255,0.15); color:#fff; font-size:1.2rem;
    cursor:pointer; display:flex; align-items:center; justify-content:center;
    transition:background 0.2s;
}
.lb-close:hover { background:rgba(255,255,255,0.3); }
.lb-caption { position:absolute; bottom:-44px; left:0; right:0; text-align:center; color:rgba(255,255,255,0.6); font-size:0.88rem; }

/* ─── RESPONSIVE ─── */
@media(max-width:1100px) { .gallery-grid { grid-template-columns:repeat(2,1fr); } .g-card.large { grid-column:span 2; } }
@media(max-width:700px)  { .gallery-grid { grid-template-columns:1fr; } .g-card.large { grid-column:span 1; } .tabs-nav { flex-wrap:wrap; } }
</style>

<!-- HERO -->
<section class="gallery-hero">
    <div class="hero-bg"></div>
    <div class="dots-bg"></div>
    <div class="hero-content">
        <div class="hero-eyebrow">Campus Life Captured</div>
        <h1 class="hero-title">Academy<br><em>Gallery</em></h1>
        <p class="hero-sub">Every milestone, every memory, every moment of excellence — preserved in our growing collection of images and videos.</p>
        <div class="hero-stat-row">
            <div class="hero-stat"><span class="hero-stat-num"><?= $count_image ?></span><span class="hero-stat-lbl">Photos</span></div>
            <div class="hero-stat"><span class="hero-stat-num"><?= $count_video ?></span><span class="hero-stat-lbl">Videos</span></div>
            <div class="hero-stat"><span class="hero-stat-num"><?= $count_all ?></span><span class="hero-stat-lbl">Total</span></div>
        </div>
    </div>
    <div class="hero-scroll"><span class="scroll-line"></span>Scroll</div>
</section>

<!-- GALLERY -->
<section class="gallery-section" id="gallery">
    <div class="container">
        
        <!-- Tabs Header -->
        <div class="tabs-header">
            <div class="tabs-title">
                <h2>Our <em>Memories</em></h2>
                <p>Browse photos and videos from our campus</p>
            </div>
            <nav class="tabs-nav">
                <a href="?tab=all<?= $school_id!=1?'&school_id='.$school_id:'' ?>"   class="tab-link <?= $active_tab=='all'  ?'active':'' ?>">
                    All <span class="tab-count"><?= $count_all ?></span>
                </a>
                <a href="?tab=image<?= $school_id!=1?'&school_id='.$school_id:'' ?>" class="tab-link <?= $active_tab=='image'?'active':'' ?>">
                    📷 Images <span class="tab-count"><?= $count_image ?></span>
                </a>
                <a href="?tab=video<?= $school_id!=1?'&school_id='.$school_id:'' ?>" class="tab-link <?= $active_tab=='video'?'active':'' ?>">
                    🎥 Videos <span class="tab-count"><?= $count_video ?></span>
                </a>
            </nav>
        </div>

        <!-- Grid -->
        <?php if ($gallery_result->num_rows > 0): ?>
        <div class="gallery-grid">
            <?php 
            $idx = 0;
            while ($row = $gallery_result->fetch_assoc()):
                // Every 7th card (index 0,6,13...) is large
                $is_large = ($idx % 7 === 0 || $idx % 7 === 6);
                $idx++;

                $file = htmlspecialchars($row['file_path'] ?? '');
                $thumb = !empty($row['thumbnail']) ? htmlspecialchars($row['thumbnail']) : $file;
                $modal_src = !empty($row['video_url']) && $row['media_type']==='video' 
                             ? htmlspecialchars($row['video_url']) : $file;
                $is_video = $row['media_type'] === 'video';
                $preview = $is_video && !empty($row['thumbnail']) ? htmlspecialchars($row['thumbnail']) : $file;
            ?>
            <div class="g-card <?= $is_large?'large':'' ?>" onclick="openLB(<?= json_encode($modal_src) ?>, '<?= $row['media_type'] ?>', <?= json_encode($row['title']) ?>)">
                <div class="g-thumb">
                    <?php if (!empty($preview)): ?>
                        <img src="<?= $preview ?>" alt="<?= htmlspecialchars($row['title']) ?>" loading="lazy"
                             onerror="this.parentElement.innerHTML='<div style=\'width:100%;height:100%;display:flex;align-items:center;justify-content:center;font-size:3rem;color:rgba(255,255,255,0.3)\'>📷</div>'">
                    <?php else: ?>
                        <div style="width:100%;height:100%;display:flex;align-items:center;justify-content:center;font-size:3rem;color:rgba(255,255,255,0.3);">
                            <?= $is_video ? '🎥' : '📷' ?>
                        </div>
                    <?php endif; ?>
                    <div class="g-overlay"></div>
                    <?php if ($is_video): ?>
                    <div class="g-play"><div class="play-ring">▶</div></div>
                    <?php endif; ?>
                    <span class="g-badge <?= $row['media_type'] ?>"><?= $row['media_type'] ?></span>
                    <?php if ($row['featured']): ?><span class="g-feat">⭐</span><?php endif; ?>
                </div>
                <div class="g-body">
                    <?php if ($row['category']): ?><span class="g-cat"><?= htmlspecialchars($row['category']) ?></span><?php endif; ?>
                    <h3 class="g-title"><?= htmlspecialchars($row['title']) ?></h3>
                    <?php if ($row['description']): ?><p class="g-desc"><?= htmlspecialchars($row['description']) ?></p><?php endif; ?>
                    <div class="g-footer">
                        <span class="g-date">📅 <?= date('M Y', strtotime($row['created_at'])) ?></span>
                        <?php if ($row['tags']): ?>
                        <div class="g-tags">
                            <?php foreach(array_slice(explode(',', $row['tags']),0,2) as $t): if(trim($t)): ?>
                                <span class="g-tag">#<?= htmlspecialchars(trim($t)) ?></span>
                            <?php endif; endforeach; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        </div>

        <?php else: ?>
        <div class="empty-gallery">
            <div class="empty-icon">📸</div>
            <h3>No media yet</h3>
            <p>
                <?= $active_tab==='image' ? 'No images' : ($active_tab==='video' ? 'No videos' : 'No media') ?> 
                available. Check back soon!
            </p>
        </div>
        <?php endif; ?>

    </div>
</section>

<!-- LIGHTBOX -->
<div class="lb-overlay" id="lb" onclick="closeLB()">
    <div class="lb-box" onclick="event.stopPropagation()">
        <button class="lb-close" onclick="closeLB()">✕</button>
        <div id="lb-inner"></div>
        <div class="lb-caption" id="lb-caption"></div>
    </div>
</div>

<script>
function openLB(src, type, title) {
    var inner   = document.getElementById('lb-inner');
    var caption = document.getElementById('lb-caption');
    inner.innerHTML = '';

    if (type === 'image') {
        inner.innerHTML = '<img src="'+src+'" alt="'+title+'">';
    } else {
        if (src.includes('youtube.com') || src.includes('youtu.be')) {
            var vid = src.includes('v=') ? src.split('v=')[1].split('&')[0] : src.split('/').pop();
            inner.innerHTML = '<iframe width="900" height="506" src="https://www.youtube.com/embed/'+vid+'?autoplay=1" frameborder="0" allow="autoplay; fullscreen" allowfullscreen></iframe>';
        } else if (src.includes('vimeo.com')) {
            var vid = src.split('/').pop();
            inner.innerHTML = '<iframe width="900" height="506" src="https://player.vimeo.com/video/'+vid+'?autoplay=1" frameborder="0" allow="autoplay; fullscreen" allowfullscreen></iframe>';
        } else {
            inner.innerHTML = '<video controls autoplay style="max-width:88vw;max-height:82vh;"><source src="'+src+'">Your browser does not support video.</video>';
        }
    }

    caption.textContent = title || '';
    document.getElementById('lb').classList.add('open');
    document.body.style.overflow = 'hidden';
}

function closeLB() {
    document.getElementById('lb').classList.remove('open');
    document.getElementById('lb-inner').innerHTML = '';
    document.body.style.overflow = '';
}

document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') closeLB();
});
</script>

<?php
$stmt->close();
$conn->close();
if(file_exists(__DIR__ . '/footer.php')) include(__DIR__ . '/footer.php');
?>