<?php
/**
 * Mumbai University Dashboard
 * Location: /college/mum_unu/dashboard_mum_unu.php
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Database connection (parent folder)
require_once '../db.php';

// Page title
$page_title = "Dashboard - Mumbai University";

// Authentication check
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

$admin_name = isset($_SESSION['username']) ? $_SESSION['username'] : 'Admin';

// ==================== DATA FETCHING ====================
$school_id = 3; // Mumbai University ID

$stats = [
    'total_students' => 0,
    'total_content' => 0,
    'total_gallery' => 0,
    'total_contacts' => 0,
    'total_sliders' => 0
];

// Safe count function with table check
function safeCount($db, $table, $school_id = null) {
    // Check if table exists
    $check = @mysqli_query($db, "SHOW TABLES LIKE '$table'");
    if (!$check || mysqli_num_rows($check) == 0) {
        return 0;
    }
    
    // Build query
    $query = "SELECT COUNT(*) as count FROM $table";
    if ($school_id !== null) {
        $query .= " WHERE school_id = $school_id";
    }
    
    $result = @mysqli_query($db, $query);
    if ($result) {
        $row = mysqli_fetch_assoc($result);
        return $row ? $row['count'] : 0;
    }
    return 0;
}

try {
    $stats['total_students'] = safeCount($db, 'students', $school_id);
    $stats['total_content'] = safeCount($db, 'content_pages', $school_id);
    $stats['total_gallery'] = safeCount($db, 'gallery_images', $school_id);
    $stats['total_contacts'] = safeCount($db, 'contact_submissions', $school_id);
    $stats['total_sliders'] = safeCount($db, 'sliders', $school_id);
} catch (Exception $e) {
    error_log("Dashboard Error: " . $e->getMessage());
}

// Include header from parent folder
require_once '../header.php';
?>

<style>
    body {
        background: #f4f6f9;
        margin: 0;
        padding: 0;
    }

    /* ========== SIDEBAR ========== */
    .sidebar {
        width: 260px;
        background: #2c3e50;
        color: white;
        position: fixed;
        height: 100vh;
        overflow-y: auto;
        top: 0;
        left: 0;
        z-index: 1000;
    }

    .sidebar-header {
        padding: 25px 20px;
        background: #1a252f;
        text-align: center;
    }

    .sidebar-header h2 {
        font-size: 18px;
        font-weight: 700;
        margin: 0;
    }

    .sidebar-menu {
        padding: 20px 0;
    }

    .menu-item {
        display: block;
        padding: 14px 20px;
        color: #ecf0f1;
        text-decoration: none;
        transition: all 0.3s;
        border-left: 4px solid transparent;
    }

    .menu-item:hover,
    .menu-item.active {
        background: #34495e;
        border-left-color: #3498db;
        padding-left: 24px;
    }

    /* ========== MAIN CONTENT AREA ========== */
    .main-content-area {
        margin-left: 260px;
        width: calc(100% - 260px);
        min-height: 100vh;
        padding-top: 120px;
    }

    .dashboard-container {
        max-width: 1400px;
        margin: 0 auto;
        padding: 20px 30px 30px 30px;
    }

    .page-header {
        margin-bottom: 30px;
        margin-top: 0;
        padding-top: 0;
    }

    .page-header h2 {
        font-size: 28px;
        color: #333;
        margin: 0 0 8px 0;
        font-weight: 700;
    }

    .page-header p {
        color: #666;
        font-size: 15px;
        margin: 0;
    }

    /* Stats Grid */
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
        gap: 20px;
        margin-bottom: 30px;
    }

    .stat-card {
        background: white;
        padding: 24px;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        display: flex;
        align-items: center;
        gap: 16px;
        transition: all 0.3s ease;
        border: 1px solid #e1e4e8;
    }

    .stat-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 4px 16px rgba(0,0,0,0.12);
    }

    .stat-icon {
        width: 56px;
        height: 56px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        flex-shrink: 0;
    }

    .stat-icon.blue { background: #e3f2fd; color: #2196f3; }
    .stat-icon.green { background: #e8f5e9; color: #4caf50; }
    .stat-icon.orange { background: #fff3e0; color: #ff9800; }
    .stat-icon.purple { background: #f3e5f5; color: #9c27b0; }
    .stat-icon.teal { background: #e0f2f1; color: #009688; }

    .stat-info h3 {
        font-size: 32px;
        color: #333;
        font-weight: 700;
        margin: 0 0 4px 0;
    }

    .stat-info p {
        color: #666;
        font-size: 14px;
        margin: 0;
    }

    /* Actions Section */
    .actions-section {
        background: white;
        padding: 25px;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        border: 1px solid #e1e4e8;
        margin-bottom: 20px;
    }

    .actions-section h3 {
        margin: 0 0 20px 0;
        color: #333;
        font-size: 20px;
        font-weight: 600;
    }

    .action-buttons {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 15px;
    }

    .action-btn {
        padding: 14px 20px;
        background: #667eea;
        color: white;
        text-decoration: none;
        border-radius: 8px;
        font-weight: 600;
        font-size: 14px;
        transition: all 0.3s ease;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }

    .action-btn:hover {
        background: #764ba2;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
    }

    .action-btn.green { background: #27ae60; }
    .action-btn.green:hover { background: #229954; }

    .action-btn.red { background: #e74c3c; }
    .action-btn.red:hover { background: #c0392b; }

    .action-btn.purple { background: #9b59b6; }
    .action-btn.purple:hover { background: #8e44ad; }

    .action-btn.orange { background: #ff9800; }
    .action-btn.orange:hover { background: #f57c00; }

    .action-btn.teal { background: #17a2b8; }
    .action-btn.teal:hover { background: #138496; }

    /* Recent Activity Section */
    .recent-activity {
        background: white;
        padding: 25px;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        border: 1px solid #e1e4e8;
    }

    .recent-activity h3 {
        margin: 0 0 20px 0;
        color: #333;
        font-size: 20px;
        font-weight: 600;
    }

    .activity-item {
        padding: 15px;
        background: #f8f9fc;
        border-radius: 8px;
        margin-bottom: 10px;
        border-left: 4px solid #667eea;
    }

    .activity-item:last-child {
        margin-bottom: 0;
    }

    .activity-item strong {
        color: #333;
        font-weight: 600;
    }

    .activity-item .time {
        color: #999;
        font-size: 12px;
        margin-top: 5px;
        display: block;
    }

    .no-activity {
        color: #999;
        text-align: center;
        padding: 30px;
        background: #f8f9fc;
        border-radius: 8px;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .sidebar {
            width: 100%;
            height: auto;
            position: relative;
        }
        
        .main-content-area {
            margin-left: 0;
            width: 100%;
            padding-top: 200px;
        }

        .dashboard-container {
            padding: 20px 15px;
        }

        .stats-grid {
            grid-template-columns: 1fr;
        }

        .action-buttons {
            grid-template-columns: 1fr;
        }
    }
</style>

<!-- SIDEBAR -->
<div class="sidebar">
    <div class="sidebar-header">
        <h2>📚 Mumbai University</h2>
    </div>
    <nav class="sidebar-menu">
        <a href="dashboard_mum_unu.php" class="menu-item active">🏠 Dashboard</a>
        <a href="home.php" class="menu-item">🏠 Home Page</a>
        <a href="about.php" class="menu-item">ℹ️ About Page</a>
        <a href="media.php" class="menu-item">📸 Media Gallery</a>
        <a href="teacher.php" class="menu-item">👨‍🏫 Teachers</a>
        <a href="contact.php" class="menu-item">📧 Contact</a>
        <a href="slider.php" class="menu-item">🎞️ Sliders</a>
    </nav>
</div>

<!-- MAIN CONTENT AREA -->
<div class="main-content-area">
    <div class="dashboard-container">
        
        <!-- Page Header -->
        <div class="page-header">
            <h2>🎓 Mumbai University Dashboard</h2>
            <p>Manage Mumbai University content, students, sliders and website data</p>
        </div>

        <!-- Statistics Cards -->
        <div class="stats-grid">
            
            <div class="stat-card">
                <div class="stat-icon blue">👨‍🎓</div>
                <div class="stat-info">
                    <h3><?php echo $stats['total_students']; ?></h3>
                    <p>Total Students</p>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon green">📝</div>
                <div class="stat-info">
                    <h3><?php echo $stats['total_content']; ?></h3>
                    <p>Content Pages</p>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon orange">🖼️</div>
                <div class="stat-info">
                    <h3><?php echo $stats['total_gallery']; ?></h3>
                    <p>Gallery Images</p>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon purple">📧</div>
                <div class="stat-info">
                    <h3><?php echo $stats['total_contacts']; ?></h3>
                    <p>Contact Messages</p>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon teal">🎞️</div>
                <div class="stat-info">
                    <h3><?php echo $stats['total_sliders']; ?></h3>
                    <p>Total Sliders</p>
                </div>
            </div>

        </div>

        <!-- Quick Actions Section -->
        <div class="actions-section">
            <h3>⚡ Quick Actions</h3>
            <div class="action-buttons">
                
                <a href="../manage_content.php?school_id=3" class="action-btn">
                    📝 Manage Content
                </a>
                
                <a href="slider.php" class="action-btn green">
                    🎞️ Manage Sliders
                </a>
                
                <a href="../gallery.php?school_id=3" class="action-btn red">
                    🖼️ Manage Gallery
                </a>
                
                <a href="../students.php?school_id=3" class="action-btn purple">
                    👨‍🎓 View Students
                </a>
                
                <a href="../contacts.php?school_id=3" class="action-btn orange">
                    📧 View Contacts
                </a>
                
                <a href="../donations.php?school_id=3" class="action-btn teal">
                    💰 View Donations
                </a>
                
            </div>
        </div>

        <!-- Recent Activity Section -->
        <div class="recent-activity">
            <h3>📊 Recent Activity</h3>
            
            <?php
            // Check if content_pages table exists first
            $table_check = @mysqli_query($db, "SHOW TABLES LIKE 'content_pages'");
            
            if ($table_check && mysqli_num_rows($table_check) > 0) {
                // Table exists, fetch recent content
                $activities_query = "SELECT * FROM content_pages 
                                     WHERE school_id = $school_id 
                                     ORDER BY updated_at DESC 
                                     LIMIT 5";
                $activities_result = @mysqli_query($db, $activities_query);
                
                if ($activities_result && mysqli_num_rows($activities_result) > 0) {
                    while ($activity = mysqli_fetch_assoc($activities_result)) {
                        $title = htmlspecialchars($activity['title'] ?? 'Untitled');
                        $page_type = htmlspecialchars(ucfirst($activity['page_type'] ?? 'Page'));
                        $time = date('d M Y, h:i A', strtotime($activity['updated_at']));
            ?>
            <div class="activity-item">
                <strong><?php echo $title; ?></strong> (<?php echo $page_type; ?>) was updated
                <span class="time">⏰ <?php echo $time; ?></span>
            </div>
            <?php 
                    }
                } else {
            ?>
            <div class="no-activity">
                📭 No recent activity found for Mumbai University.<br>
                Start by adding content or uploading sliders!
            </div>
            <?php 
                }
            } else {
                // Table doesn't exist
            ?>
            <div class="no-activity">
                ⚠️ Database table 'content_pages' not found.<br>
                Please create the required database tables first.
            </div>
            <?php } ?>
        </div>

    </div>
</div>

<?php require_once 'footer.php'; ?>
