<?php
/**
 * Media Management - Mumbai University
 * Location: /college/orc_sch/media.php
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Database connection (parent folder se)
require_once '../db.php';

// Page title
$page_title = "Media Gallery - Mumbai University";

// Authentication check
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

$school_id = 3; // Mumbai University

// ==================== HANDLE IMAGE ACTIONS ====================

// Delete Image
if (isset($_GET['delete_image']) && is_numeric($_GET['delete_image'])) {
    $image_id = intval($_GET['delete_image']);
    
    $get_img = mysqli_query($db, "SELECT image_path FROM mum_gallery WHERE id = $image_id AND school_id = $school_id");
    if ($row = mysqli_fetch_assoc($get_img)) {
        $img_path = '../' . $row['image_path'];
        if (file_exists($img_path)) {
            unlink($img_path);
        }
    }
    
    mysqli_query($db, "DELETE FROM mum_gallery WHERE id = $image_id AND school_id = $school_id");
    header("Location: media.php?tab=images&msg=image_deleted");
    exit;
}

// Add/Update Image
if (isset($_POST['submit_image'])) {
    $title = mysqli_real_escape_string($db, $_POST['image_title']);
    $description = mysqli_real_escape_string($db, $_POST['image_description']);
    $tags = mysqli_real_escape_string($db, $_POST['image_tags']);
    $category = mysqli_real_escape_string($db, $_POST['image_category']);
    $display_order = intval($_POST['image_display_order']);
    $is_active = isset($_POST['image_is_active']) ? 1 : 0;
    
    $upload_dir = '../uploads/gallery/';
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0777, true);
    }
    
    if (isset($_POST['image_id']) && !empty($_POST['image_id'])) {
        // Update existing image
        $image_id = intval($_POST['image_id']);
        
        if (!empty($_FILES['gallery_image']['name'])) {
            // Delete old image
            $get_old = mysqli_query($db, "SELECT image_path FROM mum_gallery WHERE id = $image_id");
            if ($row = mysqli_fetch_assoc($get_old)) {
                $old_path = '../' . $row['image_path'];
                if (file_exists($old_path)) unlink($old_path);
            }
            
            // Upload new image
            $image_name = time() . '_' . $_FILES['gallery_image']['name'];
            $image_path = 'uploads/gallery/' . $image_name;
            move_uploaded_file($_FILES['gallery_image']['tmp_name'], $upload_dir . $image_name);
            
            $query = "UPDATE mum_gallery SET 
                     title = '$title',
                     description = '$description',
                     tags = '$tags',
                     category = '$category',
                     image_path = '$image_path',
                     display_order = $display_order,
                     is_active = $is_active
                     WHERE id = $image_id AND school_id = $school_id";
        } else {
            $query = "UPDATE mum_gallery SET 
                     title = '$title',
                     description = '$description',
                     tags = '$tags',
                     category = '$category',
                     display_order = $display_order,
                     is_active = $is_active
                     WHERE id = $image_id AND school_id = $school_id";
        }
        
        mysqli_query($db, $query);
        header("Location: media.php?tab=images&msg=image_updated");
        exit;
        
    } else {
        // Add new image
        if (!empty($_FILES['gallery_image']['name'])) {
            $image_name = time() . '_' . $_FILES['gallery_image']['name'];
            $image_path = 'uploads/gallery/' . $image_name;
            move_uploaded_file($_FILES['gallery_image']['tmp_name'], $upload_dir . $image_name);
            
            $query = "INSERT INTO mum_gallery (school_id, image_path, title, description, tags, category, display_order, is_active) 
                     VALUES ($school_id, '$image_path', '$title', '$description', '$tags', '$category', $display_order, $is_active)";
            
            mysqli_query($db, $query);
            header("Location: media.php?tab=images&msg=image_added");
            exit;
        }
    }
}

// ==================== HANDLE VIDEO ACTIONS ====================

// Delete Video
if (isset($_GET['delete_video']) && is_numeric($_GET['delete_video'])) {
    $video_id = intval($_GET['delete_video']);
    
    $get_video = mysqli_query($db, "SELECT video_path, thumbnail FROM mum_videos WHERE id = $video_id AND school_id = $school_id");
    if ($row = mysqli_fetch_assoc($get_video)) {
        if ($row['video_path']) {
            $video_path = '../' . $row['video_path'];
            if (file_exists($video_path)) unlink($video_path);
        }
        if ($row['thumbnail']) {
            $thumb_path = '../' . $row['thumbnail'];
            if (file_exists($thumb_path)) unlink($thumb_path);
        }
    }
    
    mysqli_query($db, "DELETE FROM mum_videos WHERE id = $video_id AND school_id = $school_id");
    header("Location: media.php?tab=videos&msg=video_deleted");
    exit;
}

// Add/Update Video
if (isset($_POST['submit_video'])) {
    $title = mysqli_real_escape_string($db, $_POST['video_title']);
    $description = mysqli_real_escape_string($db, $_POST['video_description']);
    $video_url = mysqli_real_escape_string($db, $_POST['video_url']);
    $video_type = mysqli_real_escape_string($db, $_POST['video_type']);
    $tags = mysqli_real_escape_string($db, $_POST['video_tags']);
    $category = mysqli_real_escape_string($db, $_POST['video_category']);
    $duration = mysqli_real_escape_string($db, $_POST['video_duration']);
    $display_order = intval($_POST['video_display_order']);
    $is_active = isset($_POST['video_is_active']) ? 1 : 0;
    
    $upload_dir = '../uploads/videos/';
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0777, true);
    }
    
    if (isset($_POST['video_id']) && !empty($_POST['video_id'])) {
        // Update existing video
        $video_id = intval($_POST['video_id']);
        
        $thumbnail_path = '';
        if (!empty($_FILES['video_thumbnail']['name'])) {
            $thumb_name = time() . '_thumb_' . $_FILES['video_thumbnail']['name'];
            $thumbnail_path = 'uploads/videos/' . $thumb_name;
            move_uploaded_file($_FILES['video_thumbnail']['tmp_name'], $upload_dir . $thumb_name);
            
            $query = "UPDATE mum_videos SET 
                     title = '$title',
                     description = '$description',
                     video_url = '$video_url',
                     video_type = '$video_type',
                     thumbnail = '$thumbnail_path',
                     tags = '$tags',
                     category = '$category',
                     duration = '$duration',
                     display_order = $display_order,
                     is_active = $is_active
                     WHERE id = $video_id AND school_id = $school_id";
        } else {
            $query = "UPDATE mum_videos SET 
                     title = '$title',
                     description = '$description',
                     video_url = '$video_url',
                     video_type = '$video_type',
                     tags = '$tags',
                     category = '$category',
                     duration = '$duration',
                     display_order = $display_order,
                     is_active = $is_active
                     WHERE id = $video_id AND school_id = $school_id";
        }
        
        mysqli_query($db, $query);
        header("Location: media.php?tab=videos&msg=video_updated");
        exit;
        
    } else {
        // Add new video
        $thumbnail_path = '';
        if (!empty($_FILES['video_thumbnail']['name'])) {
            $thumb_name = time() . '_thumb_' . $_FILES['video_thumbnail']['name'];
            $thumbnail_path = 'uploads/videos/' . $thumb_name;
            move_uploaded_file($_FILES['video_thumbnail']['tmp_name'], $upload_dir . $thumb_name);
        }
        
        $query = "INSERT INTO mum_videos (school_id, video_url, video_type, thumbnail, title, description, tags, category, duration, display_order, is_active) 
                 VALUES ($school_id, '$video_url', '$video_type', '$thumbnail_path', '$title', '$description', '$tags', '$category', '$duration', $display_order, $is_active)";
        
        mysqli_query($db, $query);
        header("Location: media.php?tab=videos&msg=video_added");
        exit;
    }
}

// Active tab
$active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'images';

// Search functionality for images
$image_search = '';
$image_where = "WHERE school_id = $school_id";
if (isset($_GET['image_search']) && !empty($_GET['image_search'])) {
    $image_search = mysqli_real_escape_string($db, $_GET['image_search']);
    $image_where .= " AND (title LIKE '%$image_search%' OR tags LIKE '%$image_search%' OR category LIKE '%$image_search%')";
}

$images_query = "SELECT * FROM mum_gallery $image_where ORDER BY display_order ASC";
$images_result = mysqli_query($db, $images_query);

// Search functionality for videos
$video_search = '';
$video_where = "WHERE school_id = $school_id";
if (isset($_GET['video_search']) && !empty($_GET['video_search'])) {
    $video_search = mysqli_real_escape_string($db, $_GET['video_search']);
    $video_where .= " AND (title LIKE '%$video_search%' OR tags LIKE '%$video_search%' OR category LIKE '%$video_search%')";
}

$videos_query = "SELECT * FROM mum_videos $video_where ORDER BY display_order ASC";
$videos_result = mysqli_query($db, $videos_query);

// Count for tabs
$images_result_count = mysqli_query($db, $images_query);
$videos_result_count = mysqli_query($db, $videos_query);
$image_count = mysqli_num_rows($images_result_count);
$video_count = mysqli_num_rows($videos_result_count);

// Edit modes
$edit_image_mode = false;
$edit_image_data = [];
if (isset($_GET['edit_image']) && is_numeric($_GET['edit_image'])) {
    $edit_id = intval($_GET['edit_image']);
    $edit_query = mysqli_query($db, "SELECT * FROM mum_gallery WHERE id = $edit_id AND school_id = $school_id");
    if (mysqli_num_rows($edit_query) > 0) {
        $edit_image_mode = true;
        $edit_image_data = mysqli_fetch_assoc($edit_query);
        $active_tab = 'images';
    }
}

$edit_video_mode = false;
$edit_video_data = [];
if (isset($_GET['edit_video']) && is_numeric($_GET['edit_video'])) {
    $edit_id = intval($_GET['edit_video']);
    $edit_query = mysqli_query($db, "SELECT * FROM mum_videos WHERE id = $edit_id AND school_id = $school_id");
    if (mysqli_num_rows($edit_query) > 0) {
        $edit_video_mode = true;
        $edit_video_data = mysqli_fetch_assoc($edit_query);
        $active_tab = 'videos';
    }
}

require_once '../header.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Media Gallery - Mumbai University</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        /* ========== SIDEBAR ========== */
        .sidebar {
            width: 280px;
            background: linear-gradient(180deg, #1a252f 0%, #2c3e50 100%);
            color: white;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
            top: 0;
            left: 0;
            z-index: 1000;
            box-shadow: 4px 0 20px rgba(0,0,0,0.1);
        }

        .sidebar-header {
            padding: 30px 20px;
            background: rgba(0,0,0,0.2);
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }

        .sidebar-header h2 {
            font-size: 19px;
            font-weight: 700;
            margin: 0;
            letter-spacing: 0.5px;
        }

        .sidebar-menu {
            padding: 25px 0;
        }

        .menu-item {
            display: flex;
            align-items: center;
            padding: 16px 25px;
            color: #ecf0f1;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border-left: 4px solid transparent;
            font-size: 15px;
            font-weight: 500;
        }

        .menu-item:hover {
            background: rgba(255,255,255,0.1);
            border-left-color: #667eea;
            padding-left: 30px;
        }

        .menu-item.active {
            background: linear-gradient(90deg, rgba(102, 126, 234, 0.3) 0%, transparent 100%);
            border-left-color: #667eea;
            color: #fff;
        }

        /* ========== MAIN CONTENT ========== */
        .main-content-area {
            margin-left: 280px;
            width: calc(100% - 280px);
            min-height: 100vh;
            padding: 130px 20px 40px 20px;
            background: #f5f7fa;
        }

        .media-container {
            max-width: 1400px;
            margin: 0 auto;
        }

        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin: 0 0 30px 0;
            padding: 30px;
            background: white;
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        }

        .page-header h2 {
            font-size: 32px;
            color: #2d3748;
            font-weight: 800;
            margin: 0;
        }

        .back-btn {
            padding: 14px 28px;
            background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
            color: white;
            text-decoration: none;
            border-radius: 12px;
            font-weight: 600;
            transition: all 0.3s;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        .back-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(107, 114, 128, 0.4);
        }

        .alert {
            padding: 18px 24px;
            border-radius: 12px;
            margin-bottom: 25px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 12px;
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            box-shadow: 0 4px 16px rgba(16, 185, 129, 0.3);
        }

        /* ========== TABS ========== */
        .tabs-container {
            background: white;
            border-radius: 16px 16px 0 0;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            margin-bottom: 0;
            overflow: hidden;
        }

        .tabs {
            display: flex;
            gap: 0;
            border-bottom: 3px solid #e1e4e8;
        }

        .tab-button {
            flex: 1;
            padding: 20px 30px;
            background: #f8f9fc;
            border: none;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            color: #666;
            border-bottom: 3px solid transparent;
            margin-bottom: -3px;
            text-decoration: none;
            display: block;
            text-align: center;
        }

        .tab-button:hover {
            background: #e8eaf0;
            color: #333;
        }

        .tab-button.active {
            color: #667eea;
            background: white;
            border-bottom-color: #667eea;
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }

        /* ========== SEARCH ========== */
        .search-section {
            background: white;
            padding: 25px;
            border-radius: 0 0 16px 16px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            margin-bottom: 25px;
            border: 1px solid #e1e4e8;
            border-top: none;
        }

        .search-form {
            display: flex;
            gap: 12px;
        }

        .search-input {
            flex: 1;
            padding: 14px 18px;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            font-size: 15px;
            transition: all 0.3s;
        }

        .search-input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
        }

        .search-btn {
            padding: 14px 32px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s;
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
        }

        .search-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(102, 126, 234, 0.4);
        }

        .clear-btn {
            padding: 14px 24px;
            background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
            color: white;
            text-decoration: none;
            border-radius: 12px;
            font-weight: 600;
            transition: all 0.3s;
            display: inline-block;
            box-shadow: 0 4px 12px rgba(107, 114, 128, 0.2);
        }

        .clear-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(107, 114, 128, 0.3);
        }

        /* ========== FORM ========== */
        .form-section {
            background: white;
            padding: 35px;
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            margin-bottom: 30px;
        }

        .form-section h3 {
            margin-bottom: 28px;
            color: #2d3748;
            font-size: 22px;
            font-weight: 700;
            padding-bottom: 12px;
            border-bottom: 3px solid #667eea;
        }

        .form-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 24px;
        }

        .form-group {
            display: flex;
            flex-direction: column;
        }

        .form-group.full-width {
            grid-column: 1 / -1;
        }

        .form-group label {
            font-weight: 600;
            margin-bottom: 10px;
            color: #374151;
            font-size: 14px;
        }

        .form-group input[type="text"],
        .form-group input[type="number"],
        .form-group input[type="file"],
        .form-group select,
        .form-group textarea {
            padding: 14px 18px;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            font-size: 15px;
            transition: all 0.3s;
            font-family: inherit;
        }

        .form-group textarea {
            resize: vertical;
            min-height: 100px;
        }

        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
        }

        .checkbox-group {
            display: flex;
            align-items: center;
            gap: 12px;
            padding-top: 10px;
        }

        .checkbox-group input[type="checkbox"] {
            width: 22px;
            height: 22px;
            cursor: pointer;
        }

        .form-actions {
            display: flex;
            gap: 15px;
            margin-top: 30px;
        }

        .btn {
            padding: 16px 36px;
            border: none;
            border-radius: 12px;
            font-weight: 700;
            font-size: 15px;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-block;
        }

        .btn-primary {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            box-shadow: 0 4px 16px rgba(16, 185, 129, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 24px rgba(16, 185, 129, 0.4);
        }

        .btn-secondary {
            background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
            color: white;
            box-shadow: 0 4px 12px rgba(107, 114, 128, 0.2);
        }

        .btn-secondary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(107, 114, 128, 0.3);
        }

        /* ========== GALLERY ========== */
        .gallery-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 25px;
            background: white;
            padding: 35px;
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        }

        .gallery-item {
            background: white;
            border: 2px solid #e5e7eb;
            border-radius: 16px;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .gallery-item:hover {
            box-shadow: 0 8px 24px rgba(0,0,0,0.12);
            transform: translateY(-8px);
            border-color: #667eea;
        }

        .gallery-image {
            width: 100%;
            height: 220px;
            object-fit: cover;
        }

        .gallery-info {
            padding: 20px;
        }

        .gallery-info h4 {
            font-size: 18px;
            color: #1f2937;
            margin-bottom: 10px;
            font-weight: 700;
        }

        .gallery-info p {
            color: #6b7280;
            font-size: 14px;
            margin-bottom: 12px;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
            line-height: 1.6;
        }

        .gallery-tags {
            display: flex;
            flex-wrap: wrap;
            gap: 6px;
            margin-bottom: 12px;
        }

        .tag {
            background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%);
            color: #1e40af;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .gallery-meta {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 15px;
            padding-top: 15px;
            border-top: 2px solid #f3f4f6;
        }

        .status-badge {
            padding: 6px 14px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .status-badge.active {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            box-shadow: 0 2px 8px rgba(16, 185, 129, 0.3);
        }

        .status-badge.inactive {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
            color: white;
            box-shadow: 0 2px 8px rgba(239, 68, 68, 0.3);
        }

        .gallery-actions {
            display: flex;
            gap: 8px;
        }

        .action-link {
            padding: 6px 14px;
            border-radius: 8px;
            text-decoration: none;
            font-size: 12px;
            font-weight: 700;
            transition: all 0.2s;
        }

        .action-link.edit {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            color: white;
            box-shadow: 0 2px 8px rgba(59, 130, 246, 0.3);
        }

        .action-link.edit:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.4);
        }

        .action-link.delete {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
            color: white;
            box-shadow: 0 2px 8px rgba(239, 68, 68, 0.3);
        }

        .action-link.delete:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(239, 68, 68, 0.4);
        }

        .no-items {
            text-align: center;
            padding: 80px 20px;
            color: #9ca3af;
            font-size: 18px;
            background: linear-gradient(135deg, #f9fafb 0%, #f3f4f6 100%);
            border-radius: 16px;
            grid-column: 1 / -1;
        }

        /* ========== VIDEO ========== */
        .video-thumbnail {
            position: relative;
            width: 100%;
            height: 220px;
            background: #000;
        }

        .video-thumbnail img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .play-icon {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 70px;
            height: 70px;
            background: rgba(255,255,255,0.95);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 28px;
            color: #ef4444;
            box-shadow: 0 4px 16px rgba(0,0,0,0.3);
            transition: all 0.3s;
        }

        .gallery-item:hover .play-icon {
            transform: translate(-50%, -50%) scale(1.1);
        }

        .video-duration {
            position: absolute;
            bottom: 12px;
            right: 12px;
            background: rgba(0,0,0,0.85);
            color: white;
            padding: 6px 12px;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 700;
        }

        /* ========== RESPONSIVE ========== */
        @media (max-width: 768px) {
            .sidebar {
                width: 100%;
                height: auto;
                position: relative;
            }
            
            .main-content-area {
                margin-left: 0;
                width: 100%;
                padding-top: 180px;
            }

            .media-container {
                padding: 20px 15px;
            }

            .form-grid {
                grid-template-columns: 1fr;
            }

            .gallery-grid {
                grid-template-columns: 1fr;
            }

            .page-header {
                flex-direction: column;
                gap: 15px;
                align-items: flex-start;
                padding: 20px;
            }

            .search-form {
                flex-direction: column;
            }

            .tabs {
                flex-direction: row;
            }

            .tab-button {
                padding: 15px 20px;
                font-size: 14px;
            }
        }
    </style>
</head>
<body>

<!-- ========== SIDEBAR ========== -->
<div class="sidebar">
    <div class="sidebar-header">
        <h2>📸 Media Gallery</h2>
    </div>
    <nav class="sidebar-menu">
        <a href="dashboard_ocr_sch.php" class="menu-item">🏠 Dashboard</a>
        <a href="media.php" class="menu-item active">📸 Media Gallery</a>
        <a href="teacher.php" class="menu-item">👨‍🏫 Teachers</a>
        <a href="sliders.php" class="menu-item">🎞️ Sliders</a>
        <a href="../students.php?school_id=3" class="menu-item">👨‍🎓 Students</a>
    </nav>
</div>

<!-- ========== MAIN CONTENT ========== -->
<div class="main-content-area">
    <div class="media-container">
        
        <!-- Page Header -->
        <div class="page-header">
            <h2>📸 Media Gallery</h2>
            <a href="dashboard_ocr_sch.php" class="back-btn">← Back to Dashboard</a>
        </div>

        <!-- Success Messages -->
        <?php if (isset($_GET['msg'])): ?>
            <div class="alert">
                <span style="font-size: 24px;">✅</span>
                <?php
                if ($_GET['msg'] == 'image_added') echo 'Image added successfully!';
                if ($_GET['msg'] == 'image_updated') echo 'Image updated successfully!';
                if ($_GET['msg'] == 'image_deleted') echo 'Image deleted successfully!';
                if ($_GET['msg'] == 'video_added') echo 'Video added successfully!';
                if ($_GET['msg'] == 'video_updated') echo 'Video updated successfully!';
                if ($_GET['msg'] == 'video_deleted') echo 'Video deleted successfully!';
                ?>
            </div>
        <?php endif; ?>

        <!-- Tabs -->
        <div class="tabs-container">
            <div class="tabs">
                <a href="media.php?tab=images" class="tab-button <?php echo $active_tab == 'images' ? 'active' : ''; ?>">
                    🖼️ Images (<?php echo $image_count; ?>)
                </a>
                <a href="media.php?tab=videos" class="tab-button <?php echo $active_tab == 'videos' ? 'active' : ''; ?>">
                    🎬 Videos (<?php echo $video_count; ?>)
                </a>
            </div>
        </div>

        <!-- ========== TAB: IMAGES ========== -->
        <div class="tab-content <?php echo $active_tab == 'images' ? 'active' : ''; ?>">
            
            <!-- Search -->
            <div class="search-section">
                <form method="GET" action="media.php" class="search-form">
                    <input type="hidden" name="tab" value="images">
                    <input type="text" 
                           name="image_search" 
                           class="search-input" 
                           placeholder="🔍 Search images by title, tags or category..." 
                           value="<?php echo htmlspecialchars($image_search); ?>">
                    <button type="submit" class="search-btn">🔍 Search</button>
                    <?php if (!empty($image_search)): ?>
                        <a href="media.php?tab=images" class="clear-btn">✖ Clear</a>
                    <?php endif; ?>
                </form>
            </div>

            <!-- Add/Edit Form -->
            <div class="form-section">
                <h3><?php echo $edit_image_mode ? '✏️ Edit Image' : '➕ Add New Image'; ?></h3>
                <form method="POST" enctype="multipart/form-data">
                    
                    <?php if ($edit_image_mode): ?>
                        <input type="hidden" name="image_id" value="<?php echo $edit_image_data['id']; ?>">
                    <?php endif; ?>

                    <div class="form-grid">
                        
                        <div class="form-group">
                            <label>Image Title *</label>
                            <input type="text" name="image_title" required 
                                   value="<?php echo $edit_image_mode ? htmlspecialchars($edit_image_data['title']) : ''; ?>"
                                   placeholder="Enter image title">
                        </div>

                        <div class="form-group">
                            <label>Category</label>
                            <input type="text" name="image_category" 
                                   value="<?php echo $edit_image_mode ? htmlspecialchars($edit_image_data['category']) : ''; ?>" 
                                   placeholder="e.g., Events, Campus, Sports">
                        </div>

                        <div class="form-group full-width">
                            <label>Description</label>
                            <textarea name="image_description" placeholder="Enter description"><?php echo $edit_image_mode ? htmlspecialchars($edit_image_data['description']) : ''; ?></textarea>
                        </div>

                        <div class="form-group">
                            <label>Tags (comma-separated)</label>
                            <input type="text" name="image_tags" 
                                   value="<?php echo $edit_image_mode ? htmlspecialchars($edit_image_data['tags']) : ''; ?>" 
                                   placeholder="e.g., sports, annual day, 2024">
                        </div>

                        <div class="form-group">
                            <label>Display Order *</label>
                            <input type="number" name="image_display_order" required min="1"
                                   value="<?php echo $edit_image_mode ? $edit_image_data['display_order'] : '1'; ?>">
                        </div>

                        <div class="form-group">
                            <label>Image * <?php echo $edit_image_mode ? '(Leave blank to keep current)' : ''; ?></label>
                            <input type="file" name="gallery_image" accept="image/*" <?php echo $edit_image_mode ? '' : 'required'; ?>>
                        </div>

                        <div class="form-group">
                            <div class="checkbox-group">
                                <input type="checkbox" name="image_is_active" id="image_is_active" 
                                       <?php echo ($edit_image_mode && $edit_image_data['is_active']) || !$edit_image_mode ? 'checked' : ''; ?>>
                                <label for="image_is_active">Active (Show on website)</label>
                            </div>
                        </div>

                    </div>

                    <div class="form-actions">
                        <button type="submit" name="submit_image" class="btn btn-primary">
                            <?php echo $edit_image_mode ? '💾 Update Image' : '➕ Add Image'; ?>
                        </button>
                        <?php if ($edit_image_mode): ?>
                            <a href="media.php?tab=images" class="btn btn-secondary">✖ Cancel</a>
                        <?php endif; ?>
                    </div>

                </form>
            </div>

            <!-- Gallery Grid -->
            <div class="gallery-grid">
                <?php if (mysqli_num_rows($images_result) > 0): ?>
                    <?php while ($image = mysqli_fetch_assoc($images_result)): ?>
                        <div class="gallery-item">
                            <img src="../<?php echo $image['image_path']; ?>" alt="Gallery" class="gallery-image">
                            <div class="gallery-info">
                                <h4><?php echo htmlspecialchars($image['title']); ?></h4>
                                <?php if ($image['description']): ?>
                                    <p><?php echo htmlspecialchars($image['description']); ?></p>
                                <?php endif; ?>
                                <?php if ($image['tags']): ?>
                                    <div class="gallery-tags">
                                        <?php 
                                        $tags = explode(',', $image['tags']);
                                        foreach ($tags as $tag): 
                                            $tag = trim($tag);
                                            if ($tag):
                                        ?>
                                            <span class="tag"><?php echo htmlspecialchars($tag); ?></span>
                                        <?php 
                                            endif;
                                        endforeach; 
                                        ?>
                                    </div>
                                <?php endif; ?>
                                <div class="gallery-meta">
                                    <span class="status-badge <?php echo $image['is_active'] ? 'active' : 'inactive'; ?>">
                                        <?php echo $image['is_active'] ? '✓ Active' : '✗ Inactive'; ?>
                                    </span>
                                    <div class="gallery-actions">
                                        <a href="media.php?tab=images&edit_image=<?php echo $image['id']; ?>" class="action-link edit">✏️ Edit</a>
                                        <a href="media.php?delete_image=<?php echo $image['id']; ?>" 
                                           class="action-link delete"
                                           onclick="return confirm('Delete this image?')">🗑️ Delete</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div class="no-items">
                        <p><?php echo !empty($image_search) ? '🔍 No images found matching your search.' : '📭 No images found. Add your first image above!'; ?></p>
                    </div>
                <?php endif; ?>
            </div>
            
        </div>

        <!-- ========== TAB: VIDEOS ========== -->
        <div class="tab-content <?php echo $active_tab == 'videos' ? 'active' : ''; ?>">
            
            <!-- Search -->
            <div class="search-section">
                <form method="GET" action="media.php" class="search-form">
                    <input type="hidden" name="tab" value="videos">
                    <input type="text" 
                           name="video_search" 
                           class="search-input" 
                           placeholder="🔍 Search videos by title, tags or category..." 
                           value="<?php echo htmlspecialchars($video_search); ?>">
                    <button type="submit" class="search-btn">🔍 Search</button>
                    <?php if (!empty($video_search)): ?>
                        <a href="media.php?tab=videos" class="clear-btn">✖ Clear</a>
                    <?php endif; ?>
                </form>
            </div>

            <!-- Add/Edit Form -->
            <div class="form-section">
                <h3><?php echo $edit_video_mode ? '✏️ Edit Video' : '➕ Add New Video'; ?></h3>
                <form method="POST" enctype="multipart/form-data">
                    
                    <?php if ($edit_video_mode): ?>
                        <input type="hidden" name="video_id" value="<?php echo $edit_video_data['id']; ?>">
                    <?php endif; ?>

                    <div class="form-grid">
                        
                        <div class="form-group">
                            <label>Video Title *</label>
                            <input type="text" name="video_title" required 
                                   value="<?php echo $edit_video_mode ? htmlspecialchars($edit_video_data['title']) : ''; ?>"
                                   placeholder="Enter video title">
                        </div>

                        <div class="form-group">
                            <label>Video Type *</label>
                            <select name="video_type" required>
                                <option value="youtube" <?php echo ($edit_video_mode && $edit_video_data['video_type'] == 'youtube') ? 'selected' : ''; ?>>YouTube</option>
                                <option value="vimeo" <?php echo ($edit_video_mode && $edit_video_data['video_type'] == 'vimeo') ? 'selected' : ''; ?>>Vimeo</option>
                            </select>
                        </div>

                        <div class="form-group full-width">
                            <label>Video URL * (YouTube/Vimeo URL)</label>
                            <input type="text" name="video_url" required 
                                   value="<?php echo $edit_video_mode ? htmlspecialchars($edit_video_data['video_url']) : ''; ?>" 
                                   placeholder="https://www.youtube.com/watch?v=...">
                        </div>

                        <div class="form-group full-width">
                            <label>Description</label>
                            <textarea name="video_description" placeholder="Enter description"><?php echo $edit_video_mode ? htmlspecialchars($edit_video_data['description']) : ''; ?></textarea>
                        </div>

                        <div class="form-group">
                            <label>Category</label>
                            <input type="text" name="video_category" 
                                   value="<?php echo $edit_video_mode ? htmlspecialchars($edit_video_data['category']) : ''; ?>" 
                                   placeholder="e.g., Lectures, Events">
                        </div>

                        <div class="form-group">
                            <label>Duration</label>
                            <input type="text" name="video_duration" 
                                   value="<?php echo $edit_video_mode ? htmlspecialchars($edit_video_data['duration']) : ''; ?>" 
                                   placeholder="e.g., 5:30">
                        </div>

                        <div class="form-group">
                            <label>Tags (comma-separated)</label>
                            <input type="text" name="video_tags" 
                                   value="<?php echo $edit_video_mode ? htmlspecialchars($edit_video_data['tags']) : ''; ?>" 
                                   placeholder="e.g., tutorial, lecture, 2024">
                        </div>

                        <div class="form-group">
                            <label>Display Order *</label>
                            <input type="number" name="video_display_order" required min="1"
                                   value="<?php echo $edit_video_mode ? $edit_video_data['display_order'] : '1'; ?>">
                        </div>

                        <div class="form-group">
                            <label>Thumbnail (Optional)</label>
                            <input type="file" name="video_thumbnail" accept="image/*">
                        </div>

                        <div class="form-group">
                            <div class="checkbox-group">
                                <input type="checkbox" name="video_is_active" id="video_is_active" 
                                       <?php echo ($edit_video_mode && $edit_video_data['is_active']) || !$edit_video_mode ? 'checked' : ''; ?>>
                                <label for="video_is_active">Active (Show on website)</label>
                            </div>
                        </div>

                    </div>

                    <div class="form-actions">
                        <button type="submit" name="submit_video" class="btn btn-primary">
                            <?php echo $edit_video_mode ? '💾 Update Video' : '➕ Add Video'; ?>
                        </button>
                        <?php if ($edit_video_mode): ?>
                            <a href="media.php?tab=videos" class="btn btn-secondary">✖ Cancel</a>
                        <?php endif; ?>
                    </div>

                </form>
            </div>

            <!-- Gallery Grid -->
            <div class="gallery-grid">
                <?php if (mysqli_num_rows($videos_result) > 0): ?>
                    <?php while ($video = mysqli_fetch_assoc($videos_result)): ?>
                        <div class="gallery-item">
                            <div class="video-thumbnail">
                                <?php if ($video['thumbnail']): ?>
                                    <img src="../<?php echo $video['thumbnail']; ?>" alt="Video Thumbnail">
                                <?php else: ?>
                                    <img src="https://via.placeholder.com/320x220/667eea/ffffff?text=Video" alt="Video">
                                <?php endif; ?>
                                <div class="play-icon">▶</div>
                                <?php if ($video['duration']): ?>
                                    <div class="video-duration"><?php echo htmlspecialchars($video['duration']); ?></div>
                                <?php endif; ?>
                            </div>
                            <div class="gallery-info">
                                <h4><?php echo htmlspecialchars($video['title']); ?></h4>
                                <?php if ($video['description']): ?>
                                    <p><?php echo htmlspecialchars($video['description']); ?></p>
                                <?php endif; ?>
                                <?php if ($video['tags']): ?>
                                    <div class="gallery-tags">
                                        <?php 
                                        $tags = explode(',', $video['tags']);
                                        foreach ($tags as $tag): 
                                            $tag = trim($tag);
                                            if ($tag):
                                        ?>
                                            <span class="tag"><?php echo htmlspecialchars($tag); ?></span>
                                        <?php 
                                            endif;
                                        endforeach; 
                                        ?>
                                    </div>
                                <?php endif; ?>
                                <div class="gallery-meta">
                                    <span class="status-badge <?php echo $video['is_active'] ? 'active' : 'inactive'; ?>">
                                        <?php echo $video['is_active'] ? '✓ Active' : '✗ Inactive'; ?>
                                    </span>
                                    <div class="gallery-actions">
                                        <a href="media.php?tab=videos&edit_video=<?php echo $video['id']; ?>" class="action-link edit">✏️ Edit</a>
                                        <a href="media.php?delete_video=<?php echo $video['id']; ?>" 
                                           class="action-link delete"
                                           onclick="return confirm('Delete this video?')">🗑️ Delete</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div class="no-items">
                        <p><?php echo !empty($video_search) ? '🔍 No videos found matching your search.' : '📭 No videos found. Add your first video above!'; ?></p>
                    </div>
                <?php endif; ?>
            </div>
            
        </div>

    </div>
</div>

</body>
</html>
