<?php
/**
 * Sliders Management - Mumbai University
 * Location: /college/mum_unu/slider.php
 * Including existing slider.php file
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Database connection
require_once '../db.php';

// Authentication check
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

$school_id = 3; // Mumbai University
$_GET['school_id'] = $school_id; // Set for slider.php

require_once '../header.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sliders - Mumbai University</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        /* ========== SIDEBAR ========== */
        .sidebar {
            width: 280px;
            background: linear-gradient(180deg, #1a252f 0%, #2c3e50 100%);
            color: white;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
            top: 0;
            left: 0;
            z-index: 1000;
            box-shadow: 4px 0 20px rgba(0,0,0,0.1);
        }

        .sidebar-header {
            padding: 30px 20px;
            background: rgba(0,0,0,0.2);
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }

        .sidebar-header h2 {
            font-size: 19px;
            font-weight: 700;
            margin: 0;
            letter-spacing: 0.5px;
        }

        .sidebar-menu {
            padding: 25px 0;
        }

        .menu-item {
            display: flex;
            align-items: center;
            padding: 16px 25px;
            color: #ecf0f1;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border-left: 4px solid transparent;
            font-size: 15px;
            font-weight: 500;
        }

        .menu-item:hover {
            background: rgba(255,255,255,0.1);
            border-left-color: #667eea;
            padding-left: 30px;
        }

        .menu-item.active {
            background: linear-gradient(90deg, rgba(102, 126, 234, 0.3) 0%, transparent 100%);
            border-left-color: #667eea;
            color: #fff;
        }

        /* ========== MAIN CONTENT ========== */
        .main-content-area {
            margin-left: 280px;
            width: calc(100% - 280px);
            min-height: 100vh;
            padding: 130px 20px 40px 20px;
            background: #f5f7fa;
        }

        .slider-container {
            max-width: 1400px;
            margin: 0 auto;
        }

        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin: 0 0 30px 0;
            padding: 30px;
            background: white;
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        }

        .page-header h2 {
            font-size: 32px;
            color: #2d3748;
            font-weight: 800;
            margin: 0;
        }

        .btn-back {
            padding: 14px 28px;
            border-radius: 12px;
            font-weight: 600;
            font-size: 15px;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
            color: white;
            transition: all 0.3s;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        .btn-back:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(107, 114, 128, 0.4);
        }

        .slider-content {
            background: white;
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            padding: 0;
            overflow: hidden;
        }

        /* ========== RESPONSIVE ========== */
        @media (max-width: 768px) {
            .sidebar {
                width: 100%;
                height: auto;
                position: relative;
            }
            
            .main-content-area {
                margin-left: 0;
                width: 100%;
                padding-top: 180px;
            }

            .page-header {
                flex-direction: column;
                gap: 15px;
                align-items: flex-start;
                padding: 20px;
            }
        }
    </style>
</head>
<body>

<!-- SIDEBAR -->
<div class="sidebar">
    <div class="sidebar-header">
        <h2>📚 Mumbai University</h2>
    </div>
    <nav class="sidebar-menu">
        <a href="dashboard_mum_unu.php" class="menu-item">🏠 Dashboard</a>
        <a href="home.php" class="menu-item">🏠 Home Page</a>
        <a href="about.php" class="menu-item">ℹ️ About Page</a>
        <a href="media.php" class="menu-item">📸 Media Gallery</a>
        <a href="teacher.php" class="menu-item">👨‍🏫 Teachers</a>
        <a href="contact.php" class="menu-item">📧 Contact</a>
        <a href="slider.php" class="menu-item active">🎞️ Sliders</a>
    </nav>
</div>

<!-- MAIN CONTENT -->
<div class="main-content-area">
    <div class="slider-container">
        
        <div class="page-header">
            <h2>🎞️ Sliders Management</h2>
            <a href="dashboard_mum_unu.php" class="btn-back">← Back to Dashboard</a>
        </div>

        <div class="slider-content">
            <?php
            // ========== INCLUDING EXISTING SLIDER.PHP ==========
            // Check multiple possible locations
            $slider_file = null;
            $possible_paths = [
                '../slider.php',
                '../../slider.php',
                dirname(__FILE__) . '/../slider.php'
            ];
            
            foreach ($possible_paths as $path) {
                if (file_exists($path)) {
                    $slider_file = $path;
                    break;
                }
            }
            
            if ($slider_file) {
                include $slider_file;
            } else {
                echo '<div style="padding: 80px; text-align: center;">';
                echo '<div style="font-size: 64px; margin-bottom: 20px;">⚠️</div>';
                echo '<h3 style="color: #ef4444; font-size: 24px; margin-bottom: 12px;">Slider File Not Found</h3>';
                echo '<p style="color: #6b7280; font-size: 16px;">Looking for slider.php in:</p>';
                echo '<ul style="color: #9ca3af; font-size: 14px; list-style: none; margin-top: 15px;">';
                foreach ($possible_paths as $path) {
                    echo '<li style="margin: 8px 0;">📁 ' . htmlspecialchars($path) . '</li>';
                }
                echo '</ul>';
                echo '</div>';
            }
            ?>
        </div>

    </div>
</div>

</body>
</html>
