<?php
/**
 * Admin Panel Footer
 * Location: /college/footer.php
 */
?>

<style>
/* ==================== FOOTER STYLES ==================== */

.admin-footer {
    background: white;
    padding: 20px 30px;
    margin-top: 50px;
    border-top: 1px solid #e9ecef;
    box-shadow: 0 -2px 10px rgba(0,0,0,0.05);
}

.footer-content {
    max-width: 1400px;
    margin: 0 auto;
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 15px;
}

.footer-left {
    color: #7f8c8d;
    font-size: 0.95em;
}

.footer-left strong {
    color: #2c3e50;
}

.footer-right {
    color: #7f8c8d;
    font-size: 0.9em;
}

.footer-links {
    display: flex;
    gap: 20px;
    margin-top: 10px;
}

.footer-links a {
    color: #3498db;
    text-decoration: none;
    transition: color 0.3s ease;
}

.footer-links a:hover {
    color: #2980b9;
}

/* Responsive Footer */
@media (max-width: 768px) {
    .footer-content {
        flex-direction: column;
        text-align: center;
    }
    
    .footer-links {
        justify-content: center;
    }
}

/* Back to Top Button */
.back-to-top {
    position: fixed;
    bottom: 30px;
    right: 30px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: none;
    align-items: center;
    justify-content: center;
    font-size: 1.5em;
    cursor: pointer;
    box-shadow: 0 4px 15px rgba(0,0,0,0.2);
    transition: all 0.3s ease;
    z-index: 999;
}

.back-to-top:hover {
    transform: translateY(-5px);
    box-shadow: 0 6px 20px rgba(0,0,0,0.3);
}

.back-to-top.show {
    display: flex;
}
</style>

<!-- FOOTER SECTION -->
<footer class="admin-footer">
    <div class="footer-content">
        <div class="footer-left">
            <strong>Mumbai University Admin Panel</strong>
            <p style="margin-top: 5px;">
                Logged in as: <strong><?php echo htmlspecialchars($admin_name); ?></strong>
            </p>
        </div>
        
        <div class="footer-right">
            <p>&copy; <?php echo date('Y'); ?> Mumbai University. All rights reserved.</p>
            <div class="footer-links">
                <a href="dashboard_ocr_sch.php">Dashboard</a>
                <a href="../manage_content.php?school_id=3">Content</a>
                <a href="../logout.php">Logout</a>
            </div>
        </div>
    </div>
</footer>

<!-- Back to Top Button -->
<div class="back-to-top" id="backToTop" onclick="scrollToTop()">
    ↑
</div>

<script>
// ==================== FOOTER JAVASCRIPT ====================

// Back to Top Button
window.addEventListener('scroll', function() {
    const backToTopBtn = document.getElementById('backToTop');
    if (window.pageYOffset > 300) {
        backToTopBtn.classList.add('show');
    } else {
        backToTopBtn.classList.remove('show');
    }
});

function scrollToTop() {
    window.scrollTo({
        top: 0,
        behavior: 'smooth'
    });
}

// Auto-hide alerts after 5 seconds
document.addEventListener('DOMContentLoaded', function() {
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(function(alert) {
        setTimeout(function() {
            alert.style.transition = 'opacity 0.5s ease';
            alert.style.opacity = '0';
            setTimeout(function() {
                alert.style.display = 'none';
            }, 500);
        }, 5000);
    });
});

// Confirm before delete actions
document.addEventListener('DOMContentLoaded', function() {
    const deleteButtons = document.querySelectorAll('a[href*="delete"]');
    deleteButtons.forEach(function(button) {
        if (!button.hasAttribute('onclick')) {
            button.addEventListener('click', function(e) {
                if (!confirm('Are you sure you want to delete this item?')) {
                    e.preventDefault();
                }
            });
        }
    });
});

// Form validation helper
function validateForm(formId) {
    const form = document.getElementById(formId);
    if (!form) return true;
    
    const requiredFields = form.querySelectorAll('[required]');
    let isValid = true;
    
    requiredFields.forEach(function(field) {
        if (!field.value.trim()) {
            field.style.borderColor = '#e74c3c';
            isValid = false;
        } else {
            field.style.borderColor = '#ddd';
        }
    });
    
    return isValid;
}

// Image preview before upload
function previewImage(input, previewId) {
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const preview = document.getElementById(previewId);
            if (preview) {
                preview.src = e.target.result;
                preview.style.display = 'block';
            }
        };
        reader.readAsDataURL(input.files[0]);
    }
}

// Console message
console.log('%cMumbai University Admin Panel', 'color: #3498db; font-size: 20px; font-weight: bold;');
console.log('%cDeveloped by Smart Digi Solution', 'color: #2c3e50; font-size: 14px;');
</script>

</body>
</html>
