<?php
// ============================================================
// CONFIG
// ============================================================
define('API_ID',       'APID1227');
define('API_KEY',      'a136c59d-e371-4080-b940-0e632fae572a');
define('TOKEN_ID',     'YOUR_TOKEN_ID_HERE');
define('BASE_URL',     'https://javabackend.idspay.in/api/v1/prod');
define('RAZORPAY_KEY_ID',     'rzp_live_YOUR_KEY_ID');
define('RAZORPAY_KEY_SECRET', 'YOUR_RAZORPAY_SECRET');
define('REPORT_PRICE', 100);

header('X-Frame-Options: SAMEORIGIN');
$action = $_POST['action'] ?? '';

if ($action === 'prefill') {
    $mobile = preg_replace('/\D/', '', $_POST['mobile'] ?? '');
    if (strlen($mobile) !== 10) { echo json_encode(['success'=>false,'message'=>'Invalid mobile']); exit; }
    $result = callAPI('/srv3/credit-report/prefill-wn', ['api_id'=>API_ID,'api_key'=>API_KEY,'token_id'=>TOKEN_ID,'mobile'=>$mobile]);
    echo json_encode($result); exit;
}

if ($action === 'verify_payment') {
    echo json_encode(['success'=>true,'message'=>'Payment verified']); exit;
}

if ($action === 'fetch_report') {
    $name   = trim($_POST['name']    ?? '');
    $mobile = preg_replace('/\D/', '', $_POST['mobile'] ?? '');
    $pan    = strtoupper(trim($_POST['pan'] ?? ''));
    $gender = trim($_POST['gender']  ?? '');
    $consent= trim($_POST['consent'] ?? 'Y');
    if (!$name || strlen($mobile) !== 10 || !$pan) {
        echo json_encode(['success'=>false,'message'=>'Please fill all required fields']); exit;
    }
    $payload = ['api_id'=>API_ID,'api_key'=>API_KEY,'token_id'=>TOKEN_ID,'name'=>$name,'mobile'=>$mobile,'pan'=>$pan,'gender'=>$gender,'consent'=>$consent];
    $result = callAPI('/srv3/credit-report/transunion', $payload);
    echo json_encode($result); exit;
}

function callAPI(string $endpoint, array $payload): array {
    $ch = curl_init(BASE_URL . $endpoint);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => json_encode($payload),
        CURLOPT_HTTPHEADER     => ['Content-Type: application/json','Accept: application/json'],
        CURLOPT_TIMEOUT        => 30,
        CURLOPT_SSL_VERIFYPEER => true,
    ]);
    $body = curl_exec($ch);
    $err  = curl_error($ch);
    curl_close($ch);
    if ($err) return ['success'=>false,'message'=>'Connection error: '.$err];
    $d = json_decode($body, true);
    if (!$d) return ['success'=>false,'message'=>'Invalid API response'];
    return ($d['status']['code'] ?? 0) == 200
        ? ['success'=>true,'data'=>$d]
        : ['success'=>false,'message'=>$d['status']['message'] ?? 'API Error'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Credit Score Check | PropGurus</title>
<link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@600;700;900&family=Inter:wght@300;400;500;600;700&family=JetBrains+Mono:wght@400;500&display=swap" rel="stylesheet">
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<style>
*,*::before,*::after{box-sizing:border-box;margin:0;padding:0}
:root{
  --g:#c9970f;--g2:#e8b830;--g3:#f5d060;
  --glow:rgba(201,151,15,.2);--glow2:rgba(201,151,15,.08);
  --ink:#080808;--ink2:#101010;--ink3:#161616;--ink4:#1e1e1e;--ink5:#272727;
  --line:#252525;--line2:#303030;
  --muted:#5a5a5a;--text:#c0c0c0;--white:#fff;
  --green:#1db954;--red:#e04848;
  --font-d:'Cinzel',serif;--font-b:'Inter',sans-serif;--font-m:'JetBrains Mono',monospace;
  --r:10px;--r2:16px;--r3:22px;
  --shadow:0 32px 80px rgba(0,0,0,.7);
  --t:.2s cubic-bezier(.4,0,.2,1);
}
html{scroll-behavior:smooth}
body{font-family:var(--font-b);background:var(--ink);color:var(--white);overflow-x:hidden;-webkit-font-smoothing:antialiased}

/* ── TICKER ── */
.ticker{background:linear-gradient(90deg,var(--g),var(--g2),var(--g));color:var(--ink);font-size:11px;font-weight:700;letter-spacing:.12em;text-transform:uppercase;padding:9px 0;overflow:hidden;white-space:nowrap}
.ticker-track{display:flex;width:max-content;animation:ticker 40s linear infinite}
.ticker-track span{padding:0 44px}
.ticker-track span::before{content:'◈';margin-right:10px;opacity:.5}
@keyframes ticker{from{transform:translateX(0)}to{transform:translateX(-50%)}}

/* ── NAVBAR ── */
nav{background:rgba(8,8,8,.96);backdrop-filter:blur(20px);border-bottom:1px solid var(--line);position:sticky;top:0;z-index:999;height:68px;display:flex;align-items:center;justify-content:space-between;padding:0 clamp(20px,4vw,60px)}
.nav-logo{display:flex;align-items:center;gap:11px;text-decoration:none}
.nav-mark{width:38px;height:38px;background:linear-gradient(135deg,var(--g),var(--g2));border-radius:8px;display:flex;align-items:center;justify-content:center;font-family:var(--font-d);font-size:18px;font-weight:900;color:var(--ink);box-shadow:0 0 20px var(--glow)}
.nav-name{font-family:var(--font-d);font-size:17px;color:var(--white);letter-spacing:.12em}
.nav-links{display:flex;gap:28px}
.nav-links a{color:var(--muted);text-decoration:none;font-size:13px;font-weight:500;letter-spacing:.03em;padding:4px 0;border-bottom:1.5px solid transparent;transition:color var(--t),border-color var(--t)}
.nav-links a:hover,.nav-links a.active{color:var(--g);border-bottom-color:var(--g)}
.nav-btn{background:linear-gradient(135deg,var(--g),var(--g2));color:var(--ink);font-weight:700;font-size:12px;letter-spacing:.08em;text-transform:uppercase;padding:10px 22px;border-radius:var(--r);text-decoration:none;transition:all var(--t);box-shadow:0 4px 16px var(--glow)}
.nav-btn:hover{transform:translateY(-1px);box-shadow:0 8px 24px var(--glow)}
@media(max-width:768px){.nav-links{display:none}}

/* ── HERO ── */
.hero{position:relative;min-height:580px;display:flex;align-items:center;justify-content:center;overflow:hidden;padding:100px 20px 80px}
.hero-canvas{position:absolute;inset:0;background:radial-gradient(ellipse 60% 70% at 15% 60%,rgba(201,151,15,.14) 0%,transparent 70%),radial-gradient(ellipse 50% 60% at 85% 25%,rgba(201,151,15,.08) 0%,transparent 65%),linear-gradient(175deg,var(--ink) 0%,#0d0c08 50%,var(--ink) 100%)}
.hero-grid{position:absolute;inset:0;background-image:linear-gradient(rgba(201,151,15,.04) 1px,transparent 1px),linear-gradient(90deg,rgba(201,151,15,.04) 1px,transparent 1px);background-size:60px 60px;mask-image:radial-gradient(ellipse 80% 80% at 50% 50%,black 30%,transparent 100%)}
.hero-inner{position:relative;z-index:2;max-width:740px;text-align:center}
.hero-eyebrow{display:inline-flex;align-items:center;gap:8px;border:1px solid rgba(201,151,15,.3);background:rgba(201,151,15,.06);color:var(--g2);font-size:11px;font-weight:600;letter-spacing:.14em;text-transform:uppercase;padding:7px 18px;border-radius:40px;margin-bottom:28px}
.hero-eyebrow::before{content:'';width:6px;height:6px;background:var(--g2);border-radius:50%;animation:pulse 2s ease-in-out infinite}
@keyframes pulse{0%,100%{opacity:1;transform:scale(1)}50%{opacity:.35;transform:scale(.7)}}
.hero h1{font-family:var(--font-d);font-size:clamp(32px,5.5vw,60px);line-height:1.08;letter-spacing:.02em;color:var(--white);margin-bottom:20px}
.hero h1 em{font-style:normal;color:var(--g2)}
.hero-sub{color:var(--muted);font-size:16px;line-height:1.75;max-width:520px;margin:0 auto 40px}
.hero-stats{display:flex;justify-content:center;border:1px solid var(--line);border-radius:var(--r2);overflow:hidden;margin-bottom:44px;background:rgba(255,255,255,.02)}
.hstat{flex:1;padding:20px 16px;text-align:center;border-right:1px solid var(--line)}
.hstat:last-child{border-right:none}
.hstat-val{font-family:var(--font-d);font-size:24px;color:var(--g2);display:block;line-height:1.1}
.hstat-key{font-size:10px;color:var(--muted);text-transform:uppercase;letter-spacing:.1em;margin-top:5px;display:block}
.hero-cta{display:inline-flex;align-items:center;gap:12px;background:linear-gradient(135deg,var(--g) 0%,var(--g2) 100%);color:var(--ink);font-weight:700;font-size:15px;letter-spacing:.04em;padding:17px 40px;border-radius:var(--r2);border:none;cursor:pointer;box-shadow:0 8px 32px rgba(201,151,15,.35);transition:all var(--t)}
.hero-cta:hover{transform:translateY(-2px);box-shadow:0 16px 48px rgba(201,151,15,.45)}
.cta-arr{font-size:18px;transition:transform var(--t)}
.hero-cta:hover .cta-arr{transform:translateX(4px)}
.hero-note{margin-top:16px;font-size:12px;color:var(--muted)}
.hero-note strong{color:var(--green)}

/* ── SCORE BANDS ── */
.band-sec{background:var(--ink2);border-top:1px solid var(--line);padding:72px 20px}
.container{max-width:1100px;margin:auto}
.sec-hd{text-align:center;margin-bottom:52px}
.sec-hd h2{font-family:var(--font-d);font-size:clamp(24px,3.5vw,38px);color:var(--white);margin-bottom:10px;letter-spacing:.05em}
.sec-hd h2 em{font-style:normal;color:var(--g2)}
.sec-hd p{color:var(--muted);font-size:14px}
.bands{display:flex;border:1px solid var(--line);border-radius:var(--r2);overflow:hidden}
.band{flex:1;padding:28px 16px;text-align:center;border-right:1px solid var(--line);background:var(--ink3);transition:background var(--t),transform var(--t);position:relative;overflow:hidden}
.band::before{content:'';position:absolute;top:0;left:0;right:0;height:3px}
.band:last-child{border-right:none}
.band:hover{background:var(--ink4)}
.band-r{font-family:var(--font-m);font-size:17px;font-weight:500;margin-bottom:7px}
.band-l{font-size:11px;font-weight:700;text-transform:uppercase;letter-spacing:.1em;margin-bottom:5px}
.band-d{font-size:11px;color:var(--muted);line-height:1.5}
.bp .band-r,.bp .band-l{color:#e04848}.bp::before{background:#e04848}
.bf .band-r,.bf .band-l{color:#e07d30}.bf::before{background:#e07d30}
.bg .band-r,.bg .band-l{color:#e8b830}.bg::before{background:#e8b830}
.bv .band-r,.bv .band-l{color:#5ec97a}.bv::before{background:#5ec97a}
.be .band-r,.be .band-l{color:#1db954}.be::before{background:#1db954}
@media(max-width:600px){.bands{flex-direction:column}.band{border-right:none;border-bottom:1px solid var(--line)}.band:last-child{border-bottom:none}}

/* ── FORM SECTION ── */
.form-sec{padding:80px 20px;background:var(--ink)}
.form-wrap{max-width:620px;margin:auto}
.form-card{background:var(--ink2);border:1px solid var(--line);border-radius:var(--r3);overflow:hidden;box-shadow:var(--shadow),0 0 0 1px rgba(255,255,255,.02)}

/* Header */
.form-head{padding:28px 32px;background:linear-gradient(135deg,rgba(201,151,15,.12) 0%,rgba(201,151,15,.03) 100%);border-bottom:1px solid var(--line);display:flex;align-items:center;gap:16px}
.head-ico{width:52px;height:52px;flex-shrink:0;background:linear-gradient(145deg,var(--g),var(--g2));border-radius:13px;display:flex;align-items:center;justify-content:center;font-size:22px;box-shadow:0 6px 20px rgba(201,151,15,.3)}
.head-txt h2{font-family:var(--font-d);font-size:18px;color:var(--white);letter-spacing:.06em;line-height:1.2}
.head-txt p{font-size:12px;color:var(--muted);margin-top:5px;letter-spacing:.02em}
.head-txt p span{color:rgba(201,151,15,.55)}

/* Steps */
.steps{display:flex;background:var(--ink3);border-bottom:1px solid var(--line)}
.step{flex:1;display:flex;align-items:center;justify-content:center;gap:7px;padding:14px 8px;font-size:10.5px;font-weight:700;letter-spacing:.1em;text-transform:uppercase;color:var(--muted);border-bottom:2px solid transparent;transition:color var(--t),border-color var(--t);position:relative}
.step+.step::before{content:'';position:absolute;left:0;top:50%;transform:translateY(-50%);width:1px;height:38%;background:var(--line)}
.step.active{color:var(--g2);border-bottom-color:var(--g2)}
.step.done{color:var(--green);border-bottom-color:var(--green)}
.step-b{width:20px;height:20px;border-radius:50%;background:var(--ink5);display:flex;align-items:center;justify-content:center;font-size:10px;font-weight:700;flex-shrink:0;transition:all var(--t)}
.step.active .step-b{background:var(--g2);color:var(--ink)}
.step.done .step-b{background:var(--green);color:var(--white)}

/* Form body */
.form-body{padding:32px}
.fp{display:none}.fp.active{display:block}

/* Alert */
.alert{background:rgba(224,72,72,.1);border:1px solid rgba(224,72,72,.25);border-radius:var(--r);padding:12px 16px;font-size:13px;color:#e04848;font-weight:500;margin-bottom:22px;display:none;align-items:center;gap:10px}
.alert.show{display:flex}

/* Field groups */
.fg{margin-bottom:20px}
.fg label{display:block;font-size:10.5px;font-weight:700;color:var(--muted);margin-bottom:8px;text-transform:uppercase;letter-spacing:.12em}
.fg label .req{color:var(--g2);margin-left:1px}
.row2{display:grid;grid-template-columns:1fr 1fr;gap:14px}
@media(max-width:500px){.row2{grid-template-columns:1fr}}

/* Inputs */
.fc{width:100%;background:var(--ink3);border:1.5px solid var(--line2);border-radius:var(--r);color:var(--white);font-family:var(--font-b);font-size:14px;padding:13px 15px;outline:none;transition:border-color var(--t),box-shadow var(--t),background var(--t);-webkit-appearance:none;appearance:none}
.fc:focus{border-color:var(--g);box-shadow:0 0 0 3px rgba(201,151,15,.1);background:var(--ink4)}
.fc::placeholder{color:var(--muted);font-size:13px}
.fc:hover:not(:focus){background:rgba(255,255,255,.02)}
select.fc{cursor:pointer;background-image:url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='7' fill='none'%3E%3Cpath d='M1 1l5 5 5-5' stroke='%23555' stroke-width='1.5' stroke-linecap='round' stroke-linejoin='round'/%3E%3C/svg%3E");background-repeat:no-repeat;background-position:right 14px center;padding-right:38px}
select.fc option{background:var(--ink3);color:var(--white)}

/* Mobile input */
.mob-row{display:flex}
.mob-cc{display:flex;align-items:center;gap:7px;background:var(--ink4);border:1.5px solid var(--line2);border-right:none;border-radius:var(--r) 0 0 var(--r);padding:0 14px;color:var(--text);font-size:13px;font-weight:600;white-space:nowrap;flex-shrink:0;font-family:var(--font-m);letter-spacing:.03em}
.mob-row .fc{border-radius:0 var(--r) var(--r) 0;font-family:var(--font-m);letter-spacing:.04em}
#pan{font-family:var(--font-m);letter-spacing:.08em}

/* Prefill tag */
.prefill-ok{margin-top:7px;font-size:11px;color:var(--green);font-weight:600;display:none;align-items:center;gap:6px}
.prefill-ok.show{display:flex}
.prefill-ok::before{content:'';width:6px;height:6px;background:var(--green);border-radius:50%;flex-shrink:0;animation:blink 1.5s ease-in-out infinite}
@keyframes blink{0%,100%{opacity:1}50%{opacity:.3}}

/* Consent */
.consent{background:var(--ink3);border:1.5px solid var(--line2);border-radius:var(--r);padding:14px 16px;display:flex;gap:12px;align-items:flex-start;cursor:pointer;transition:border-color var(--t),background var(--t)}
.consent:hover{border-color:rgba(201,151,15,.3);background:rgba(201,151,15,.03)}
.consent input{margin-top:2px;accent-color:var(--g);width:16px;height:16px;flex-shrink:0;cursor:pointer}
.consent p{font-size:12.5px;color:var(--muted);line-height:1.65}
.consent strong{color:var(--text)}

/* Buttons */
.btn-gold{width:100%;background:linear-gradient(135deg,var(--g) 0%,var(--g2) 60%,var(--g3) 100%);color:var(--ink);font-family:var(--font-b);font-size:14px;font-weight:700;letter-spacing:.06em;border:none;border-radius:var(--r);padding:15.5px;cursor:pointer;transition:all var(--t);margin-top:10px;box-shadow:0 4px 20px rgba(201,151,15,.25);position:relative;overflow:hidden}
.btn-gold::after{content:'';position:absolute;inset:0;background:linear-gradient(90deg,transparent,rgba(255,255,255,.14),transparent);transform:translateX(-100%);transition:transform .5s}
.btn-gold:hover::after{transform:translateX(100%)}
.btn-gold:hover{transform:translateY(-1px);box-shadow:0 8px 28px rgba(201,151,15,.35)}
.btn-gold:active{transform:translateY(0)}
.btn-gold:disabled{opacity:.4;cursor:not-allowed;transform:none;box-shadow:none}
.btn-ghost{width:100%;background:transparent;border:1.5px solid var(--line2);color:var(--muted);font-family:var(--font-b);font-size:13px;font-weight:500;border-radius:var(--r);padding:13px;cursor:pointer;transition:all var(--t);margin-top:10px}
.btn-ghost:hover{border-color:rgba(201,151,15,.4);color:var(--g)}

.secure-line{display:flex;align-items:center;justify-content:center;gap:8px;margin-top:14px;font-size:11.5px;color:var(--muted);letter-spacing:.04em}
.secure-line .dot{width:3px;height:3px;background:var(--muted);border-radius:50%}
.secure-line strong{color:var(--green)}

/* Payment */
.pay-intro{font-size:11px;color:var(--muted);margin-bottom:4px;letter-spacing:.06em;text-transform:uppercase;text-align:center}
.pay-box{background:linear-gradient(135deg,rgba(201,151,15,.1),rgba(201,151,15,.04));border:1.5px solid rgba(201,151,15,.25);border-radius:var(--r2);padding:30px 24px;margin:14px 0 20px;position:relative;overflow:hidden;text-align:center}
.pay-box::before{content:'';position:absolute;top:-60px;right:-60px;width:180px;height:180px;background:radial-gradient(circle,rgba(201,151,15,.12),transparent 70%);pointer-events:none}
.pay-amt{font-family:var(--font-d);font-size:66px;color:var(--g2);line-height:1;letter-spacing:.02em}
.pay-sub{color:var(--muted);font-size:11px;margin-top:8px;letter-spacing:.08em;text-transform:uppercase}
.pay-perks{margin-top:18px;text-align:left;display:flex;flex-direction:column;gap:8px}
.perk{display:flex;align-items:center;gap:9px;font-size:12.5px;color:var(--text)}
.perk-dot{width:5px;height:5px;background:var(--g);border-radius:50%;flex-shrink:0}
.pay-feats{display:grid;grid-template-columns:1fr 1fr;gap:9px;margin:18px 0}
.pf{display:flex;align-items:center;gap:7px;font-size:12px;color:var(--muted)}
.pf::before{content:'✓';color:var(--g);font-weight:700}
.pay-terms{font-size:11px;color:var(--muted);text-align:center;margin-top:8px}
.pay-terms a{color:rgba(201,151,15,.7);text-decoration:none;transition:color var(--t)}
.pay-terms a:hover{color:var(--g2)}

/* States */
.state{text-align:center;padding:52px 20px}
.state-ico{font-size:52px;display:block;margin-bottom:18px}
.state h3{font-family:var(--font-d);font-size:20px;letter-spacing:.06em;margin-bottom:10px}
.state p{color:var(--muted);font-size:13px;line-height:1.7}
.loader{width:42px;height:42px;border:3px solid var(--ink5);border-top-color:var(--g2);border-radius:50%;animation:spin .75s linear infinite;margin:24px auto 0}
@keyframes spin{to{transform:rotate(360deg)}}

/* ── REPORT ── */
#reportSection{display:none;padding:64px 20px;background:var(--ink)}
.report-wrap{max-width:900px;margin:auto}
.report-toolbar{display:flex;gap:12px;margin-bottom:28px;flex-wrap:wrap}
.tbtn{background:var(--ink2);border:1.5px solid var(--line2);color:var(--text);font-family:var(--font-b);font-size:13px;font-weight:500;padding:10px 22px;border-radius:var(--r);cursor:pointer;transition:all var(--t)}
.tbtn:hover{border-color:var(--g);color:var(--g)}
.report-top{background:var(--ink2);border:1px solid var(--line);border-radius:var(--r3);padding:36px;margin-bottom:20px;display:grid;grid-template-columns:auto 1fr;gap:36px;align-items:center}
@media(max-width:560px){.report-top{grid-template-columns:1fr;text-align:center}}
.score-dial{width:148px;height:148px;border-radius:50%;display:flex;align-items:center;justify-content:center;flex-shrink:0;position:relative}
.score-dial-inner{width:116px;height:116px;background:var(--ink2);border-radius:50%;display:flex;flex-direction:column;align-items:center;justify-content:center}
.sdial-num{font-family:var(--font-d);font-size:36px;line-height:1}
.sdial-max{font-size:11px;color:var(--muted)}
.sdial-lbl{font-size:10px;font-weight:700;letter-spacing:.1em;text-transform:uppercase;margin-top:4px;padding:2px 8px;border-radius:10px}
.rdetails h2{font-family:var(--font-d);font-size:24px;letter-spacing:.04em;margin-bottom:4px}
.rpan{font-size:12px;color:var(--muted);font-family:var(--font-m);margin-bottom:18px}
.rmeta{display:grid;grid-template-columns:1fr 1fr;gap:10px}
.rmeta-item{background:var(--ink3);border-radius:var(--r);padding:12px 14px;border:1px solid var(--line)}
.rmeta-key{font-size:10px;color:var(--muted);text-transform:uppercase;letter-spacing:.1em}
.rmeta-val{font-size:14px;font-weight:600;color:var(--white);margin-top:4px;font-family:var(--font-m)}
.report-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(260px,1fr));gap:16px}
.rcard{background:var(--ink2);border:1px solid var(--line);border-radius:var(--r2);padding:26px}
.rcard-title{font-size:10px;font-weight:700;text-transform:uppercase;letter-spacing:.14em;color:var(--muted);margin-bottom:18px;display:flex;align-items:center;gap:8px}
.rcard-title::before{content:'';width:3px;height:14px;background:var(--g);border-radius:2px;flex-shrink:0}
.row-item{display:flex;justify-content:space-between;align-items:center;padding:11px 0;border-bottom:1px solid var(--line);font-size:13px}
.row-item:last-child{border-bottom:none}
.ri-label{color:var(--muted)}
.ri-val{font-weight:600;color:var(--white);font-family:var(--font-m);font-size:13px}
.badge{font-size:10px;font-weight:700;text-transform:uppercase;letter-spacing:.08em;padding:3px 9px;border-radius:20px}
.b-active{background:rgba(29,185,84,.12);color:#1db954;border:1px solid rgba(29,185,84,.25)}
.b-closed{background:rgba(120,120,120,.12);color:#888;border:1px solid rgba(120,120,120,.2)}
.b-overdue{background:rgba(224,72,72,.12);color:#e04848;border:1px solid rgba(224,72,72,.25)}

/* ── HOW IT WORKS ── */
.how-sec{padding:80px 20px;background:var(--ink2);border-top:1px solid var(--line)}
.how-steps{max-width:840px;margin:52px auto 0;display:grid;grid-template-columns:1fr 40px 1fr 40px 1fr;align-items:start}
.how-card{text-align:center;padding:0 8px}
.how-ico{width:70px;height:70px;margin:0 auto 18px;background:var(--ink3);border:1.5px solid var(--line2);border-radius:var(--r2);display:flex;align-items:center;justify-content:center;font-size:28px;position:relative;transition:border-color var(--t),transform var(--t)}
.how-card:hover .how-ico{border-color:rgba(201,151,15,.4);transform:translateY(-4px)}
.how-num{position:absolute;top:-9px;right:-9px;width:22px;height:22px;background:linear-gradient(135deg,var(--g),var(--g2));color:var(--ink);border-radius:50%;font-size:10px;font-weight:800;display:flex;align-items:center;justify-content:center}
.how-card h3{font-size:15px;font-weight:700;color:var(--white);margin-bottom:8px}
.how-card p{font-size:12px;color:var(--muted);line-height:1.65}
.how-arr{display:flex;align-items:center;justify-content:center;padding-top:22px;color:var(--line2);font-size:22px}
@media(max-width:660px){.how-steps{grid-template-columns:1fr;gap:32px}.how-arr{display:none}}

/* ── TRUST ── */
.trust-sec{padding:72px 20px;background:var(--ink);border-top:1px solid var(--line)}
.trust-grid{max-width:900px;margin:48px auto 0;display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:20px}
.trust-card{background:var(--ink2);border:1px solid var(--line);border-radius:var(--r2);padding:28px 20px;text-align:center;transition:border-color var(--t),transform var(--t)}
.trust-card:hover{border-color:rgba(201,151,15,.25);transform:translateY(-3px)}
.trust-ico{width:52px;height:52px;background:rgba(201,151,15,.06);border:1px solid rgba(201,151,15,.15);border-radius:var(--r);margin:0 auto 16px;display:flex;align-items:center;justify-content:center;font-size:22px}
.trust-card h4{font-size:14px;font-weight:700;color:var(--white);margin-bottom:7px}
.trust-card p{font-size:12px;color:var(--muted);line-height:1.6}

/* ── FAQ ── */
.faq-sec{padding:72px 20px;background:var(--ink2);border-top:1px solid var(--line)}
.faq-list{max-width:680px;margin:48px auto 0}
.faq-item{border:1px solid var(--line);border-radius:var(--r);margin-bottom:10px;overflow:hidden}
.faq-q{padding:18px 20px;font-weight:600;font-size:14px;cursor:pointer;display:flex;justify-content:space-between;align-items:center;color:var(--white);background:var(--ink3);transition:background var(--t)}
.faq-q:hover{background:var(--ink4)}
.faq-tog{width:26px;height:26px;border-radius:50%;background:var(--ink5);display:flex;align-items:center;justify-content:center;color:var(--g);font-size:16px;font-weight:700;flex-shrink:0;transition:transform var(--t),background var(--t)}
.faq-q.open .faq-tog{transform:rotate(45deg);background:var(--g);color:var(--ink)}
.faq-a{max-height:0;overflow:hidden;transition:max-height .35s ease,padding .35s;background:var(--ink3)}
.faq-a.open{max-height:200px;padding:0 20px 18px}
.faq-a p{color:var(--muted);font-size:13px;line-height:1.75}

/* ── FOOTER ── */
footer{background:var(--ink);border-top:1px solid var(--line);padding:48px 20px 24px;text-align:center}
.f-brand{font-family:var(--font-d);font-size:24px;color:var(--g);letter-spacing:.12em;margin-bottom:6px}
.f-tag{font-size:12px;color:var(--muted);margin-bottom:24px}
.f-links{display:flex;justify-content:center;gap:24px;flex-wrap:wrap;margin-bottom:20px}
.f-links a{color:var(--muted);font-size:12px;text-decoration:none;transition:color var(--t)}
.f-links a:hover{color:var(--g)}
.f-legal{max-width:480px;margin:0 auto 20px;font-size:11px;color:#333;line-height:1.7}
.f-copy{font-size:11px;color:#2a2a2a;padding-top:20px;border-top:1px solid var(--line)}

@media print{nav,.ticker,.hero,.band-sec,.how-sec,.trust-sec,.faq-sec,footer,.form-sec,.report-toolbar{display:none!important}#reportSection{display:block!important;background:#fff;color:#000}}
</style>
</head>
<body>

<!-- TICKER -->
<div class="ticker">
  <div class="ticker-track">
    <span>Check Your Credit Score</span><span>Transunion CIBIL Report Instantly</span><span>100% Secure & Encrypted</span><span>Trusted by 10,000+ Users</span><span>Know Your Score Before Applying for Loan</span><span>Soft Inquiry — No Score Impact</span>
    <span>Check Your Credit Score</span><span>Transunion CIBIL Report Instantly</span><span>100% Secure & Encrypted</span><span>Trusted by 10,000+ Users</span><span>Know Your Score Before Applying for Loan</span><span>Soft Inquiry — No Score Impact</span>
  </div>
</div>

<!-- NAVBAR -->
<nav>
  <a href="https://propgurus.in" class="nav-logo">
    <div class="nav-mark">P</div>
    <span class="nav-name">PROPGURUS</span>
  </a>
  <div class="nav-links">
    <a href="https://propgurus.in">Home</a>
    <a href="https://propgurus.in/properties">Properties</a>
    <a href="#" class="active">Credit Score</a>
    <a href="https://propgurus.in/contact">Contact</a>
  </div>
  <a href="#formSection" class="nav-btn">Check My Score</a>
</nav>

<!-- HERO -->
<section class="hero">
  <div class="hero-canvas"></div>
  <div class="hero-grid"></div>
  <div class="hero-inner">
    <div class="hero-eyebrow">India's Trusted Credit Check Platform</div>
    <h1>Know Your <em>Credit Score</em><br>Before Your Next Loan</h1>
    <p class="hero-sub">Get your official Transunion CIBIL credit report instantly. Understand your financial health and make smarter decisions — in under 2 minutes.</p>
    <div class="hero-stats">
      <div class="hstat"><span class="hstat-val">10,000+</span><span class="hstat-key">Reports Generated</span></div>
      <div class="hstat"><span class="hstat-val">~2 Min</span><span class="hstat-key">Delivery Time</span></div>
      <div class="hstat"><span class="hstat-val">256-bit</span><span class="hstat-key">SSL Encrypted</span></div>
      <div class="hstat"><span class="hstat-val">₹100</span><span class="hstat-key">One-Time Only</span></div>
    </div>
    <button class="hero-cta" onclick="document.getElementById('formSection').scrollIntoView({behavior:'smooth'})">
      Get My Credit Report <span class="cta-arr">→</span>
    </button>
    <p class="hero-note"><strong>✓ Soft inquiry</strong> — your score is never affected</p>
  </div>
</section>

<!-- SCORE BANDS -->
<section class="band-sec">
  <div class="container">
    <div class="sec-hd">
      <h2>What Does Your <em>Score Mean?</em></h2>
      <p>Credit scores range from 300 to 900 — the higher, the better your loan prospects</p>
    </div>
    <div class="bands">
      <div class="band bp"><div class="band-r">300–549</div><div class="band-l">Poor</div><div class="band-d">Very difficult to get approval</div></div>
      <div class="band bf"><div class="band-r">550–649</div><div class="band-l">Fair</div><div class="band-d">Limited options, higher rates</div></div>
      <div class="band bg"><div class="band-r">650–699</div><div class="band-l">Good</div><div class="band-d">Decent approval chances</div></div>
      <div class="band bv"><div class="band-r">700–749</div><div class="band-l">Very Good</div><div class="band-d">Good loan terms available</div></div>
      <div class="band be"><div class="band-r">750–900</div><div class="band-l">Excellent</div><div class="band-d">Best rates & easy approvals</div></div>
    </div>
  </div>
</section>

<!-- FORM SECTION -->
<section class="form-sec" id="formSection">
  <div class="form-wrap">
    <div class="sec-hd" style="margin-bottom:36px">
      <h2>Get Your <em>Credit Report</em></h2>
      <p>Complete in under 2 minutes — fully secure</p>
    </div>

    <div class="form-card">
      <!-- Header -->
      <div class="form-head">
        <div class="head-ico">📋</div>
        <div class="head-txt">
          <h2>Credit Report Request</h2>
          <p>Powered by Transunion CIBIL V3 <span>·</span> End-to-End Encrypted</p>
        </div>
      </div>

      <!-- Steps -->
      <div class="steps">
        <div class="step active" id="s1"><span class="step-b">1</span>Details</div>
        <div class="step" id="s2"><span class="step-b">2</span>Payment</div>
        <div class="step" id="s3"><span class="step-b">3</span>Report</div>
      </div>

      <div class="form-body">
        <div class="alert" id="alertBox"></div>

        <!-- STEP 1 -->
        <div class="fp active" id="fp1">
          <div class="fg">
            <label>Mobile Number<span class="req"> *</span></label>
            <div class="mob-row">
              <div class="mob-cc">🇮🇳 +91</div>
              <input type="tel" class="fc" id="mobile" maxlength="10" placeholder="10-digit mobile number" inputmode="numeric">
            </div>
            <div class="prefill-ok" id="prefillTag">Details auto-filled from your mobile</div>
          </div>

          <div class="row2">
            <div class="fg">
              <label>Full Name<span class="req"> *</span></label>
              <input type="text" class="fc" id="fullName" placeholder="As per PAN card">
            </div>
            <div class="fg">
              <label>Gender<span class="req"> *</span></label>
              <select class="fc" id="gender">
                <option value="">Select</option>
                <option value="male">Male</option>
                <option value="female">Female</option>
              </select>
            </div>
          </div>

          <div class="fg">
            <label>PAN Number<span class="req"> *</span></label>
            <input type="text" class="fc" id="pan" maxlength="10" placeholder="E.G.  ABCDE1234F">
          </div>

          <div class="fg">
            <div class="consent" onclick="toggleConsent()">
              <input type="checkbox" id="consent" checked>
              <p>I authorise <strong>PropGurus</strong> to access my credit information from Transunion CIBIL. I understand this is a soft inquiry and will not impact my credit score.</p>
            </div>
          </div>

          <button class="btn-gold" onclick="goStep2()">Continue to Payment →</button>
          <div class="secure-line">
            <strong>🔒 SSL Secured</strong>
            <div class="dot"></div>
            <span>Your data is never shared</span>
          </div>
        </div>

        <!-- STEP 2 -->
        <div class="fp" id="fp2">
          <p class="pay-intro">One-time access fee</p>
          <div class="pay-box">
            <div class="pay-amt">₹100</div>
            <div class="pay-sub">Credit Report Fee</div>
            <div class="pay-perks">
              <div class="perk"><div class="perk-dot"></div>Full Transunion CIBIL Credit Report</div>
              <div class="perk"><div class="perk-dot"></div>Credit Score (300–900 Range)</div>
              <div class="perk"><div class="perk-dot"></div>Complete Account History & Summary</div>
            </div>
          </div>
          <div class="pay-feats">
            <div class="pf">CIBIL V3 Report</div>
            <div class="pf">Instant Delivery</div>
            <div class="pf">Soft Inquiry Only</div>
            <div class="pf">100% Secure</div>
            <div class="pf">PAN Verified</div>
            <div class="pf">Razorpay Secured</div>
          </div>
          <button class="btn-gold" id="payBtn" onclick="initiatePayment()">🔐 Pay ₹100 & Get Report</button>
          <p class="pay-terms" style="margin-top:12px">By proceeding you agree to our <a href="#">Terms</a> & <a href="#">Privacy Policy</a></p>
          <button class="btn-ghost" onclick="goStep1()">← Go Back</button>
        </div>

        <!-- STEP 3 -->
        <div class="fp" id="fp3">
          <div class="state" id="stLoading">
            <span class="state-ico">⏳</span>
            <h3 style="color:var(--white)">Fetching Your Report</h3>
            <p>Connecting to Transunion CIBIL servers.<br>This only takes a moment.</p>
            <div class="loader"></div>
          </div>
          <div class="state" id="stDone" style="display:none">
            <span class="state-ico">✅</span>
            <h3 style="color:var(--g2)">Report Ready</h3>
            <p>Your credit report has been fetched successfully.<br>Scroll down to view the full details.</p>
            <button class="btn-gold" style="margin-top:22px" onclick="document.getElementById('reportSection').scrollIntoView({behavior:'smooth'})">View My Report ↓</button>
          </div>
          <div class="state" id="stError" style="display:none">
            <span class="state-ico">❌</span>
            <h3 style="color:var(--red)" id="errMsg">Something went wrong</h3>
            <p>Please try again or contact our support team.</p>
            <button class="btn-gold" style="margin-top:22px" onclick="resetForm()">Try Again</button>
          </div>
        </div>

      </div><!-- /form-body -->
    </div><!-- /form-card -->
  </div>
</section>

<!-- REPORT SECTION -->
<section id="reportSection">
  <div class="report-wrap">
    <div class="report-toolbar">
      <button class="tbtn" onclick="window.print()">🖨 Print Report</button>
      <button class="tbtn" onclick="resetForm()">↩ New Report</button>
    </div>
    <div class="report-top" id="reportTop">
      <div class="score-dial" id="scoreDial">
        <div class="score-dial-inner">
          <div class="sdial-num" id="rScore">—</div>
          <div class="sdial-max">/ 900</div>
          <div class="sdial-lbl" id="rScoreLbl">—</div>
        </div>
      </div>
      <div class="rdetails">
        <h2 id="rName">—</h2>
        <div class="rpan" id="rPan">PAN: —</div>
        <div class="rmeta">
          <div class="rmeta-item"><div class="rmeta-key">Date of Birth</div><div class="rmeta-val" id="rDob">—</div></div>
          <div class="rmeta-item"><div class="rmeta-key">Gender</div><div class="rmeta-val" id="rGender">—</div></div>
          <div class="rmeta-item"><div class="rmeta-key">Mobile</div><div class="rmeta-val" id="rMobile">—</div></div>
          <div class="rmeta-item"><div class="rmeta-key">Report Date</div><div class="rmeta-val" id="rDate">—</div></div>
        </div>
      </div>
    </div>
    <div class="report-grid" id="reportCards"></div>
  </div>
</section>

<!-- HOW IT WORKS -->
<section class="how-sec">
  <div class="container">
    <div class="sec-hd">
      <h2>How It <em>Works</em></h2>
      <p>Three steps to your complete credit picture</p>
    </div>
    <div class="how-steps">
      <div class="how-card">
        <div class="how-ico">📝<span class="how-num">1</span></div>
        <h3>Fill Details</h3>
        <p>Enter your mobile, name, PAN and gender. All information stays confidential.</p>
      </div>
      <div class="how-arr">→</div>
      <div class="how-card">
        <div class="how-ico">💳<span class="how-num">2</span></div>
        <h3>Pay ₹100</h3>
        <p>One-time secure payment via Razorpay. UPI, cards, and net banking accepted.</p>
      </div>
      <div class="how-arr">→</div>
      <div class="how-card">
        <div class="how-ico">📊<span class="how-num">3</span></div>
        <h3>View Report</h3>
        <p>Your Transunion CIBIL report is fetched instantly and shown on screen.</p>
      </div>
    </div>
  </div>
</section>

<!-- TRUST -->
<section class="trust-sec">
  <div class="container">
    <div class="sec-hd"><h2>Why <em>Trust Us?</em></h2></div>
    <div class="trust-grid">
      <div class="trust-card"><div class="trust-ico">🔒</div><h4>Bank-Grade Security</h4><p>256-bit SSL encryption keeps every piece of your data protected at all times.</p></div>
      <div class="trust-card"><div class="trust-ico">🏦</div><h4>Official Data Source</h4><p>Credit data sourced directly from Transunion CIBIL — India's premier credit bureau.</p></div>
      <div class="trust-card"><div class="trust-ico">⚡</div><h4>Instant Results</h4><p>No waiting. Your report appears on-screen in under 2 minutes after payment.</p></div>
      <div class="trust-card"><div class="trust-ico">🛡️</div><h4>No Score Impact</h4><p>Soft inquiries only — checking here will never reduce your credit score.</p></div>
    </div>
  </div>
</section>

<!-- FAQ -->
<section class="faq-sec">
  <div class="container">
    <div class="sec-hd"><h2>Frequently Asked <em>Questions</em></h2></div>
    <div class="faq-list">
      <div class="faq-item">
        <div class="faq-q" onclick="toggleFaq(this)">Will checking my score affect it?<div class="faq-tog">+</div></div>
        <div class="faq-a"><p>No. We perform a soft inquiry which does not affect your credit score in any way. Only hard inquiries — like a bank checking for a loan application — can impact your score.</p></div>
      </div>
      <div class="faq-item">
        <div class="faq-q" onclick="toggleFaq(this)">What is the ₹100 fee for?<div class="faq-tog">+</div></div>
        <div class="faq-a"><p>The ₹100 covers the cost of fetching your official Transunion CIBIL credit report in real-time. This is a one-time charge per report request with no hidden fees.</p></div>
      </div>
      <div class="faq-item">
        <div class="faq-q" onclick="toggleFaq(this)">Is my personal data safe?<div class="faq-tog">+</div></div>
        <div class="faq-a"><p>Absolutely. Your data is encrypted with 256-bit SSL, processed in a secure environment, and never shared with any third parties without your explicit consent.</p></div>
      </div>
      <div class="faq-item">
        <div class="faq-q" onclick="toggleFaq(this)">How long does it take?<div class="faq-tog">+</div></div>
        <div class="faq-a"><p>Typically under 2 minutes. Once payment is confirmed, your report is fetched directly from Transunion servers and displayed on screen immediately.</p></div>
      </div>
      <div class="faq-item">
        <div class="faq-q" onclick="toggleFaq(this)">What information do I need?<div class="faq-tog">+</div></div>
        <div class="faq-a"><p>Just your mobile number, full name as per PAN card, your PAN number, and your gender. No bank account details required.</p></div>
      </div>
    </div>
  </div>
</section>

<!-- FOOTER -->
<footer>
  <div class="f-brand">PROPGURUS</div>
  <div class="f-tag">Your Trusted Real Estate & Finance Partner</div>
  <div class="f-links">
    <a href="https://propgurus.in">Home</a>
    <a href="#">Properties</a>
    <a href="#">Credit Score</a>
    <a href="#">Privacy Policy</a>
    <a href="#">Terms of Service</a>
    <a href="#">Contact</a>
  </div>
  <p class="f-legal">PropGurus is an authorized service provider for Transunion CIBIL credit information. All transactions secured by Razorpay. Credit reports are for informational purposes only.</p>
  <div class="f-copy">© <?= date('Y') ?> PropGurus.in · All Rights Reserved</div>
</footer>

<script>
const RAZORPAY_KEY = '<?= RAZORPAY_KEY_ID ?>';
let formData = {};

// ── MOBILE PREFILL ──
const mobileEl = document.getElementById('mobile');
let prefillTimer;
mobileEl.addEventListener('input', function(){
  this.value = this.value.replace(/\D/g,'').slice(0,10);
  clearTimeout(prefillTimer);
  if(this.value.length === 10) prefillTimer = setTimeout(() => doPrefill(this.value), 700);
});

async function doPrefill(m){
  try {
    const r = await fetch('', {method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body:`action=prefill&mobile=${m}`});
    const j = await r.json();
    if(j.success && j.data?.data){
      const d = j.data.data;
      if(d.full_name)          document.getElementById('fullName').value = d.full_name;
      if(d.gender)             document.getElementById('gender').value   = d.gender.toLowerCase();
      if(d.pan_number?.[0])   document.getElementById('pan').value      = d.pan_number[0].toUpperCase();
      const t = document.getElementById('prefillTag');
      t.classList.add('show');
      setTimeout(() => t.classList.remove('show'), 4000);
    }
  } catch(e){}
}

document.getElementById('pan').addEventListener('input', function(){ this.value = this.value.toUpperCase(); });
function toggleConsent(){ const c = document.getElementById('consent'); c.checked = !c.checked; }

// ── ALERTS ──
function showAlert(msg){
  const el = document.getElementById('alertBox');
  el.textContent = '⚠ ' + msg;
  el.classList.add('show');
  el.scrollIntoView({behavior:'smooth', block:'nearest'});
}
function hideAlert(){ document.getElementById('alertBox').classList.remove('show'); }

// ── STEP CONTROL ──
function setStep(n){
  ['fp1','fp2','fp3'].forEach((id,i) => document.getElementById(id).classList.toggle('active', i+1===n));
  ['s1','s2','s3'].forEach((id,i) => {
    const el = document.getElementById(id);
    el.classList.remove('active','done');
    if(i+1 < n){ el.classList.add('done'); el.querySelector('.step-b').textContent = '✓'; }
    else { el.querySelector('.step-b').textContent = i+1; }
    if(i+1 === n) el.classList.add('active');
  });
}

function goStep2(){
  hideAlert();
  const mobile  = mobileEl.value.trim();
  const name    = document.getElementById('fullName').value.trim();
  const pan     = document.getElementById('pan').value.trim().toUpperCase();
  const gender  = document.getElementById('gender').value;
  const consent = document.getElementById('consent').checked;
  if(mobile.length !== 10)                          return showAlert('Enter a valid 10-digit mobile number.');
  if(!name)                                          return showAlert('Enter your full name as per PAN card.');
  if(!/^[A-Z]{5}[0-9]{4}[A-Z]$/.test(pan))         return showAlert('Enter a valid PAN number (e.g. ABCDE1234F).');
  if(!gender)                                        return showAlert('Please select your gender.');
  if(!consent)                                       return showAlert('Please provide consent to proceed.');
  formData = {mobile, name, pan, gender};
  setStep(2);
}

function goStep1(){ setStep(1); }

// ── RAZORPAY PAYMENT ──
function initiatePayment(){
  const btn = document.getElementById('payBtn');
  btn.disabled = true;
  btn.innerHTML = '<span style="display:inline-block;width:15px;height:15px;border:2.5px solid rgba(0,0,0,.25);border-top-color:var(--ink);border-radius:50%;animation:spin .7s linear infinite;vertical-align:middle;margin-right:8px"></span>Processing...';

  // ── Uncomment when Razorpay keys are ready ──
  /*
  const options = {
    key: RAZORPAY_KEY,
    amount: 10000,
    currency: 'INR',
    name: 'PropGurus',
    description: 'Transunion Credit Report',
    handler: response => verifyAndFetch(response),
    prefill: { name: formData.name, contact: '91' + formData.mobile },
    theme: { color: '#c9970f' },
    modal: {
      ondismiss: () => {
        btn.disabled = false;
        btn.innerHTML = '🔐 Pay ₹100 & Get Report';
      }
    }
  };
  new Razorpay(options).open();
  */

  // DEMO — remove after adding Razorpay keys
  setTimeout(() => verifyAndFetch({razorpay_payment_id: 'DEMO_' + Date.now()}), 1500);
}

// ── FETCH REPORT ──
async function verifyAndFetch(payment){
  setStep(3);
  show('stLoading'); hide('stDone'); hide('stError');
  try {
    const res = await fetch('', {
      method: 'POST',
      headers: {'Content-Type':'application/x-www-form-urlencoded'},
      body: `action=fetch_report`
          + `&name=${enc(formData.name)}`
          + `&mobile=${enc(formData.mobile)}`
          + `&pan=${enc(formData.pan)}`
          + `&gender=${enc(formData.gender)}`
          + `&consent=Y`
          + `&payment_id=${enc(payment.razorpay_payment_id || '')}`
    });
    const json = await res.json();
    hide('stLoading');
    if(json.success){
      renderReport(json.data);
      show('stDone');
    } else {
      document.getElementById('errMsg').textContent = json.message || 'API Error. Please contact support.';
      show('stError');
    }
  } catch(e){
    hide('stLoading');
    document.getElementById('errMsg').textContent = 'Network error. Please check your connection.';
    show('stError');
  }
}

// ── RENDER REPORT ──
function renderReport(apiData){
  const d        = apiData?.data || {};
  const report   = d?.CCRResponse?.CIRReportDataLst?.[0]?.CIRReportData || {};
  const score    = report?.ScoreDetails?.[0]?.Value || d?.score || 'N/A';
  const personal = report?.IDAndContactInfo?.PersonalInfo || {};
  const accounts = report?.RetailAccountDetails || [];
  const summary  = report?.RetailAccountsSummary || {};
  const inquiries= report?.TotalInquiriesInLast6Months || 0;

  // Score colour & label
  const s = parseInt(score);
  let sc = '#e04848', sl = 'Poor';
  if(s >= 750){ sc = '#1db954'; sl = 'Excellent'; }
  else if(s >= 700){ sc = '#5ec97a'; sl = 'Very Good'; }
  else if(s >= 650){ sc = '#e8b830'; sl = 'Good'; }
  else if(s >= 550){ sc = '#e07d30'; sl = 'Fair'; }

  // Dial
  const pct = Math.max(0, Math.round(((s - 300) / 600) * 360));
  const dial = document.getElementById('scoreDial');
  dial.style.background = `conic-gradient(${sc} 0deg, ${sc} ${pct}deg, var(--ink4) ${pct}deg, var(--ink4) 360deg)`;

  const rScore = document.getElementById('rScore');
  rScore.textContent = score; rScore.style.color = sc;
  const rLbl = document.getElementById('rScoreLbl');
  rLbl.textContent = sl; rLbl.style.background = sc + '22'; rLbl.style.color = sc;

  // Personal details
  const fn = ((personal?.Name?.FirstName || formData.name) + ' ' + (personal?.Name?.LastName || '')).trim();
  document.getElementById('rName').textContent   = fn;
  document.getElementById('rPan').textContent    = 'PAN: ' + formData.pan;
  document.getElementById('rDob').textContent    = personal?.DateOfBirth || d?.data?.dob || '—';
  document.getElementById('rGender').textContent = (personal?.Gender || formData.gender || '—').toUpperCase();
  document.getElementById('rMobile').textContent = '+91 ' + formData.mobile;
  document.getElementById('rDate').textContent   = new Date().toLocaleDateString('en-IN',{day:'2-digit',month:'short',year:'numeric'});

  // Aggregates
  const totalAcc    = summary?.NofOpenAccounts || accounts.length || 0;
  const activeAcc   = accounts.filter(a => (a.AccountStatus||'').toLowerCase().includes('active')).length;
  const overdueAcc  = accounts.filter(a => (a.AccountStatus||'').toLowerCase().includes('overdue')).length;
  const totalBal    = accounts.reduce((s,a) => s + parseInt(a.CurrentBalance||0), 0);
  const totalSan    = accounts.reduce((s,a) => s + parseInt(a.SanctionedAmount||0), 0);

  let accRows = '';
  if(accounts.length){
    accounts.slice(0,6).forEach(a => {
      const st = (a.AccountStatus||'active').toLowerCase();
      const badge = st.includes('active')  ? '<span class="badge b-active">Active</span>'
                  : st.includes('overdue') ? '<span class="badge b-overdue">Overdue</span>'
                  : '<span class="badge b-closed">Closed</span>';
      accRows += `<div class="row-item"><span class="ri-label">${a.Institution||a.SubscriberName||'Bank'}</span><span>${badge}</span></div>`;
    });
  } else {
    accRows = '<div class="row-item"><span class="ri-label" style="color:var(--muted)">No accounts on record</span></div>';
  }

  document.getElementById('reportCards').innerHTML = `
    <div class="rcard">
      <div class="rcard-title">Account Summary</div>
      <div class="row-item"><span class="ri-label">Total Accounts</span><span class="ri-val">${totalAcc}</span></div>
      <div class="row-item"><span class="ri-label">Active Accounts</span><span class="ri-val" style="color:var(--green)">${activeAcc}</span></div>
      <div class="row-item"><span class="ri-label">Overdue Accounts</span><span class="ri-val" style="color:var(--red)">${overdueAcc}</span></div>
      <div class="row-item"><span class="ri-label">Inquiries (6 months)</span><span class="ri-val">${inquiries}</span></div>
    </div>
    <div class="rcard">
      <div class="rcard-title">Credit Exposure</div>
      <div class="row-item"><span class="ri-label">Total Sanctioned</span><span class="ri-val">₹${totalSan.toLocaleString('en-IN')}</span></div>
      <div class="row-item"><span class="ri-label">Current Balance</span><span class="ri-val">₹${totalBal.toLocaleString('en-IN')}</span></div>
      <div class="row-item"><span class="ri-label">Utilization</span><span class="ri-val">${totalSan ? Math.round((totalBal/totalSan)*100)+'%' : 'N/A'}</span></div>
    </div>
    <div class="rcard" style="grid-column:1/-1">
      <div class="rcard-title">Credit Accounts</div>
      ${accRows}
    </div>`;

  document.getElementById('reportSection').style.display = 'block';
  setTimeout(() => document.getElementById('reportSection').scrollIntoView({behavior:'smooth'}), 300);
}

// ── UTILITIES ──
const enc = encodeURIComponent;
function show(id){ document.getElementById(id).style.display = 'block'; }
function hide(id){ document.getElementById(id).style.display = 'none'; }

function resetForm(){
  setStep(1);
  ['mobile','fullName','pan'].forEach(id => document.getElementById(id).value = '');
  document.getElementById('gender').value = '';
  document.getElementById('consent').checked = true;
  document.getElementById('reportSection').style.display = 'none';
  const btn = document.getElementById('payBtn');
  btn.disabled = false; btn.innerHTML = '🔐 Pay ₹100 & Get Report';
  hideAlert();
  window.scrollTo({top:0, behavior:'smooth'});
}

function toggleFaq(el){
  el.classList.toggle('open');
  el.nextElementSibling.classList.toggle('open');
}
</script>
</body>
</html>